/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.logging;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import java.io.File;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class MythicLogger {
    public static void log(String message) {
        MythicBukkit.inst().getLogger().log(Level.INFO, message + String.valueOf((Object)ConsoleColor.RESET));
    }

    public static void log(String message, Object ... params) {
        MythicBukkit.inst().getLogger().log(Level.INFO, message + String.valueOf((Object)ConsoleColor.RESET), params);
    }

    public static void log(Level level, String message) {
        MythicBukkit.inst().getLogger().log(level, message + String.valueOf((Object)ConsoleColor.RESET));
    }

    public static void log(Level level, String message, Object ... params) {
        MythicBukkit.inst().getLogger().log(level, message + String.valueOf((Object)ConsoleColor.RESET), params);
    }

    public static void error(String message) {
        MythicLogger.log(Level.WARNING, message + String.valueOf((Object)ConsoleColor.RESET));
    }

    public static void error(SkillCaster caster, String message) {
        String source;
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            source = String.valueOf((Object)ConsoleColor.PURPLE) + "[" + String.valueOf((Object)ConsoleColor.YELLOW) + "MobType=" + am.getType().getInternalName() + String.valueOf((Object)ConsoleColor.PURPLE) + "]";
        } else {
            source = String.valueOf((Object)ConsoleColor.PURPLE) + "[" + String.valueOf((Object)ConsoleColor.YELLOW) + "Caster=" + caster.getName() + String.valueOf((Object)ConsoleColor.PURPLE) + "]";
        }
        MythicLogger.log(Level.WARNING, source + " " + message + String.valueOf((Object)ConsoleColor.RESET));
    }

    public static void error(String message, Object ... params) {
        MythicLogger.log(Level.WARNING, message + String.valueOf((Object)ConsoleColor.RESET), params);
    }

    public static void error(SkillCaster caster, String message, Object ... params) {
        String source;
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            source = String.valueOf((Object)ConsoleColor.PURPLE) + "[" + String.valueOf((Object)ConsoleColor.YELLOW) + "MobType=" + am.getType().getInternalName() + String.valueOf((Object)ConsoleColor.PURPLE) + "]";
        } else {
            source = String.valueOf((Object)ConsoleColor.PURPLE) + "[" + String.valueOf((Object)ConsoleColor.YELLOW) + "Caster=" + caster.getName() + String.valueOf((Object)ConsoleColor.PURPLE) + "]";
        }
        MythicLogger.log(Level.WARNING, source + " " + message + String.valueOf((Object)ConsoleColor.RESET), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex) {
        MythicLogger.log(Level.SEVERE, message + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() > 0) {
            ex.printStackTrace();
        }
        if (MythicBukkit.inst().getConfiguration().getDoErrorLogging().booleanValue()) {
            try (PrintWriter writer = null;){
                File folder;
                File logsFolder = new File(MythicBukkit.inst().getDataFolder(), "logs");
                if (!logsFolder.exists()) {
                    logsFolder.mkdir();
                }
                if (!(folder = new File(logsFolder, "errors")).exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
                    t2.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the logs/errors folder. Please report it on the MythicCraft Issue Tracker or discord.");
                writer.println("Mythic version: " + MythicBukkit.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String message, Throwable ex, Object ... params) {
        MythicLogger.log(Level.SEVERE, message + String.valueOf((Object)ConsoleColor.RESET), params);
        MythicLogger.log(Level.SEVERE, "    " + ex.getMessage() + " (" + ex.getClass().getName() + ")");
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() > 0) {
            ex.printStackTrace();
        }
        if (MythicBukkit.inst().getConfiguration().getDoErrorLogging().booleanValue()) {
            try (PrintWriter writer = null;){
                File folder;
                File logsFolder = new File(MythicBukkit.inst().getDataFolder(), "logs");
                if (!logsFolder.exists()) {
                    logsFolder.mkdir();
                }
                if (!(folder = new File(logsFolder, "errors")).exists()) {
                    folder.mkdir();
                }
                writer = new PrintWriter(new File(folder, System.currentTimeMillis() + ".txt"));
                for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
                    t2.printStackTrace(writer);
                    writer.println();
                }
                MythicLogger.error("This error has been saved in the Error Logs folder. Please report it on the MythicCraft Issue Tracker or discord.");
                writer.println("Mythic version: " + MythicBukkit.inst().getDescription().getVersion());
                writer.println("Bukkit version: " + Bukkit.getServer().getVersion());
            }
        } else {
            ex.printStackTrace();
        }
    }

    public static void handleMinorError(Throwable ex) {
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() > 0) {
            ex.printStackTrace();
        }
    }

    public static void errorYMLConfig(File file, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Failed to load YML File");
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + file.getAbsolutePath());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorGenericConfig(String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + " Configuration Error: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorGenericConfig(MythicConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error");
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFile().getAbsolutePath());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorGenericConfig(MythicLineConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error");
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFileName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Line: " + String.valueOf((Object)ConsoleColor.RESET) + config.getLine());
    }

    public static void errorMobConfig(MythicMob mob, MythicConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in Mob " + String.valueOf((Object)ConsoleColor.CYAN) + mob.getInternalName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFile().getAbsolutePath());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorEntityConfig(BukkitEntityType entity, MythicConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Entity Configuration Error in Mob " + String.valueOf((Object)ConsoleColor.CYAN) + config.getKey());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFile().getAbsolutePath());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorMechanic(SkillMechanic mechanic, String error) {
        MythicLogger.errorMechanic(mechanic, error, null);
    }

    public static void errorMechanic(SkillMechanic mechanic, String error, Throwable ex) {
        Object parentString;
        Optional<SkillHolder> maybeParent = mechanic.getParent();
        MythicLineConfig config = mechanic.getConfig();
        if (maybeParent.isEmpty()) {
            parentString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof MobType) {
                MobType mobType = (MobType)skillHolder;
                parentString = "Mob: " + String.valueOf((Object)ConsoleColor.WHITE) + mobType.getInternalName() + String.valueOf((Object)ConsoleColor.CYAN) + " | " + String.valueOf((Object)ConsoleColor.RED);
            } else {
                parentString = "Skill: " + String.valueOf((Object)ConsoleColor.WHITE) + maybeParent.get().getInternalName() + String.valueOf((Object)ConsoleColor.CYAN) + " | " + String.valueOf((Object)ConsoleColor.RED);
            }
        }
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " An Error Occurred in Mechanic " + String.valueOf((Object)ConsoleColor.CYAN) + mechanic.getTypeName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + (String)parentString + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + mechanic.getFilePath());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Mechanic: " + String.valueOf((Object)ConsoleColor.RESET) + config.getLine());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error: " + String.valueOf((Object)ConsoleColor.RESET) + error);
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    public static void errorMechanicConfig(SkillMechanic mechanic, MythicLineConfig config, String error) {
        Object parentString;
        Optional<SkillHolder> maybeParent = mechanic.getParent();
        if (maybeParent.isEmpty()) {
            parentString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof MobType) {
                MobType mobType = (MobType)skillHolder;
                parentString = "Mob: " + String.valueOf((Object)ConsoleColor.CYAN) + mobType.getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
            } else {
                parentString = "Skill: " + String.valueOf((Object)ConsoleColor.CYAN) + maybeParent.get().getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
            }
        }
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in Mechanic " + String.valueOf((Object)ConsoleColor.CYAN) + mechanic.getTypeName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + (String)parentString + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + mechanic.getFilePath());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Mechanic Line: " + String.valueOf((Object)ConsoleColor.RESET) + config.getLine());
    }

    public static void errorCondition(SkillCondition condition, String error) {
        MythicLogger.errorCondition(condition, error, null);
    }

    public static void errorCondition(SkillCondition condition, String error, Throwable ex) {
        String fileString;
        Object parentString;
        Optional<SkillHolder> maybeParent = condition.getParent();
        if (maybeParent.isEmpty()) {
            parentString = "";
            fileString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof SkillMechanic) {
                SkillMechanic mechanic = (SkillMechanic)skillHolder;
                parentString = "Mechanic: " + String.valueOf((Object)ConsoleColor.CYAN) + mechanic.getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
                fileString = mechanic.getConfig().getFileName();
            } else {
                skillHolder = maybeParent.get();
                if (skillHolder instanceof MetaSkill) {
                    MetaSkill metaSkill = (MetaSkill)skillHolder;
                    parentString = "Mechanic: " + String.valueOf((Object)ConsoleColor.CYAN) + metaSkill.getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
                    fileString = metaSkill.getFile().getAbsolutePath();
                } else {
                    parentString = "Skill: " + String.valueOf((Object)ConsoleColor.CYAN) + maybeParent.get().getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
                    fileString = "";
                }
            }
        }
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in Condition " + String.valueOf((Object)ConsoleColor.CYAN) + condition.getTypeName());
        if (!((String)parentString).isEmpty() || !fileString.isEmpty()) {
            MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + (String)parentString + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + fileString);
        }
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Condition Line: " + String.valueOf((Object)ConsoleColor.RESET) + condition.getLine());
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    public static void errorConditionConfig(SkillCondition condition, MythicLineConfig config, String error) {
        Object parentString;
        Optional<SkillHolder> maybeParent = condition.getParent();
        if (maybeParent.isEmpty()) {
            parentString = "";
        } else {
            SkillHolder skillHolder = maybeParent.get();
            if (skillHolder instanceof SkillMechanic) {
                SkillMechanic mechanic = (SkillMechanic)skillHolder;
                parentString = "Mechanic: " + String.valueOf((Object)ConsoleColor.CYAN) + mechanic.getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
            } else {
                parentString = "Skill: " + String.valueOf((Object)ConsoleColor.CYAN) + maybeParent.get().getInternalName() + String.valueOf((Object)ConsoleColor.WHITE) + " | " + String.valueOf((Object)ConsoleColor.RED);
            }
        }
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in Condition " + String.valueOf((Object)ConsoleColor.CYAN) + condition.getTypeName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + (String)parentString + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFileName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.YELLOW) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.YELLOW) + "Mechanic Line: " + String.valueOf((Object)ConsoleColor.RESET) + config.getLine());
    }

    public static void errorItemConfig(MythicItem item, MythicConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in Item " + String.valueOf((Object)ConsoleColor.CYAN) + config.getKey());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFileName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorDropConfig(Drop drop, MythicLineConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in Drop " + String.valueOf((Object)ConsoleColor.CYAN) + drop.getLine());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFileName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorDropTableConfig(DropTable drop, MythicLineConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in DropTable " + String.valueOf((Object)ConsoleColor.CYAN) + drop.getInternalName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + config.getFileName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorTargeterConfig(SkillTargeter targeter, MythicLineConfig config, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.YELLOW) + " Config Error for Targeter line '" + String.valueOf((Object)ConsoleColor.UNDERLINE) + config.getLine() + String.valueOf((Object)ConsoleColor.RESET) + String.valueOf((Object)ConsoleColor.YELLOW) + "': " + String.valueOf((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorTargeterConfig(SkillTargeter targeter, SkillCaster caster, MythicLineConfig config, String error) {
        MythicLogger.error(caster, String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.YELLOW) + " Config Error for Targeter line '" + String.valueOf((Object)ConsoleColor.UNDERLINE) + config.getLine() + String.valueOf((Object)ConsoleColor.RESET) + String.valueOf((Object)ConsoleColor.YELLOW) + "': " + String.valueOf((Object)ConsoleColor.WHITE) + error);
    }

    public static void errorSpawnConfig(RandomSpawner spawner, MythicConfig config, String error) {
        String fileName = config.getFile() == null ? "Unknown" : config.getFile().getAbsolutePath();
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.RED) + String.valueOf((Object)ConsoleColor.BOLD) + " Configuration Error in RandomSpawn " + String.valueOf((Object)ConsoleColor.CYAN) + spawner.getName());
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.RED) + "File: " + String.valueOf((Object)ConsoleColor.WHITE) + fileName);
        MythicLogger.error("--| " + String.valueOf((Object)ConsoleColor.PURPLE) + "Error Message: " + String.valueOf((Object)ConsoleColor.RESET) + error);
    }

    public static void errorCompatibility(String plugin, String error) {
        MythicLogger.error(String.valueOf((Object)ConsoleColor.ERROR_MARK) + String.valueOf((Object)ConsoleColor.YELLOW) + " Compatibility Error for '" + String.valueOf((Object)ConsoleColor.UNDERLINE) + plugin + String.valueOf((Object)ConsoleColor.RESET) + String.valueOf((Object)ConsoleColor.YELLOW) + "': " + String.valueOf((Object)ConsoleColor.WHITE) + error);
    }

    public static void debug(DebugLevel level, String message, Object ... params) {
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() == 0) {
            return;
        }
        if (MythicBukkit.inst().getConfiguration().getDebugLevel() < level.ordinal()) {
            return;
        }
        switch (level.ordinal()) {
            case 1: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.CYAN) + "[i] " + message, params);
                return;
            }
            case 2: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.PURPLE) + "+--- " + String.valueOf((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case 3: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.PURPLE) + "|----- " + String.valueOf((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case 4: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.PURPLE) + "|------- " + String.valueOf((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case 5: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.PURPLE) + "~----------- " + String.valueOf((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case 6: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.PURPLE) + "|--------? " + String.valueOf((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case 7: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.PURPLE) + "#- " + String.valueOf((Object)ConsoleColor.CYAN) + message, params);
                return;
            }
            case 8: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.CYAN) + "[e] " + message, params);
                return;
            }
            case 9: {
                MythicLogger.log(Level.INFO, String.valueOf((Object)ConsoleColor.CYAN) + "[c] " + message, params);
                return;
            }
        }
    }

    private MythicLogger() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static enum DebugLevel {
        NONE,
        INFO,
        SKILL,
        SKILL_CHECK,
        SKILL_INFO,
        MECHANIC,
        CONDITION,
        TRIGGER,
        EVENT,
        CLOCK;

    }
}

