/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus;

import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.Menu;
import io.lumine.mythic.bukkit.utils.menu.MenuBuilder;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import java.awt.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ColorPickerMenu {
    private ItemStack COLOR_SWATCH_ITEM = new ItemStack(Material.LEATHER_BOOTS);
    private Menu<ColorMenuContext> colorPickerMenu;

    protected ColorPickerMenu() {
        int[] slots;
        MenuBuilder<ColorMenuContext> colorPickerMenu = Menu.builder().addIcon(22, IconBuilder.create().item((context, player) -> ItemFactory.of(Material.LEATHER_BOOTS).name("Current Color").hideAttributes().itemModel(NamespacedKey.fromString((String)"mythic:dye_block")).color(context.getBukkitColor())).build()).addIcon(45, IconBuilder.create().item((color, player) -> ItemFactory.of(Material.ARROW).name("Reduce Saturation")).click((context, player) -> {
            context.addSaturation(-0.1f);
            this.openMenu((Player)player, (ColorMenuContext)context);
        }).build()).addIcon(46, IconBuilder.create().item((color, player) -> ItemFactory.of(Material.ARROW).name("Increase Saturation")).click((context, player) -> {
            context.addSaturation(0.1f);
            this.openMenu((Player)player, (ColorMenuContext)context);
        }).build()).addIcon(48, IconBuilder.create().item((color, player) -> ItemFactory.of(Material.ARROW).name("Zoom In")).click((context, player) -> {
            context.zoomIn();
            this.openMenu((Player)player, (ColorMenuContext)context);
        }).build()).addIcon(49, IconBuilder.create().item((color, player) -> ItemFactory.of(Material.ARROW).name("Zoom Out")).click((context, player) -> {
            context.zoomOut();
            this.openMenu((Player)player, (ColorMenuContext)context);
        }).build()).addIcon(51, IconBuilder.create().item((color, player) -> ItemFactory.of(Material.OAK_SIGN).name("Enter Color")).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the Color you'd like to use.", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                try {
                    Chroma chroma = Chroma.of(input);
                    if (chroma == null) {
                        CommandHelper.sendError((CommandSender)player, "Invalid color format supplied");
                        return ChatPrompt.Response.TRY_AGAIN;
                    }
                    int red = chroma.red();
                    int green = chroma.green();
                    int blue = chroma.blue();
                    float[] color = Color.RGBtoHSB(red, green, blue, null);
                    context.setHue(color[0]);
                    context.setSaturation(color[1]);
                    context.setBrightness(color[2]);
                }
                catch (Throwable ex) {
                    CommandHelper.sendError((CommandSender)player, "Invalid color format supplied");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> this.openMenu((Player)player, (ColorMenuContext)context));
        }).build()).addIcon(53, IconBuilder.create().item((color, player) -> ItemFactory.of(Material.EMERALD_BLOCK)).click((context, color) -> context.complete()).build());
        for (int slot : slots = new int[]{18, 19, 20, 21, 23, 24, 25, 26, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44}) {
            colorPickerMenu.addIcon(slot, this.getColorSwatchIcon(slot));
        }
        this.colorPickerMenu = colorPickerMenu.title("Color Picker").build();
    }

    public Promise<Chroma> openMenu(Player player, Chroma color) {
        Promise<Chroma> promise = Promise.empty();
        ColorMenuContext state = new ColorMenuContext(color, promise);
        this.colorPickerMenu.open(player, state);
        return promise;
    }

    public void openMenu(Player player, ColorMenuContext state) {
        this.colorPickerMenu.open(player, state);
    }

    private Icon<ColorMenuContext> getColorSwatchIcon(int slot) {
        return IconBuilder.create().item((context, player) -> {
            float hue = (float)(slot % 9 - 4) * context.getHueStep();
            float brightness = (float)(2 - slot / 9) * context.getBrightnessStep();
            return ItemFactory.of(Material.LEATHER_BOOTS).name("").hideAttributes().itemModel(NamespacedKey.fromString((String)"mythic:dye_block")).color(context.getOffsetBukkitColor(hue, brightness));
        }).click((context, player) -> {
            float hue = (float)(slot % 9 - 4) * context.getHueStep();
            float brightness = (float)(2 - slot / 9) * context.getBrightnessStep();
            context.addHue(hue);
            context.addBrightness(brightness);
            this.openMenu((Player)player, (ColorMenuContext)context);
        }).build();
    }

    public static class ColorMenuContext {
        private float hue = 0.4f;
        private float saturation = 1.0f;
        private float brightness = 0.6f;
        private int zoomLevel = 5;
        private final Promise<Chroma> then;

        public ColorMenuContext(Chroma chroma, Promise<Chroma> then) {
            if (chroma == null) {
                this.zoomLevel = 6;
            } else {
                int red = chroma.red();
                int green = chroma.green();
                int blue = chroma.blue();
                float[] color = Color.RGBtoHSB(red, green, blue, null);
                this.hue = color[0];
                this.saturation = color[1];
                this.brightness = color[2];
            }
            this.then = then;
        }

        public Color getColor() {
            return Color.getHSBColor(this.hue, this.saturation, this.brightness);
        }

        public org.bukkit.Color getBukkitColor() {
            Color offset = this.getColor();
            return org.bukkit.Color.fromRGB((int)offset.getRed(), (int)offset.getGreen(), (int)offset.getBlue());
        }

        public Color getOffsetColor(float hue, float brightness) {
            float newhue = this.hue + hue;
            if (newhue < 0.0f) {
                newhue += 1.0f;
            } else if (newhue > 1.0f) {
                newhue -= 1.0f;
            }
            float newbrightness = Numbers.clamp(this.brightness + brightness, 0.0f, 1.0f);
            return Color.getHSBColor(newhue, this.saturation, newbrightness);
        }

        public org.bukkit.Color getOffsetBukkitColor(float hue, float brightness) {
            Color offset = this.getOffsetColor(hue, brightness);
            return org.bukkit.Color.fromRGB((int)offset.getRed(), (int)offset.getGreen(), (int)offset.getBlue());
        }

        public void addHue(float hue) {
            this.hue += hue;
            if (this.hue < 0.0f) {
                this.hue += 1.0f;
            } else if (hue > 1.0f) {
                this.hue -= 1.0f;
            }
        }

        public void addSaturation(float saturation) {
            this.saturation += saturation;
            this.saturation = Numbers.clamp(this.saturation, 0.0f, 1.0f);
        }

        public void addBrightness(float brightness) {
            this.brightness += brightness;
            this.brightness = Numbers.clamp(this.brightness, 0.0f, 1.0f);
        }

        public void complete() {
            Color color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
            Chroma chroma = Chroma.of(color.getRed(), color.getGreen(), color.getBlue());
            this.then.supply(chroma);
        }

        public float getHueStep() {
            return this.getBrightnessStep() / 2.0f;
        }

        public float getBrightnessStep() {
            return switch (this.zoomLevel) {
                case 0 -> 0.0025f;
                case 1 -> 0.005f;
                case 2 -> 0.01f;
                case 3 -> 0.025f;
                case 4 -> 0.05f;
                case 5 -> 0.1f;
                case 6 -> 0.2f;
                case 7 -> 0.25f;
                case 8 -> 0.333333f;
                case 9 -> 0.5f;
                default -> 0.1f;
            };
        }

        public void zoomIn() {
            if (this.zoomLevel > 0) {
                --this.zoomLevel;
            }
        }

        public void zoomOut() {
            if (this.zoomLevel < 9) {
                ++this.zoomLevel;
            }
        }

        public float getHue() {
            return this.hue;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getBrightness() {
            return this.brightness;
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public Promise<Chroma> getThen() {
            return this.then;
        }

        public void setHue(float hue) {
            this.hue = hue;
        }

        public void setSaturation(float saturation) {
            this.saturation = saturation;
        }

        public void setBrightness(float brightness) {
            this.brightness = brightness;
        }

        public void setZoomLevel(int zoomLevel) {
            this.zoomLevel = zoomLevel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColorMenuContext)) {
                return false;
            }
            ColorMenuContext other = (ColorMenuContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getHue(), other.getHue()) != 0) {
                return false;
            }
            if (Float.compare(this.getSaturation(), other.getSaturation()) != 0) {
                return false;
            }
            if (Float.compare(this.getBrightness(), other.getBrightness()) != 0) {
                return false;
            }
            if (this.getZoomLevel() != other.getZoomLevel()) {
                return false;
            }
            Promise<Chroma> this$then = this.getThen();
            Promise<Chroma> other$then = other.getThen();
            return !(this$then == null ? other$then != null : !this$then.equals(other$then));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColorMenuContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getHue());
            result = result * 59 + Float.floatToIntBits(this.getSaturation());
            result = result * 59 + Float.floatToIntBits(this.getBrightness());
            result = result * 59 + this.getZoomLevel();
            Promise<Chroma> $then = this.getThen();
            result = result * 59 + ($then == null ? 43 : $then.hashCode());
            return result;
        }

        public String toString() {
            return "ColorPickerMenu.ColorMenuContext(hue=" + this.getHue() + ", saturation=" + this.getSaturation() + ", brightness=" + this.getBrightness() + ", zoomLevel=" + this.getZoomLevel() + ", then=" + String.valueOf(this.getThen()) + ")";
        }
    }
}

