/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.custom;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CrucibleSupport;
import io.lumine.mythic.bukkit.utils.config.properties.types.MenuProp;
import io.lumine.mythic.bukkit.utils.menu.EditableIcon;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.menus.MythicMenu;
import io.lumine.mythic.core.menus.custom.CustomMenuBindingFunction;
import io.lumine.mythic.core.menus.custom.CustomMenuButtonFunction;
import io.lumine.mythic.core.menus.custom.CustomMenuContext;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;

public abstract class CustomMenu
extends MythicMenu<CustomMenuContext> {
    private final Pack pack;
    private final String key;
    private final File file;
    private CustomMenuBindingFunction dataBinding = null;

    public CustomMenu(MythicBukkit plugin, MenuManager manager, Pack pack, File file, String key, MenuProp menu) {
        super(plugin, manager, menu);
        this.pack = pack;
        this.key = key;
        this.file = file;
    }

    @Override
    public EditableMenuBuilder<CustomMenuContext> build(EditableMenuBuilder<CustomMenuContext> builder) {
        MythicConfig menuConfig = new MythicConfigImpl("", builder.getConfigurationSection()).getNestedConfig(this.key);
        if (menuConfig.isConfigurationSection("Function")) {
            MythicConfig subConfig = menuConfig.getNestedConfig("Function");
            String bindDataType = subConfig.getString("Type");
            this.dataBinding = this.getMenuManager().getMenuBindingFunction(bindDataType, subConfig).orElse(null);
        } else if (menuConfig.isSet("Function")) {
            this.dataBinding = this.getMenuManager().getMenuBindingFunction(menuConfig.getString("Function"), null).orElse(null);
        }
        String display = builder.getBuilder().getTitleFunc().apply(null);
        builder.getBuilder().title(input -> PlaceholderString.of(display).get(input.getProfile()));
        builder.getIcons().entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            EditableIcon icon = (EditableIcon)entry.getValue();
            IconBuilder<CustomMenuContext> iconBuilder = icon.getBuilder();
            MythicConfigImpl config = new MythicConfigImpl(icon.getConfigurationSection());
            this.buildCustomIcon(iconBuilder, config);
        });
        return builder;
    }

    private void buildCustomIcon(IconBuilder<CustomMenuContext> iconBuilder, MythicConfig config) {
        if (config.isSet("Conditional")) {
            try {
                for (MythicConfig mapConfig : config.getConfigurationList("Conditional")) {
                    List<SkillCondition> conditions = MythicBukkit.inst().getSkillManager().getConditions(mapConfig.getString("Conditions"));
                    iconBuilder.conditionalOverride((state, player) -> {
                        for (SkillCondition condition : conditions) {
                            if (condition.evaluateEntity(BukkitAdapter.adapt(player))) continue;
                            return false;
                        }
                        return true;
                    }, conditionalIconBuilder -> this.buildCustomIcon((IconBuilder<CustomMenuContext>)conditionalIconBuilder, mapConfig));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.buildSingleCustomIcon(iconBuilder, config);
    }

    private void buildSingleCustomIcon(IconBuilder<CustomMenuContext> iconBuilder, MythicConfig config) {
        CustomMenuButtonFunction buttonFunction;
        if (config.isConfigurationSection("Function")) {
            MythicConfig subConfig = config.getNestedConfig("Function");
            String bindDataType = subConfig.getString("Type");
            buttonFunction = this.getMenuManager().getMenuButtonFunction(bindDataType, subConfig).orElse(null);
            if (buttonFunction != null) {
                buttonFunction.applyButtonPresets(iconBuilder);
            }
        } else {
            buttonFunction = config.isSet("Function") ? null : null;
        }
        try {
            Material material = Material.valueOf((String)config.getString("Material", "PAPER").toUpperCase());
            iconBuilder.material(material);
        }
        catch (Throwable ex) {
            iconBuilder.material(Material.PAPER);
        }
        if (config.isSet("Display")) {
            String iconDisplay = config.getString("Display");
            PlaceholderString placeholder = PlaceholderString.of(iconDisplay);
            iconBuilder.name(input -> placeholder.get(input.getProfile()));
        }
        if (config.isSet("Lore")) {
            List<String> iconLore = config.getStringList("Lore");
            ArrayList<PlaceholderString> placeholderedLore = new ArrayList<PlaceholderString>();
            for (String line : iconLore) {
                placeholderedLore.add(PlaceholderString.of(line));
            }
            iconBuilder.lore(input -> {
                ArrayList<String> lore = new ArrayList<String>();
                for (PlaceholderString line : placeholderedLore) {
                    lore.add(line.get(input.getProfile()));
                }
                return lore;
            });
        }
        if (config.isSet("Model")) {
            if (!config.isInt("Model")) {
                Object model = config.getString("Model");
                if (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                    CrucibleSupport.ItemGenerationFeedback generationFeedback = MythicBukkit.inst().getCompatibility().getCrucible().get().addItemToGeneration(this.pack, (String)model);
                    if (generationFeedback.getItemModel().isPresent()) {
                        NamespacedKey itemModelKey = generationFeedback.getItemModel().get();
                        iconBuilder.itemModel(itemModelKey);
                    }
                } else {
                    if (!((String)model).contains(":")) {
                        model = "minecraft:" + (String)model;
                    }
                    NamespacedKey itemModelKey = NamespacedKey.fromString((String)model);
                    iconBuilder.itemModel(itemModelKey);
                }
            } else {
                int model = config.getInt("Model", 0);
                iconBuilder.model(model);
            }
        }
        if (config.contains("ClickConditions")) {
            List<String> conditionsConfig = config.getStringList("ClickConditions");
            List<SkillCondition> clickConditions = this.getPlugin().getSkillManager().getConditions(conditionsConfig);
        } else {
            Object clickConditions = null;
        }
        if (config.contains("Skills")) {
            List<String> skills = config.getStringList("Skills");
            Optional<Skill> maybeSkill = this.getPlugin().getSkillManager().getSkill(this.file, skills);
            if (maybeSkill.isPresent()) {
                Skill skill = maybeSkill.get();
                iconBuilder.click((context, player) -> {
                    PlayerData profile = context.getProfile();
                    AbstractPlayer aPlayer = profile.getEntity();
                    SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.API, profile, aPlayer);
                    meta.setEntityTarget(aPlayer);
                    meta.getVariables().putInt("click-type", 0);
                    skill.execute(meta);
                    if (!meta.isParentCancelled() && buttonFunction != null) {
                        buttonFunction.leftClick((CustomMenuContext)context, (Player)player);
                    }
                }).rightClick((context, player) -> {
                    PlayerData profile = context.getProfile();
                    AbstractPlayer aPlayer = profile.getEntity();
                    SkillMetadataImpl meta = new SkillMetadataImpl(SkillTriggers.API, profile, aPlayer);
                    meta.setEntityTarget(aPlayer);
                    meta.getVariables().putInt("click-type", 1);
                    skill.execute(meta);
                    if (!meta.isParentCancelled() && buttonFunction != null) {
                        buttonFunction.rightClick((CustomMenuContext)context, (Player)player);
                    }
                });
            }
        } else if (buttonFunction != null) {
            iconBuilder.click((context, player) -> buttonFunction.leftClick((CustomMenuContext)context, (Player)player)).rightClick((context, player) -> buttonFunction.rightClick((CustomMenuContext)context, (Player)player));
        }
    }

    public void openMenu(Player player) {
        PlayerData profile = (PlayerData)this.getPlugin().getPlayerManager().getProfile(player);
        CustomMenuContext context = new CustomMenuContext(profile);
        if (this.dataBinding != null) {
            List<MenuData<?>> data = this.dataBinding.getButtons(profile);
            this.open(player, context, data);
        } else {
            this.open(player, context);
        }
    }
}

