/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.custom.icons;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.core.menus.custom.CustomMenuContext;
import io.lumine.mythic.core.menus.custom.icons.IconLoreParser;
import io.lumine.mythic.core.menus.custom.icons.IconLoreSection;
import io.lumine.mythic.core.menus.custom.icons.IconLoreTemplateLine;
import io.lumine.mythic.core.menus.custom.icons.IconStaticLoreLine;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IconLoreTemplate {
    private final IconLoreParser parser;
    private List<IconLoreSection> sections = Lists.newArrayList();

    public IconLoreTemplate(IconLoreParser parser, MythicConfig config) {
        this.parser = parser;
        List<String> lines = config.getStringList("Lines");
        if (lines != null && !lines.isEmpty()) {
            this.sections.add(new IconLoreSection(this, lines));
        }
    }

    public IconLoreTemplate(IconLoreParser parser, List<?> list) {
        this.parser = parser;
        if (list != null && !list.isEmpty()) {
            if (list.get(0) instanceof String) {
                this.sections.add(new IconLoreSection(this, list));
            } else if (list.get(0) instanceof Map) {
                for (String in : list) {
                    Map inMap = (Map)((Object)in);
                    IconLoreSection section = new IconLoreSection(this, inMap);
                    if (inMap.containsKey("Filler")) {
                        section.setFiller(true);
                    }
                    this.sections.add(section);
                }
            }
        }
    }

    public IconBuilder<CustomMenuContext> apply(CustomMenuContext context, IconBuilder<CustomMenuContext> icon) {
        icon.lore(this.parseLore(context));
        return icon;
    }

    public List<String> parseLore(CustomMenuContext context) {
        ArrayList lore = Lists.newArrayList();
        Collection<String> lastFiller = null;
        for (IconLoreSection section : this.sections) {
            if (section.hasConditions() && !this.checkConditions(section, context)) continue;
            Collection<String> loreLine = section.parse(context);
            if (section.isFiller()) {
                lastFiller = loreLine;
                continue;
            }
            if (loreLine.isEmpty()) continue;
            if (lastFiller != null) {
                lore.addAll(lastFiller);
                lastFiller = null;
            }
            lore.addAll(loreLine);
        }
        return lore;
    }

    private boolean checkConditions(IconLoreSection section, PlaceholderMeta meta) {
        block3: {
            block2: {
                if (!(meta instanceof DropMetadata)) break block2;
                DropMetadata dropMetadata = (DropMetadata)meta;
                for (SkillCondition condition : section.getConditions()) {
                    if (condition.evaluateDropper(dropMetadata)) continue;
                    return false;
                }
                break block3;
            }
            if (!(meta instanceof SkillMetadata)) break block3;
            SkillMetadata skillMetadata = (SkillMetadata)meta;
            for (SkillCondition condition : section.getConditions()) {
                if (condition.evaluateCaster(skillMetadata)) continue;
                return false;
            }
        }
        return true;
    }

    protected IconLoreTemplateLine parseLine(String line) {
        Optional<IconLoreTemplateLine> parsed;
        if (line == null || line.isEmpty()) {
            return new IconStaticLoreLine("<white>");
        }
        if (this.parser != null && (parsed = this.parser.parseLine(line)).isPresent()) {
            return parsed.get();
        }
        return new IconStaticLoreLine(line);
    }

    public IconLoreParser getParser() {
        return this.parser;
    }

    public List<IconLoreSection> getSections() {
        return this.sections;
    }
}

