/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.mobs;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.menus.MythicMenu;
import io.lumine.mythic.core.menus.mobs.MobEditorButtons;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import io.lumine.mythic.core.menus.mobs.MobMenuContext;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class MobEditorMenu
extends MythicMenu<MobEditorMenuContext> {
    private MobEditorButtons buttons = new MobEditorButtons();

    public MobEditorMenu(MythicBukkit plugin, MenuManager manager) {
        super(plugin, manager, "/menus/mob-editor.yml");
    }

    @Override
    public void open(Player player, MythicMob mythicMob) {
        this.open(player, new MobEditorMenuContext(mythicMob, new MobMenuContext()));
    }

    @Override
    public void open(Player player, MobEditorMenuContext context) {
        ArrayList buttons = Lists.newArrayList(this.buttons.getButtons());
        this.open(player, context, Text.colorize("Editing Mob: " + context.getMob().getInternalName()), buttons);
    }

    @Override
    public EditableMenuBuilder<MobEditorMenuContext> build(EditableMenuBuilder<MobEditorMenuContext> builder) {
        builder = this.addPageButtons(builder);
        builder.getIcon("BACK_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> context.openPreviousMenu((Player)player)));
        builder.getIcon("MOB_BUTTON").ifPresent(icon -> icon.getBuilder().name("<green>Get Mob Egg").material(Material.EGG).hideFlags(false).click((context, player) -> {
            player.performCommand("mythicmobs egg get " + context.getMob().getInternalName());
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }));
        return builder;
    }
}

