/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractTransientEntity;
import io.lumine.mythic.api.mobs.MobEars;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.entities.BukkitWolf;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.pdc.DataType;
import io.lumine.mythic.bukkit.utils.serialize.Optl;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.holograms.types.HealthBar;
import io.lumine.mythic.core.holograms.types.Nameplate;
import io.lumine.mythic.core.holograms.types.SpeechBubble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.DespawnMode;
import io.lumine.mythic.core.mobs.equipment.MobEquipment;
import io.lumine.mythic.core.mobs.tracker.DamageRecord;
import io.lumine.mythic.core.mobs.tracker.DamageSnapshot;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.auras.AuraRegistry;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.stats.AttributeMappedStat;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.variables.VariableHolder;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.MythicGson;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.IllegalPluginAccessException;

public class ActiveMob
implements SkillCaster,
StatSource,
VariableHolder {
    private UUID uuid;
    private String mobType;
    private transient AbstractEntity entity;
    private transient MythicMob type;
    private long spawnTime = System.currentTimeMillis();
    private long aliveTime = 0L;
    private long lastSeen = System.currentTimeMillis();
    private AbstractLocation spawnLocation;
    private VariableRegistry variables = new VariableRegistry();
    private PlaceholderString displayName;
    private double level;
    private float power = 1.0f;
    private int globalCooldown = 0;
    private DespawnMode despawnMode = null;
    private String stance;
    private String lastSignal = null;
    private int playerKills = 0;
    private Optl<UUID> ownerUUID = Optl.empty();
    private Optl<UUID> parentUUID = Optl.empty();
    private Collection<UUID> children = Sets.newConcurrentHashSet();
    private String spawnerName = null;
    private Optl<String> faction = Optl.empty();
    private Map<UUID, Long> skillCooldowns = Maps.newHashMap();
    private transient AbstractTransientEntity cachedOwner = null;
    private transient AbstractTransientEntity cachedParent = null;
    private transient Optional<ActiveMob> mount = Optional.empty();
    private transient MythicSpawner spawner = null;
    private transient Map<EquipSlot, MobEquipment> equipment = Maps.newConcurrentMap();
    private transient StatRegistry statRegistry;
    private transient DamageRecord damageRecord;
    private transient ThreatTable threatTable;
    private transient ImmunityTable immunityTable;
    private transient MobEars ears;
    private transient Optional<AbstractBossBar> bossBar = Optional.empty();
    private transient Map<String, AbstractBossBar> bossBars = null;
    protected transient HealthBar healthbar = null;
    protected transient Nameplate nameplate = null;
    protected transient SpeechBubble speechBubble = null;
    private AbstractLocation trackedLocation = null;
    private transient AbstractEntity newTarget = null;
    private transient double lastDamageSkillAmount = 0.0;
    private transient boolean damageSkillRunning = false;
    private transient boolean dead = false;
    private transient int noDamageTicks;
    protected transient AbstractEntity lastAggroCause;
    private boolean changingTarget = false;
    private transient int usingDamageSkill = 0;
    private Collection<String> triggeredMechanicHealthConditionals = ConcurrentHashMap.newKeySet();

    private static final MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    public ActiveMob() {
    }

    public ActiveMob(AbstractEntity entity, MythicMob type, double level) {
        this.uuid = entity.getUniqueId();
        this.entity = entity;
        this.type = type;
        this.mobType = type.getInternalName();
        this.spawnLocation = entity.getLocation();
        this.level = level;
        this.faction = Optl.of(type.getFaction());
        this.globalCooldown = 0;
        this.stance = "default";
        this.noDamageTicks = type.getNoDamageTicks();
        this.statRegistry = new StatRegistry(MythicProvider.get().getStatManager(), this);
        if (type.getStats() != null) {
            for (Map.Entry<StatType, PlaceholderDouble> entry : type.getStats().entrySet()) {
                StatType stat = entry.getKey();
                Optional<Double> value = type.getBaseStatValue(this, stat);
                this.statRegistry.putBaseValueSilently(stat, value.get());
                if (!(stat instanceof AttributeMappedStat)) continue;
                AttributeMappedStat mappedStat = (AttributeMappedStat)((Object)stat);
                mappedStat.applyAttribute(entity, value.get());
            }
        }
        entity.setHealth(entity.getMaxHealth());
        if (type.getDefaultVariables() != null) {
            try {
                this.variables = type.getDefaultVariables().clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        Schedulers.of(BukkitAdapter.adapt(entity)).runLater(() -> this.setupNew(), 5L);
        PersistentDataContainer data = entity.getDataContainer();
        data.set(MobKeys.SPAWN_TIME, PersistentDataType.STRING, (Object)String.valueOf(this.spawnTime));
        data.set(MobKeys.SPAWN_LOCATION, PersistentDataType.STRING, (Object)entity.getLocation().serializeShortForm());
        data.set(MobKeys.TYPE, PersistentDataType.STRING, (Object)this.mobType);
        data.set(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)this.level);
        if (this.faction.isPresent()) {
            data.set(MobKeys.FACTION, PersistentDataType.STRING, (Object)this.faction.get());
        }
        if (!this.statRegistry.isEmpty()) {
            HashMap<String, Double> statMap = this.statRegistry.getBaseStats();
            data.set(MobKeys.STATS, MobKeys.STAT_FIELD_TYPE, statMap);
        }
    }

    public ActiveMob(AbstractEntity entity) {
        PersistentDataContainer data = entity.getDataContainer();
        this.uuid = entity.getUniqueId();
        this.entity = entity;
        this.statRegistry = new StatRegistry(MythicBukkit.inst().getStatManager(), this);
        this.spawnTime = Long.valueOf((String)data.getOrDefault(MobKeys.SPAWN_TIME, PersistentDataType.STRING, (Object)"0"));
        this.spawnLocation = AbstractLocation.deserialize((String)data.getOrDefault(MobKeys.SPAWN_LOCATION, PersistentDataType.STRING, (Object)"0,0,0,world"));
        this.mobType = (String)data.getOrDefault(MobKeys.TYPE, PersistentDataType.STRING, null);
        this.level = (Double)data.getOrDefault(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)1.0);
        this.faction = Optl.of((String)data.getOrDefault(MobKeys.FACTION, PersistentDataType.STRING, null));
        this.spawnerName = (String)data.getOrDefault(MobKeys.SPAWNER, PersistentDataType.STRING, null);
        this.displayName = PlaceholderString.of((String)data.getOrDefault(MobKeys.DISPLAY_NAME, PersistentDataType.STRING, null));
        this.stance = (String)data.getOrDefault(MobKeys.STANCE, PersistentDataType.STRING, (Object)"default");
        this.lastSignal = (String)data.getOrDefault(MobKeys.LAST_SIGNAL, PersistentDataType.STRING, null);
        if (data.has(MobKeys.DESPAWN_MODE, DataType.asEnum(DespawnMode.class))) {
            this.despawnMode = (DespawnMode)((Object)data.get(MobKeys.DESPAWN_MODE, DataType.asEnum(DespawnMode.class)));
        }
        if (data.has(MobKeys.OWNER, PersistentDataType.STRING)) {
            this.ownerUUID = Optl.of(UUID.fromString((String)data.get(MobKeys.OWNER, PersistentDataType.STRING)));
        }
        if (data.has(MobKeys.PARENT, PersistentDataType.STRING)) {
            this.parentUUID = Optl.of(UUID.fromString((String)data.get(MobKeys.PARENT, PersistentDataType.STRING)));
        }
        if (data.has(MobKeys.CHILDREN, DataType.UUID_ARRAY)) {
            for (UUID child : (UUID[])data.get(MobKeys.CHILDREN, DataType.UUID_ARRAY)) {
                this.children.add(child);
            }
        }
        if (data.has(MobKeys.STATS, DataType.UUID_ARRAY)) {
            for (Map.Entry entry : ((HashMap)data.get(MobKeys.STATS, MobKeys.STAT_FIELD_TYPE)).entrySet()) {
                String stat = (String)entry.getKey();
                Double value = (Double)entry.getValue();
                StatType statType = ActiveMob.getPlugin().getStatManager().getStatOrRegisterStatic(stat);
                this.statRegistry.putBaseValue(statType, value);
            }
        }
        if (data.has(MobKeys.VARIABLES, PersistentDataType.STRING)) {
            String serializedVariables = (String)data.get(MobKeys.VARIABLES, PersistentDataType.STRING);
            this.variables = (VariableRegistry)MythicGson.get().fromJson(serializedVariables, VariableRegistry.class);
        }
        if (this.mobType == null) {
            throw new IllegalArgumentException("Supplied entity is not a valid MythicMob");
        }
        this.checkEquipment();
    }

    public void setupNew() {
        if (this.entity == null || !this.entity.isValid() || this.entity.isDead() || this.getType() == null) {
            this.unregister(true);
            return;
        }
        if (this.type.usesBossBar()) {
            this.bossBar = this.type.getBossBar();
        }
        this.threatTable = this.type.usesThreatTable() ? new ThreatTable() : null;
        this.immunityTable = this.type.usesImmunityTable() ? new ImmunityTable() : null;
        this.ears = this.type.usesHearing() ? ActiveMob.getPlugin().getVolatileCodeHandler().getAIHandler().createEars(this) : null;
    }

    public boolean validateLoadedMob() {
        if (this.entity == null) {
            return false;
        }
        this.type = ActiveMob.getPlugin().getMobManager().getMythicMob(this.mobType).orElseGet(() -> null);
        if (this.type == null) {
            return false;
        }
        if (this.entity == null) {
            return false;
        }
        return !this.entity.isDead();
    }

    public boolean loadSaved() {
        this.lastSeen = System.currentTimeMillis();
        if (Bukkit.isPrimaryThread()) {
            this.getType().applyMobOptions(this, this.level);
            this.getType().applyMobVolatileOptions(this);
        } else {
            Schedulers.of(BukkitAdapter.adapt(this.entity)).run(() -> {
                this.getType().applyMobOptions(this, this.level);
                this.getType().applyMobVolatileOptions(this);
            });
        }
        if (this.type.usesBossBar()) {
            this.bossBar = this.type.getBossBar();
        }
        if (this.spawnerName != null) {
            this.remountSpawner();
        }
        SkillMetadata data = ActiveMob.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.LOAD, this, null, null, false);
        ActiveMob.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
        return true;
    }

    public void tick(long timer, int c) {
        if (this.getEntity() != null && !this.getEntity().isValid() && !this.isDead()) {
            this.setUnloaded();
            return;
        }
        if (this.entity == null) {
            this.remove();
            return;
        }
        if (this.entity.isDead()) {
            this.setDead();
            return;
        }
        this.aliveTime += (long)c;
        if (this.globalCooldown > 0) {
            this.globalCooldown -= c;
        }
        if ((double)timer % ((double)ActiveMob.getPlugin().getConfiguration().getClockBarUpdating() / (double)c) == 0.0) {
            this.updateBossBar();
        }
        if (this.ears != null) {
            this.ears.tick();
        }
    }

    @Override
    public AbstractEntity getEntity() {
        if (this.entity == null) {
            if (Bukkit.isPrimaryThread()) {
                this.entity = ActiveMob.getPlugin().getBootstrap().getEntity(this.uuid);
            } else {
                Schedulers.sync().run(() -> {
                    this.entity = ActiveMob.getPlugin().getBootstrap().getEntity(this.uuid);
                    if (this.entity == null) {
                        this.unregister(true);
                    }
                });
                return null;
            }
        }
        return this.entity;
    }

    public MythicMob getType() {
        if (this.type == null) {
            this.type = ActiveMob.getPlugin().getMobManager().getMythicMob(this.mobType).orElseGet(() -> null);
        }
        if (this.type == null) {
            if (this.entity != null) {
                MythicLogger.error("Mob type {0} not found - removing mob {1}", this.mobType, this.uuid);
                this.entity.remove();
                this.entity = null;
            }
            this.remove();
        }
        return this.type;
    }

    public DespawnMode getDespawnMode() {
        return this.despawnMode == null ? this.getType().getDespawnMode() : this.despawnMode;
    }

    public void setDespawnMode(DespawnMode mode) {
        this.despawnMode = mode;
        this.entity.getDataContainer().set(MobKeys.DESPAWN_MODE, DataType.asEnum(DespawnMode.class), (Object)mode);
        this.entity.setRemoveWhenFarAway(mode.getDespawnWithoutNearbyPlayers());
        this.entity.setSaveToDisk(mode.getSavesToDisk());
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            PlaceholderString display = this.type.getDisplayName();
            return display == null ? null : display.get(this);
        }
        return this.displayName.get(this);
    }

    public void setDisplayName(String name) {
        this.displayName = PlaceholderString.of(name);
        this.entity.getDataContainer().set(MobKeys.DISPLAY_NAME, PersistentDataType.STRING, (Object)name);
        if (this.nameplate != null) {
            this.nameplate.terminate();
        }
        if (this.getType().getModel() == null && (this.getType().isUseCustomNameplate() || name.contains("\\n"))) {
            this.nameplate = ActiveMob.getPlugin().getHologramManager().createNameplate(this);
            this.getEntity().setCustomName("");
        } else {
            this.getEntity().setCustomName(this.getDisplayName());
        }
    }

    @Override
    public AbstractLocation getLocation() {
        return this.entity.getLocation();
    }

    public void setSpawnLocation(AbstractLocation location) {
        this.spawnLocation = location;
        PersistentDataContainer data = this.entity.getDataContainer();
        data.set(MobKeys.SPAWN_LOCATION, PersistentDataType.STRING, (Object)location.serializeShortForm());
    }

    public void setParent(SkillCaster am) {
        if (am == null) {
            this.parentUUID = Optl.empty();
            this.cachedParent = null;
        } else {
            am.addChild(this.getEntity());
            this.parentUUID = Optl.of(am.getEntity().getUniqueId());
            this.cachedParent = new AbstractTransientEntity(am.getEntity().getUniqueId(), am.getEntity());
            this.entity.getDataContainer().set(MobKeys.PARENT, PersistentDataType.STRING, (Object)am.getEntity().getUniqueId().toString());
        }
    }

    public Optl<AbstractEntity> getParent() {
        if (this.cachedParent != null) {
            return this.cachedParent.get();
        }
        if (this.parentUUID.isPresent()) {
            this.cachedParent = new AbstractTransientEntity(this.parentUUID.get());
            return this.cachedParent.get();
        }
        return Optl.empty();
    }

    @Override
    public void addChild(AbstractEntity entity) {
        this.children.add(entity.getUniqueId());
        this.saveChildren();
    }

    @Override
    public void removeChild(AbstractEntity entity) {
        this.removeChild(entity.getUniqueId());
    }

    public void removeChild(UUID uuid) {
        this.children.remove(uuid);
        this.saveChildren();
    }

    private void saveChildren() {
        UUID[] children = this.children.toArray(new UUID[this.children.size()]);
        this.entity.getDataContainer().set(MobKeys.CHILDREN, DataType.UUID_ARRAY, (Object)children);
    }

    @Override
    public Collection<AbstractEntity> getChildren() {
        return ActiveMob.getPlugin().getBootstrap().getEntities(this.children);
    }

    public Optl<AbstractEntity> getOwner() {
        if (this.cachedOwner != null) {
            return this.cachedOwner.get();
        }
        if (this.ownerUUID.isPresent()) {
            this.cachedOwner = new AbstractTransientEntity(this.ownerUUID.get());
            return this.cachedOwner.get();
        }
        return Optl.empty();
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = Optl.of(uuid);
        if (uuid != null) {
            this.cachedOwner = new AbstractTransientEntity(uuid);
            this.entity.getDataContainer().set(MobKeys.OWNER, PersistentDataType.STRING, (Object)uuid.toString());
        } else {
            this.cachedOwner = null;
        }
        if (this.getType().getMythicEntity() instanceof BukkitWolf) {
            Wolf wolf = (Wolf)this.getEntity().getBukkitEntity();
            wolf.setOwner((AnimalTamer)Bukkit.getPlayer((UUID)uuid));
        }
    }

    public void removeOwner() {
        this.ownerUUID = Optl.empty();
        this.cachedOwner = null;
    }

    public void setMount(ActiveMob am) {
        this.mount = Optional.of(am);
    }

    public void remountType() {
        if (this.mobType == null) {
            this.unregister();
            return;
        }
        MythicMob mm4 = ActiveMob.getPlugin().getMobManager().getMythicMob(this.mobType).orElseGet(() -> null);
        if (mm4 == null) {
            this.unregister();
            return;
        }
        this.type = mm4;
        if (this.getEntity() != null && (this.getEntity().isLiving() && this.getEntity().getHealth() == this.getEntity().getMaxHealth() || !this.getEntity().isLiving())) {
            this.type.applyMobOptions(this, this.level);
            this.type.applyMobVolatileOptions(this);
        }
    }

    public double getDamage() {
        return this.getType().getDamage(this);
    }

    public double getArmor() {
        return this.getType().getArmor(this);
    }

    public void setLevel(double level) {
        this.level = level;
        this.getType().applyMobOptions(this, level);
        this.getType().applyMobVolatileOptions(this);
        this.entity.getDataContainer().set(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)this.level);
    }

    public void setPower(float power) {
        this.power = power;
    }

    @Override
    public float getPower() {
        if (this.getType() == null) {
            return this.power;
        }
        return (float)((double)this.power + (this.getLevel() - 1.0) * this.getType().getPerLevelPower());
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public void setStance(String stance) {
        this.stance = stance;
    }

    public boolean hasFaction() {
        if (this.faction.isPresent()) {
            return true;
        }
        return this.type.hasFaction();
    }

    public String getFaction() {
        if (this.faction.isPresent()) {
            return this.faction.get();
        }
        return this.type.getFaction();
    }

    public ActiveMob setFaction(String faction) {
        this.faction = Optl.of(faction);
        if (faction != null) {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
                this.entity.getDataContainer().set(MobKeys.FACTION, PersistentDataType.STRING, (Object)faction);
            }
        } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            this.entity.getDataContainer().remove(MobKeys.FACTION);
        }
        return this;
    }

    public void incrementPlayerKills() {
        ++this.playerKills;
    }

    public void importPlayerKills(int pk) {
        this.playerKills = pk;
    }

    public void setLastAggroCause(AbstractEntity aggro) {
        this.lastAggroCause = aggro;
    }

    public void checkEquipment() {
        if (!this.entity.isLiving()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)this.entity.getBukkitEntity();
        EntityEquipment ee = livingEntity.getEquipment();
        if (ee == null) {
            return;
        }
        this.parseEquipmentStats(ee.getHelmet(), EquipSlot.HEAD);
        this.parseEquipmentStats(ee.getChestplate(), EquipSlot.CHEST);
        this.parseEquipmentStats(ee.getLeggings(), EquipSlot.LEGS);
        this.parseEquipmentStats(ee.getBoots(), EquipSlot.FEET);
        this.parseEquipmentStats(ee.getItemInMainHand(), EquipSlot.HAND);
        this.parseEquipmentStats(ee.getItemInOffHand(), EquipSlot.OFFHAND);
        this.statRegistry.updateDirtyStats();
    }

    private void parseEquipmentStats(ItemStack item, EquipSlot slot) {
        MobEquipment currentItem = this.equipment.get(slot);
        if (currentItem != null) {
            if (currentItem.equals(item)) {
                currentItem.setItemStack(item);
                return;
            }
            this.equipment.remove(slot);
        }
        if (item != null && item.hasItemMeta()) {
            MobEquipment newItem = new MobEquipment(this, item, slot, currentItem);
            this.equipment.put(slot, newItem);
        } else if (currentItem != null && currentItem.hasStats()) {
            for (StatType stat : currentItem.getStats().keySet()) {
                this.statRegistry.removeValueSilently(stat, currentItem);
            }
        }
    }

    public boolean hasTarget() {
        if (this.hasThreatTable()) {
            return this.threatTable.getTopThreatHolder() == null;
        }
        return this.entity.isCreature() && this.entity.getTarget() != null;
    }

    public void setTarget(AbstractEntity l) {
        this.newTarget = l;
        if (this.entity.isLiving() && !this.changingTarget) {
            this.changingTarget = true;
            this.entity.setTarget(l);
            this.changingTarget = false;
        }
    }

    public boolean changingTarget() {
        return this.newTarget != null;
    }

    public AbstractEntity getNewTarget() {
        return this.newTarget;
    }

    public void voidTargetChange() {
        this.newTarget = null;
    }

    public void resetTarget() {
        if (this.hasThreatTable()) {
            this.threatTable.dropCombat();
        } else {
            this.entity.setTarget(null);
        }
    }

    public void recordPlayerDamage(UUID playerUUID, double damage) {
        if (this.damageRecord == null) {
            this.damageRecord = new DamageRecord(this);
        }
        DamageSnapshot snapshot = DamageSnapshot.create(this.getUniqueId(), playerUUID, damage);
        this.damageRecord.registerSnapshot(snapshot);
    }

    public ThreatTable getThreatTable() {
        if (this.threatTable == null && this.type.usesThreatTable()) {
            this.threatTable = new ThreatTable();
        }
        return this.threatTable;
    }

    public boolean hasThreatTable() {
        return this.threatTable != null;
    }

    public void importThreatTable(ThreatTable tt) {
        this.threatTable = tt;
    }

    public boolean hasImmunityTable() {
        return this.immunityTable != null;
    }

    public void save() {
        if (this.entity == null) {
            return;
        }
        String serializeVariables = MythicGson.get().toJson((Object)this.variables);
        PersistentDataContainer data = this.entity.getDataContainer();
        if (this.statRegistry != null) {
            HashMap<String, Double> statMap = this.statRegistry.getBaseStats();
            data.set(MobKeys.STATS, MobKeys.STAT_FIELD_TYPE, statMap);
        }
        data.set(MobKeys.VARIABLES, PersistentDataType.STRING, (Object)serializeVariables);
        data.set(MobKeys.STANCE, PersistentDataType.STRING, (Object)this.stance);
    }

    public void despawn() {
        if (ActiveMob.getPlugin().isShuttingDown()) {
            this.setDespawnedSync();
        } else {
            this.setDespawned();
        }
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public void remove() {
        this.dead = true;
        this.unregister();
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public void setDespawned() {
        if (!this.dead) {
            this.dead = true;
            try {
                SkillMetadata data = ActiveMob.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.DESPAWNED, this, this.getEntity(), null, false);
                ActiveMob.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
                // empty catch block
            }
            Schedulers.of(BukkitAdapter.adapt(this.entity)).run(() -> ActiveMob.getPlugin().getBootstrap().handleMobDespawnEvent(this));
            if (this.getSpawner() != null) {
                this.getSpawner().markMobDespawned(this);
            }
        }
        this.unregister();
    }

    public void setDespawnedSync() {
        if (!this.dead) {
            this.dead = true;
            try {
                SkillMetadata data = ActiveMob.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.DESPAWNED, this, this.getEntity(), null, false);
                ActiveMob.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
                // empty catch block
            }
            ActiveMob.getPlugin().getBootstrap().handleMobDespawnEvent(this);
            if (this.getSpawner() != null) {
                this.getSpawner().markMobDespawned(this);
            }
        }
        this.unregister(true);
    }

    public void setDead() {
        if (!this.dead) {
            this.dead = true;
            if (this.getSpawner() != null) {
                this.getSpawner().markMobDead(this);
            }
            this.unregister();
        }
    }

    public void setUnloaded() {
        if (!this.dead) {
            if (this.type == null) {
                this.remove();
            } else if (this.getDespawnMode().getDespawnsOnUnload().booleanValue()) {
                try {
                    SkillMetadata data = ActiveMob.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.DESPAWNED, this, this.getEntity(), null, false);
                    ActiveMob.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
                }
                catch (IllegalPluginAccessException illegalPluginAccessException) {
                    // empty catch block
                }
                ActiveMob.getPlugin().getBootstrap().handleMobDespawnEvent(this);
                if (this.getSpawner() != null) {
                    this.getSpawner().markMobDespawned(this);
                }
                this.remove();
            } else {
                this.unloadBossBars();
                this.save();
                Schedulers.of(BukkitAdapter.adapt(this.entity)).runLater(() -> ActiveMob.getPlugin().getMobManager().getMobRegistry().setInactive(this.uuid), 5L);
            }
        }
    }

    public void unregister() {
        this.unregister(false);
    }

    public void unregister(boolean sync) {
        SkillCaster parentCaster;
        AbstractEntity parentEntity;
        ActiveMob.getPlugin().getMobManager().setIgnoreEntity(this.uuid);
        this.unloadBossBars();
        if (this.parentUUID.isPresent() && this.getEntity() != null && (parentEntity = ActiveMob.getPlugin().getBootstrap().getEntity(this.parentUUID.get())) != null && (parentCaster = ActiveMob.getPlugin().getSkillManager().getCaster(parentEntity)) != null) {
            parentCaster.removeChild(this.getEntity());
        }
        if (this.getEntity() != null && this.getType() != null && this.getType().getModel() != null) {
            this.getType().getModel().remove(this.getEntity());
        }
        if (sync) {
            ActiveMob.getPlugin().getMobManager().unregisterActiveMob(this);
        } else {
            Schedulers.of(BukkitAdapter.adapt(this.entity)).runLater(() -> ActiveMob.getPlugin().getMobManager().unregisterActiveMob(this), 5L);
        }
    }

    @Override
    public void setUsingDamageSkill(boolean bool) {
        this.usingDamageSkill = bool ? (this.usingDamageSkill >= 3 ? 3 : this.usingDamageSkill + 1) : (this.usingDamageSkill <= 0 ? 0 : this.usingDamageSkill - 1);
    }

    @Override
    public boolean isUsingDamageSkill() {
        return this.usingDamageSkill >= 3;
    }

    public void setLastDamageSkillAmount(double d) {
        this.lastDamageSkillAmount = d;
    }

    public double getLastDamageSkillAmount() {
        return this.lastDamageSkillAmount;
    }

    public void setSpawner(MythicSpawner ms) {
        this.spawnerName = ms.getInternalName();
        this.spawner = ms;
        this.entity.getDataContainer().set(MobKeys.SPAWNER, PersistentDataType.STRING, (Object)ms.getInternalName());
    }

    public void remountSpawner() {
        MythicSpawner maybeSpawner;
        if (this.spawnerName != null && (maybeSpawner = ActiveMob.getPlugin().getSpawnerManager().getSpawnerByName(this.spawnerName)) != null) {
            this.spawner = maybeSpawner;
            if (!this.spawner.trackMob(this)) {
                this.remove();
            }
        }
    }

    public void signalMob(AbstractEntity trigger, String signal) {
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.SIGNAL, this, trigger);
        if (trigger != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Received signal {0} from {1}", signal, trigger.getUniqueId());
            HashSet<AbstractEntity> eTargets = new HashSet<AbstractEntity>();
            eTargets.add(data.getTrigger());
            data.setEntityTargets(eTargets);
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Received signal {0}", signal);
        }
        data.setPower(this.getPower());
        this.lastSignal = signal;
        this.entity.getDataContainer().set(MobKeys.LAST_SIGNAL, PersistentDataType.STRING, (Object)this.stance);
        this.getType().executeSignalSkill(signal, data);
    }

    public void signalDamaged() {
        if (this.healthbar != null) {
            this.healthbar.update();
        } else if (this.getType().getUsesHealthBar().booleanValue()) {
            this.healthbar = ActiveMob.getPlugin().getHologramManager().createHealthBar(this);
        }
    }

    @Override
    public void setSkillCooldownMillis(AbstractSkill skill, double millis) {
        UUID skillId = skill.getUuid();
        if (millis > 0.0) {
            long expiresAt = System.currentTimeMillis() + (long)millis;
            this.skillCooldowns.put(skillId, expiresAt);
        } else {
            this.skillCooldowns.remove(skillId);
        }
    }

    @Override
    public double getSkillCooldownRemainingMillis(AbstractSkill skill) {
        UUID skillId = skill.getUuid();
        Long expiresAt = this.skillCooldowns.get(skillId);
        if (expiresAt == null) {
            return 0.0;
        }
        long now = System.currentTimeMillis();
        if (now >= expiresAt) {
            this.skillCooldowns.remove(skillId);
            return 0.0;
        }
        return expiresAt - now;
    }

    public boolean hasMechanicUsedHealthCheck(String id) {
        return this.triggeredMechanicHealthConditionals.contains(id);
    }

    public void markMechanicUsedHealthCheck(String id) {
        this.triggeredMechanicHealthConditionals.add(id);
    }

    @Override
    public AuraRegistry getAuraRegistry() {
        return ActiveMob.getPlugin().getSkillManager().getAuraManager().getAuraRegistry(this.entity);
    }

    public void addBar(String key, AbstractBossBar bar) {
        if (this.bossBars == null) {
            this.bossBars = new ConcurrentHashMap<String, AbstractBossBar>();
        }
        this.bossBars.put(key, bar);
    }

    public AbstractBossBar getBar(String key) {
        return this.bossBars == null ? null : (AbstractBossBar)this.bossBars.getOrDefault(key, null);
    }

    public void removeBar(String key) {
        if (this.bossBars != null && this.bossBars.containsKey(key)) {
            this.bossBars.remove(key).terminate();
        }
    }

    public void updateBossBar() {
        if (!this.bossBar.isPresent() && this.bossBars == null) {
            return;
        }
        Collection<AbstractPlayer> inRange = this.getLocation().getWorld().getPlayersInRadius(this.getLocation(), this.getType().getBossBarRangeSquared());
        Collection inRangeIds = inRange.stream().map(p -> p.getUniqueId()).collect(Collectors.toSet());
        if (this.bossBar.isPresent()) {
            AbstractBossBar bar = this.bossBar.get();
            Collection<AbstractPlayer> current = bar.getPlayers();
            double progress = this.getEntity().getHealth() / this.getEntity().getMaxHealth();
            String title = this.type.getBossBarTitle().get(new GenericPlaceholderMeta(this, this.getEntity()));
            bar.setTitle(title);
            if (progress >= 0.0 || progress <= 1.0) {
                bar.setProgress(progress);
            }
            current.stream().forEach(player -> {
                if (!inRangeIds.contains(player.getUniqueId())) {
                    bar.removePlayer((AbstractPlayer)player);
                }
            });
            inRange.stream().forEach(player -> {
                if (!bar.isViewing((AbstractPlayer)player)) {
                    bar.addPlayer((AbstractPlayer)player);
                }
            });
        }
        if (this.bossBars != null) {
            this.bossBars.values().forEach(barx -> barx.getPlayers().removeIf(player -> !inRange.contains(player)));
            inRange.stream().forEach(player -> this.bossBars.values().forEach(barx -> {
                if (!barx.getPlayers().contains(player)) {
                    barx.addPlayer((AbstractPlayer)player);
                }
            }));
        }
    }

    public void unloadBossBars() {
        if (this.bossBar.isPresent()) {
            this.bossBar.get().removeAll();
            this.bossBar = Optional.empty();
        }
        if (this.bossBars != null) {
            this.bossBars.values().forEach(bar -> bar.terminate());
            this.bossBars.clear();
        }
    }

    public boolean getShowCustomNameplate() {
        return this.nameplate == null;
    }

    public void setShowCustomNameplate(boolean b) {
        if (b) {
            if (this.nameplate == null && this.getType().getModel() == null) {
                this.nameplate = ActiveMob.getPlugin().getHologramManager().createNameplate(this);
            }
        } else if (this.nameplate != null) {
            this.nameplate.terminate();
            this.nameplate = null;
        }
    }

    public int hashCode() {
        return this.getUniqueId().toString().hashCode();
    }

    public String getMobType() {
        return this.mobType;
    }

    public void setEntity(AbstractEntity entity) {
        this.entity = entity;
    }

    public long getSpawnTime() {
        return this.spawnTime;
    }

    public long getAliveTime() {
        return this.aliveTime;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public AbstractLocation getSpawnLocation() {
        return this.spawnLocation;
    }

    @Override
    public VariableRegistry getVariables() {
        return this.variables;
    }

    @Override
    public double getLevel() {
        return this.level;
    }

    @Override
    public int getGlobalCooldown() {
        return this.globalCooldown;
    }

    @Override
    public void setGlobalCooldown(int globalCooldown) {
        this.globalCooldown = globalCooldown;
    }

    public String getStance() {
        return this.stance;
    }

    public String getLastSignal() {
        return this.lastSignal;
    }

    public int getPlayerKills() {
        return this.playerKills;
    }

    public Optl<UUID> getOwnerUUID() {
        return this.ownerUUID;
    }

    public Optl<UUID> getParentUUID() {
        return this.parentUUID;
    }

    public AbstractTransientEntity getCachedOwner() {
        return this.cachedOwner;
    }

    public AbstractTransientEntity getCachedParent() {
        return this.cachedParent;
    }

    public Optional<ActiveMob> getMount() {
        return this.mount;
    }

    public MythicSpawner getSpawner() {
        return this.spawner;
    }

    @Override
    public StatRegistry getStatRegistry() {
        return this.statRegistry;
    }

    public DamageRecord getDamageRecord() {
        return this.damageRecord;
    }

    public ImmunityTable getImmunityTable() {
        return this.immunityTable;
    }

    public MobEars getEars() {
        return this.ears;
    }

    public SpeechBubble getSpeechBubble() {
        return this.speechBubble;
    }

    public AbstractLocation getTrackedLocation() {
        return this.trackedLocation;
    }

    public void setTrackedLocation(AbstractLocation trackedLocation) {
        this.trackedLocation = trackedLocation;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    public AbstractEntity getLastAggroCause() {
        return this.lastAggroCause;
    }

    public class ThreatTable
    implements Cloneable {
        private WeakReference<ActiveMob> mob;
        private double totalThreat = 0.0;
        private double targetThreat = 0.0;
        private int targetOutOfRangeTicks = 0;
        private AbstractEntity target = null;
        private final Map<UUID, Double> threatTable = new ConcurrentHashMap<UUID, Double>();

        public void setParent(ActiveMob am) {
            this.mob = new WeakReference<ActiveMob>(am);
        }

        public void tickThreat() {
            try {
                String targetFaction;
                if (ActiveMob.this.entity == null) {
                    return;
                }
                if (this.target == null) {
                    this.clearTarget();
                    this.targetHighestThreat();
                    return;
                }
                if (this.target.isDead()) {
                    this.targetDeath();
                    return;
                }
                if (this.threatTable.isEmpty()) {
                    this.dropCombat();
                    return;
                }
                if (ActiveMob.this.getFaction() != null && (targetFaction = (String)this.target.getFaction().orElse(null)) != null && targetFaction.equals(ActiveMob.this.getFaction())) {
                    this.clearTarget();
                    this.targetHighestThreat();
                    return;
                }
                if (ActiveMob.this.getType().getThreatTableDecaysUnreachable() && !this.target.hasLineOfSight(ActiveMob.this.getEntity())) {
                    this.decayTargetThreat();
                }
                if (this.target.isPlayer() && !this.target.asPlayer().isOnline()) {
                    this.clearTarget();
                    this.targetHighestThreat();
                }
                if (!this.target.getLocation().getWorld().equals(ActiveMob.this.getEntity().getLocation().getWorld()) || this.target.isPlayer() && (this.target.asPlayer().isInCreativeMode() || this.target.asPlayer().isInSpectatorMode())) {
                    this.clearTarget();
                    this.targetHighestThreat();
                    this.targetOutOfRangeTicks = 0;
                } else if (ActiveMob.this.getType().getThreatTableDecaysUnreachable() && this.target.getLocation().distance(ActiveMob.this.getEntity().getLocation()) > (double)ActiveMob.this.getType().getMaxThreatDistance()) {
                    ++this.targetOutOfRangeTicks;
                    if (this.targetOutOfRangeTicks >= 10) {
                        this.clearTarget();
                        this.targetHighestThreat();
                        this.targetOutOfRangeTicks = 0;
                    }
                } else {
                    this.targetOutOfRangeTicks = 0;
                }
            }
            catch (Error | Exception ex) {
                this.clearTarget();
                this.targetHighestThreat();
                MythicLogger.handleMinorError(ex);
            }
        }

        public boolean inCombat() {
            return !this.threatTable.isEmpty();
        }

        public boolean targetEvent(AbstractEntity entity) {
            if (entity == null) {
                return false;
            }
            UUID uuid = entity.getUniqueId();
            if (this.target == null) {
                this.target = entity;
                ActiveMob.this.setTarget(entity);
                if (this.threatTable.containsKey(uuid)) {
                    this.targetThreat = this.threatTable.get(uuid);
                } else {
                    if (!this.inCombat()) {
                        ActiveMob.getPlugin().getMobManager().setInCombat(ActiveMob.this, true);
                        SkillMetadata data = ActiveMob.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.ENTERCOMBAT, ActiveMob.this, entity, null, false);
                        ActiveMob.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
                    }
                    this.targetThreat = 1.0;
                    this.threatTable.put(uuid, 1.0);
                }
                return true;
            }
            if (this.target.equals(entity)) {
                return true;
            }
            if (this.target.isDead()) {
                this.targetDeath();
                return this.target != null && this.target.equals(entity);
            }
            return false;
        }

        public boolean Taunt(AbstractEntity target) {
            if (target.equals(this.target)) {
                return false;
            }
            this.threatTable.put(target.getUniqueId(), this.targetThreat * 1.1);
            this.targetThreateningEntity(target);
            return true;
        }

        public void dropCombat() {
            this.target = null;
            this.targetThreat = 0.0;
            this.totalThreat = 0.0;
            this.threatTable.clear();
            ActiveMob.getPlugin().getMobManager().setInCombat(ActiveMob.this, false);
            ActiveMob.this.entity.setTarget(null);
            SkillMetadata data = ActiveMob.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.DROPCOMBAT, ActiveMob.this, null, null, false);
            ActiveMob.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
        }

        public void observeDeath(AbstractEntity entity) {
            if (this.target == null) {
                return;
            }
            if (this.target.equals(entity)) {
                this.targetDeath();
            }
            this.threatTable.remove(entity.getUniqueId());
        }

        public void observeChangeWorld(AbstractEntity entity) {
            if (this.target == null) {
                return;
            }
            if (this.target.equals(entity)) {
                this.clearTarget();
                if (this.inCombat()) {
                    this.targetHighestThreat();
                }
            }
            this.threatTable.remove(entity.getUniqueId());
        }

        public boolean targetThreateningEntity(AbstractEntity entity) {
            this.target = entity;
            this.targetThreat = this.threatTable.get(entity.getUniqueId());
            ActiveMob.this.setTarget(this.target);
            return true;
        }

        public void targetHighestThreat() {
            if (this.threatTable.isEmpty()) {
                this.dropCombat();
                return;
            }
            Iterator<Map.Entry<UUID, Double>> it = this.threatTable.entrySet().iterator();
            this.targetThreat = 0.0;
            while (it.hasNext()) {
                String targetFaction;
                Map.Entry<UUID, Double> pairs = it.next();
                AbstractEntity checkedTarget = BukkitAdapter.adapt(Bukkit.getEntity((UUID)pairs.getKey()));
                if (checkedTarget == null || !(pairs.getValue() > this.targetThreat) || ActiveMob.this.getFaction() != null && (targetFaction = (String)checkedTarget.getFaction().orElse(null)) != null && targetFaction.equals(ActiveMob.this.getFaction())) continue;
                this.targetThreat = pairs.getValue();
                this.target = checkedTarget;
            }
            ActiveMob.this.setTarget(this.target);
        }

        public void clearTarget() {
            if (this.target != null) {
                this.threatTable.remove(this.target.getUniqueId());
            }
            if (this.threatTable.isEmpty()) {
                this.dropCombat();
            }
        }

        public void targetDeath() {
            if (this.target.isDead()) {
                this.clearTarget();
                this.targetHighestThreat();
            }
        }

        public void threatSet(AbstractEntity entity, double amount) {
            if (entity == null) {
                return;
            }
            if (entity.getUniqueId().equals(ActiveMob.this.getUniqueId())) {
                return;
            }
            if (ActiveMob.this.ownerUUID.isPresent() && ActiveMob.this.ownerUUID.get().equals(entity.getUniqueId())) {
                return;
            }
            if (entity.isPlayer() && (entity.asPlayer().isInCreativeMode() || entity.asPlayer().isInSpectatorMode())) {
                return;
            }
            this.totalThreat -= this.getThreat(entity);
            if (this.target == null) {
                this.targetEvent(entity);
                this.targetThreat = amount;
            } else if (this.target.equals(entity)) {
                this.targetThreat = amount;
            }
            this.threatTable.put(entity.getUniqueId(), amount);
            if (amount > this.targetThreat * 1.1) {
                this.targetThreateningEntity(entity);
            }
            this.totalThreat += amount;
        }

        public void threatGain(AbstractEntity entity, double amount) {
            if (entity == null) {
                return;
            }
            UUID uuid = entity.getUniqueId();
            if (entity.getUniqueId().equals(ActiveMob.this.getUniqueId())) {
                return;
            }
            if (ActiveMob.this.ownerUUID.isPresent() && ActiveMob.this.ownerUUID.get().equals(entity.getUniqueId())) {
                return;
            }
            if (entity.isPlayer() && (entity.asPlayer().isInCreativeMode() || entity.asPlayer().isInSpectatorMode())) {
                return;
            }
            if (this.target == null) {
                this.targetEvent(entity);
                this.targetThreat = amount;
            } else if (this.target.equals(entity)) {
                this.targetThreat += amount;
                amount = this.targetThreat;
            } else if (this.threatTable.containsKey(uuid)) {
                amount += this.threatTable.get(uuid).doubleValue();
            }
            this.threatTable.put(uuid, amount);
            if (amount > this.targetThreat * 1.1) {
                this.targetThreateningEntity(entity);
            }
            this.totalThreat += amount;
        }

        public void threatLoss(AbstractEntity entity, double amount) {
            double nT;
            UUID uuid = entity.getUniqueId();
            if (this.threatTable.containsKey(uuid)) {
                nT = this.threatTable.get(uuid) - amount;
                if (nT < 0.0) {
                    amount -= 0.0 - nT;
                    nT = 0.0;
                }
            } else {
                return;
            }
            this.threatTable.put(uuid, nT);
            this.totalThreat -= amount;
            if (this.target.equals(entity)) {
                this.targetHighestThreat();
            }
        }

        public void decayTargetThreat() {
            double dt = this.targetThreat * 0.96;
            this.totalThreat -= this.targetThreat - dt;
            this.targetThreat = dt;
            this.threatTable.put(this.target.getUniqueId(), dt);
        }

        public AbstractEntity getTopThreatHolder() {
            return this.target;
        }

        public double getTopTargetThreat() {
            return this.targetThreat;
        }

        public double getThreat(AbstractEntity entity) {
            return this.threatTable.getOrDefault(entity.getUniqueId(), 0.0);
        }

        public double getTotalThreat() {
            return this.totalThreat;
        }

        public Set<AbstractEntity> getAllThreatTargets() {
            return this.threatTable.keySet().stream().map(uuid -> ActiveMob.getPlugin().getBootstrap().getPlayer((UUID)uuid)).collect(Collectors.toSet());
        }

        public int size() {
            return this.threatTable.size();
        }

        public ImmutableMap<UUID, Double> asMap() {
            return ImmutableMap.copyOf(this.threatTable);
        }

        public ThreatTable clone() throws CloneNotSupportedException {
            return (ThreatTable)super.clone();
        }

        public Map<UUID, Double> getThreatTable() {
            return this.threatTable;
        }
    }

    public class ImmunityTable {
        private long otherSource;
        private Map<UUID, Long> immunityTable = new ConcurrentHashMap<UUID, Long>();

        public void setCooldown(AbstractEntity e) {
            if (e == null) {
                this.otherSource = ActiveMob.this.aliveTime;
            } else {
                this.immunityTable.put(e.getUniqueId(), ActiveMob.this.aliveTime);
            }
        }

        public void clearCooldown(AbstractEntity e) {
            if (e == null) {
                this.otherSource = -ActiveMob.this.getNoDamageTicks();
            } else {
                this.immunityTable.put(e.getUniqueId(), Long.valueOf(-(ActiveMob.this.getNoDamageTicks() + 1)));
            }
        }

        public boolean onCooldown(AbstractEntity e) {
            if (e == null) {
                return ActiveMob.this.aliveTime - this.otherSource <= (long)(ActiveMob.this.getNoDamageTicks() / 2);
            }
            if (this.immunityTable.containsKey(e.getUniqueId())) {
                long last = this.immunityTable.get(e.getUniqueId());
                return ActiveMob.this.aliveTime - last <= (long)(ActiveMob.this.getNoDamageTicks() / 2);
            }
            return false;
        }
    }
}

