/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.stats.StatManager;
import io.lumine.mythic.api.volatilecode.VolatileEnchantment;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.compatibility.WorldGuardSupport;
import io.lumine.mythic.bukkit.events.MythicMobPreSpawnEvent;
import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.DropMethod;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import io.lumine.mythic.core.menus.mobs.MobMenuContext;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.DespawnMode;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.mobs.model.MPetsModel;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.core.mobs.totems.TotemConfig;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.stats.Stats;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.VariableUtils;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.Expression;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MobType
implements MythicMob,
SkillHolder,
MenuData<MobMenuContext> {
    private final MythicBukkit plugin;
    private final MobExecutor manager;
    private Pack pack;
    private File file;
    private MythicConfig config;
    private String internalName;
    private ItemStack cachedMenuItem;
    private boolean isHidden;
    protected String entityTypeString;
    protected MythicEntityType entityType;
    protected BukkitEntityType entityBaseSpawner;
    protected PlaceholderString displayName;
    protected String faction = null;
    private AbstractItemStack eggItem = null;
    private PlaceholderString eggDisplay = null;
    private PlaceholderString eggModel = null;
    private PlaceholderString eggMobName = null;
    private List<PlaceholderString> eggLore = null;
    private TotemConfig totemConfig = null;
    private MobModel model;
    private DropTable dropTable;
    private DropTable equipmentTable;
    protected double optionReviveHealth;
    protected double lvlModDamage;
    protected double lvlModHealth;
    protected double lvlModArmor;
    protected double lvlModKBR;
    protected double lvlModPower;
    protected double lvlModSpeed;
    protected double lvlModAttackSpeed;
    protected DespawnMode despawnMode = DespawnMode.NORMAL;
    protected boolean optionShowHealthInChat = false;
    protected boolean optionSilent = false;
    protected boolean optionNoAI = false;
    protected boolean optionAware = true;
    protected boolean optionGlowing = false;
    protected boolean optionInvincible = false;
    protected boolean optionCollidable = true;
    protected boolean optionNoGravity = true;
    protected boolean optionInteractable = true;
    protected boolean optionHealOnReload = false;
    protected Boolean optionLockPitch = false;
    protected boolean useBossBar = false;
    protected int bossBarRange;
    protected int bossBarRangeSq;
    protected PlaceholderString bossBarTitle;
    protected AbstractBossBar.BarColor bossBarColor;
    protected AbstractBossBar.BarStyle bossBarStyle;
    protected boolean bossBarCreateFog;
    protected boolean bossBarDarkenSky;
    protected boolean bossBarPlayMusic;
    protected Optional<String> mount = Optional.empty();
    protected Optional<String> rider = Optional.empty();
    private Map<StatType, PlaceholderDouble> stats;
    private Map<StatType, Double> statLevelModifiers;
    private VariableRegistry defaultVariables = null;
    private Map<String, Double> damageModifiers;
    private Map<String, Double> entityDamageModifiers;
    private List<String> aiGoalSelectors = Lists.newArrayList();
    private List<String> aiTargetSelectors = Lists.newArrayList();
    private Map<String, Float> aiPathfindingMalus = Maps.newConcurrentMap();
    private String aiNavigator;
    private boolean hasCombatSkills = false;
    private Map<SkillTrigger, Queue<SkillMechanic>> skills = Maps.newConcurrentMap();
    private Queue<SkillMechanic> timerSkills = Queues.newConcurrentLinkedQueue();
    private Map<String, List<SkillMechanic>> signalSkills = Maps.newConcurrentMap();
    private boolean usingTimers = false;
    private int noDamageTicks;
    private int maxAttackRange;
    private int maxAttackableRange;
    private int maxThreatDistance;
    private boolean alwaysShowName = true;
    private boolean showNameOnDamage = true;
    private boolean useThreatTable;
    private boolean useImmunityTable;
    private boolean useHearing;
    private boolean useCustomNameplate;
    private boolean optionTTFromDamage = true;
    private boolean optionTTDecayUnreachable = true;
    private Boolean repeatAllSkills = false;
    private Boolean preventVanillaDamage = false;
    private Boolean preventOtherDrops = false;
    private Boolean preventRandomEquipment = false;
    private Boolean preventLeashing = false;
    private Boolean preventKnockback = false;
    private Boolean preventRename = true;
    private Boolean preventEndermanTeleport = true;
    private Boolean preventItemPickup = true;
    private Boolean preventSilverfishInfection = true;
    private Boolean preventSunburn = false;
    private Boolean preventExploding = false;
    private Boolean preventMobKillDrops = false;
    private Boolean preventTransformation = true;
    private Boolean preventMounts = false;
    private Boolean passthroughDamage = false;
    private Boolean applyInvisibility = false;
    private Boolean visibleByDefault = false;
    private Boolean digOutOfGround = false;
    private Boolean randomizeProperties = true;
    private Boolean usesHealthBar = false;
    private float speechBubbleOffset = 0.4f;
    protected double spawnVelocityX = 0.0;
    protected double spawnVelocityXMax = 0.0;
    protected double spawnVelocityY = 0.0;
    protected double spawnVelocityYMax = 0.0;
    protected double spawnVelocityZ = 0.0;
    protected double spawnVelocityZMax = 0.0;
    protected Boolean spawnVelocityXRange = false;
    protected Boolean spawnVelocityYRange = false;
    protected Boolean spawnVelocityZRange = false;
    protected List<PlaceholderString> killMessages;
    private PlaceholderString disguise = null;
    private DropMethod dropMethod = DropMethod.VANILLA;
    private boolean dropsPerPlayer = false;
    private Boolean dropsDoLootsplosion = false;
    private Boolean dropsAreClientsideByDefault = false;
    private Boolean dropsShowNameByDefault = false;
    private Boolean dropsGlowByDefault = false;
    private Boolean dropsHaveBeamByDefault = false;
    private Boolean dropsHaveVFXByDefault = false;
    private Material dropsItemVFXMaterial;
    private int dropsItemVFXModel;
    private double dropsPerPlayerRequiredDamagePercent = 0.0;
    private Boolean damageLeaderboard = false;
    private Boolean showChatLeaderboardOnDeath = false;
    private Boolean showHologramLeaderboardOnDeath = false;
    private Integer hologramLeaderboardTimeout = 6000;
    private List<String> fancyDropHologramMessage = Lists.newArrayList();
    private List<String> fancyDropChatMessage = Lists.newArrayList();
    private final transient ReentrantLock skillLock = new ReentrantLock();

    /*
     * WARNING - void declaration
     */
    public MobType(MobExecutor manager, Pack pack, File file, String internalName, MythicConfig mc) {
        StatType statType;
        String statName;
        List<String> list;
        List<String> list2;
        List<String> list3;
        PlaceholderDouble attrScale;
        PlaceholderDouble attrStepHeight;
        PlaceholderDouble attrFollowRange;
        PlaceholderDouble attrKnockbackResist;
        PlaceholderDouble attrFlyingSpeed;
        PlaceholderDouble attrMovementSpeed;
        PlaceholderDouble attrAttackSpeed;
        PlaceholderDouble attrArmor;
        PlaceholderDouble attrDamage;
        PlaceholderDouble attrHealth;
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.pack = pack;
        this.config = mc;
        this.file = file;
        this.internalName = internalName;
        ConfigExecutor configManager = this.plugin.getConfiguration();
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading MythicMob type '{0}'...", this.internalName);
        this.entityTypeString = mc.getString(new String[]{"Type", "MobType", "Mobtype"}, this.entityTypeString, new String[0]);
        if (this.entityTypeString == null) {
            BukkitEntityType me = BukkitEntityType.getMythicEntity(internalName);
            if (me == null) {
                MythicLogger.errorMobConfig(this, mc, "Could not load MythicMob " + this.internalName + "! No Type specified.");
                this.entityTypeString = "NULL";
                this.entityType = MythicEntityType.COD;
                this.entityBaseSpawner = BukkitEntityType.getMythicEntity(MythicEntityType.COD);
                this.displayName = PlaceholderString.of("ERROR: MOB TYPE FOR '" + this.internalName + "' IS NOT OPTIONAL");
                return;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ EntityType is vanilla override for {0}", this.entityTypeString);
            this.entityType = MythicEntityType.get(internalName);
            this.entityBaseSpawner = me;
        } else {
            this.entityType = MythicEntityType.get(this.entityTypeString);
            this.entityBaseSpawner = BukkitEntityType.getMythicEntity(this.entityType);
        }
        this.isHidden = mc.getBoolean("Hidden", false);
        if (this.entityBaseSpawner == null) {
            MythicLogger.error("Could not load MythicMob {0}! Invalid type specified.", this.internalName);
            this.entityTypeString = "NULL";
            this.entityType = MythicEntityType.COD;
            this.entityBaseSpawner = BukkitEntityType.getMythicEntity(MythicEntityType.COD);
            this.displayName = PlaceholderString.of("ERROR: MOB TYPE FOR '" + this.internalName + "' IS INVALID");
            return;
        }
        this.entityBaseSpawner.instantiate(mc);
        String strDisplayName = mc.getString("Display", this.displayName == null ? null : this.displayName.toString());
        strDisplayName = mc.getString("DisplayName", strDisplayName);
        if (strDisplayName != null) {
            this.displayName = PlaceholderString.of(strDisplayName);
        }
        if (mc.isSet("Model")) {
            Schedulers.sync().runLater(() -> {
                if (mc.isSet("Model.Type")) {
                    String modelType = mc.getString("Model.Type").toUpperCase();
                    if (modelType.startsWith("MPE") || modelType.equalsIgnoreCase("MINIATUREPE")) {
                        if (((MythicBukkit)manager.getPlugin()).getCompatibility().getMiniaturePets().isPresent()) {
                            this.model = new MPetsModel(this, mc);
                        }
                    } else if (((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().isPresent()) {
                        this.model = ((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().get().createMobModel(this, mc);
                        this.applyInvisibility = true;
                    }
                } else if (((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().isPresent()) {
                    this.model = ((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().get().createMobModel(this, mc);
                    this.applyInvisibility = true;
                }
            }, 1L);
        } else {
            this.model = null;
        }
        List<String> lstStats = mc.getStringList("Stats");
        this.stats = Maps.newConcurrentMap();
        if (!lstStats.isEmpty()) {
            for (String stat : lstStats) {
                try {
                    String[] split = stat.split(" ");
                    String typeName = split[0];
                    PlaceholderDouble value = PlaceholderDouble.of(split[1]);
                    StatType statType2 = ((MythicBukkit)manager.getPlugin()).getStatManager().getStatOrRegisterStatic(typeName);
                    this.stats.put(statType2, value);
                }
                catch (Exception ex) {
                    MythicLogger.errorMobConfig(this, mc, "Invalid syntax for Stat line: " + stat);
                }
            }
        }
        if ((attrHealth = mc.getPlaceholderDouble("Health", null)) != null) {
            this.stats.put(Stats.HEALTH, attrHealth);
        }
        if ((attrDamage = mc.getPlaceholderDouble("Damage", null)) != null) {
            this.stats.put(Stats.ATTACK_DAMAGE, attrDamage);
        }
        if ((attrArmor = mc.getPlaceholderDouble(new String[]{"Armor", "Armour"}, null, new String[0])) != null) {
            this.stats.put(Stats.ARMOR, attrArmor);
        }
        if ((attrAttackSpeed = mc.getPlaceholderDouble("Options.AttackSpeed", null)) != null) {
            this.stats.put(Stats.ATTACK_SPEED, attrAttackSpeed);
        }
        if ((attrMovementSpeed = mc.getPlaceholderDouble("Options.MovementSpeed", null)) != null) {
            this.stats.put(Stats.MOVEMENT_SPEED, attrMovementSpeed);
        }
        if ((attrFlyingSpeed = mc.getPlaceholderDouble("Options.FlyingSpeed", null)) != null) {
            this.stats.put(Stats.FLYING_SPEED, attrFlyingSpeed);
        }
        if ((attrKnockbackResist = mc.getPlaceholderDouble("Options.KnockbackResistance", null)) != null) {
            this.stats.put(Stats.KNOCKBACK_RESISTANCE, attrKnockbackResist);
        }
        if ((attrFollowRange = mc.getPlaceholderDouble("Options.FollowRange", null)) != null) {
            this.stats.put(Stats.FOLLOW_RANGE, attrFollowRange);
        }
        if ((attrStepHeight = mc.getPlaceholderDouble("StepHeight", null)) != null) {
            this.stats.put(Stats.STEP_HEIGHT, attrStepHeight);
        }
        if ((attrScale = mc.getPlaceholderDouble("Options.Scale", null)) != null) {
            this.stats.put(Stats.SCALE, attrScale);
        }
        if (mc.isSet("Variables") && mc.isConfigurationSection("Variables")) {
            this.setupDefaultVariableValues();
        }
        AbstractItemStack eggItem = configManager.getDefaultMobEggItem();
        this.eggDisplay = mc.getPlaceholderString("Egg.Display", null);
        this.eggModel = mc.getPlaceholderString("Egg.Model", null);
        String eggMobNameAaaa = mc.getString("MythicEggDisplay", null);
        this.eggMobName = mc.getPlaceholderString("Egg.MobName", eggMobNameAaaa);
        if (mc.isSet("Egg.Lore")) {
            this.eggLore = mc.getPlaceholderStringListAlt("Egg.Lore", configManager.getDefaultMobEggLore());
        }
        if (mc.isSet("Totem")) {
            this.totemConfig = new TotemConfig(this, mc.getNestedConfig("Totem"));
            this.getPlugin().getMobManager().getTotemManager().registerTotem(this);
        }
        this.optionReviveHealth = mc.getDouble("Options.ReviveHealth", 10.0);
        this.optionInvincible = mc.getBoolean("Options.Invincible", false);
        this.optionInvincible = mc.getBoolean("Options.Invulnerable", this.optionInvincible);
        this.faction = mc.getString("Faction", null);
        String mount = mc.getString("Mount", null);
        mount = mc.getString("Riding", mount);
        this.mount = Optional.ofNullable(mount);
        String rider = mc.getString("Rider", null);
        rider = mc.getString("Passenger", rider);
        this.rider = Optional.ofNullable(rider);
        boolean despawnByDefault = this.getPlugin().getConfiguration().getMobsDespawnByDefault();
        String shouldDespawn = mc.getString("Despawn", despawnByDefault ? "TRUE" : "FALSE");
        shouldDespawn = mc.getString("Options.Despawn", shouldDespawn);
        boolean isPersistent = mc.getBoolean("Persistent", false);
        if (isPersistent = mc.getBoolean("Options.Persistent", isPersistent)) {
            shouldDespawn = DespawnMode.PERSISTENT.toString();
        }
        this.despawnMode = DespawnMode.get(shouldDespawn);
        this.optionGlowing = mc.getBoolean("Options.Glowing", false);
        this.optionCollidable = mc.getBoolean("Options.Collidable", true);
        this.optionNoGravity = mc.getBoolean("Options.NoGravity", false);
        this.optionInteractable = mc.getBoolean("Options.Interactable", this.optionInteractable);
        this.optionSilent = mc.getBoolean("Options.Silent", this.optionSilent);
        this.optionNoAI = mc.getBoolean("Options.NoAI", this.optionNoAI);
        this.optionAware = mc.getBoolean("Options.Aware", this.optionAware);
        this.optionHealOnReload = mc.getBoolean("Options.HealOnReload", this.optionHealOnReload);
        this.noDamageTicks = mc.getInteger("Options.NoDamageTicks", 10) * 2;
        this.optionLockPitch = mc.getBoolean("Options.LockPitch", this.optionLockPitch);
        this.useBossBar = mc.getBoolean("BossBar.Enabled", false);
        this.bossBarTitle = mc.getPlaceholderString("BossBar.Title", this.displayName == null ? "" : this.displayName.toString());
        this.bossBarRange = mc.getInteger("BossBar.Range", 64);
        this.bossBarRangeSq = (int)Math.pow(this.bossBarRange, 2.0);
        String bossBarColor = mc.getString("BossBar.Color", "WHITE");
        String bossBarStyle = mc.getString("BossBar.Style", "SOLID");
        try {
            this.bossBarColor = AbstractBossBar.BarColor.valueOf(bossBarColor);
        }
        catch (Exception ex) {
            this.bossBarColor = AbstractBossBar.BarColor.WHITE;
        }
        try {
            this.bossBarStyle = AbstractBossBar.BarStyle.valueOf(bossBarStyle);
        }
        catch (Exception ex) {
            this.bossBarStyle = AbstractBossBar.BarStyle.SOLID;
        }
        this.bossBarCreateFog = mc.getBoolean("BossBar.CreateFog", false);
        this.bossBarDarkenSky = mc.getBoolean("BossBar.DarkenSky", false);
        this.bossBarPlayMusic = mc.getBoolean("BossBar.PlayMusic", false);
        this.usesHealthBar = mc.getBoolean("HealthBar.Enabled", false);
        this.speechBubbleOffset = mc.getFloat("Speech.Offset", 0.4f);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Loading mob skills... ", new Object[0]);
        List<String> nSkills = mc.getStringList("Skills");
        int interval = 1;
        for (String string : nSkills) {
            Matcher Rmatcher;
            Pattern Rpattern;
            void var33_36;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Loading mechanic line: {0}", string);
            String string2 = MythicLineConfigImpl.unparseBlock(string);
            if (string2.startsWith("selfskill:")) {
                String string3 = string2.replace("selfskill:", "skill:mob:" + internalName + ":");
            } else if (string2.contains("self:")) {
                String string4 = string2.replace("self:", "skill:mob:" + internalName + ":");
            }
            SkillMechanic skillMechanic = this.getPlugin().getSkillManager().getMechanic(pack, mc.getFile(), this, (String)var33_36);
            if (skillMechanic == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "-! Mechanic was not found. Skipping.", new Object[0]);
                continue;
            }
            skillMechanic.setParent(this);
            if (var33_36.contains("~onTimer")) {
                Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                Rmatcher = Rpattern.matcher((CharSequence)var33_36);
                Rmatcher.find();
                try {
                    interval = Integer.parseInt(Rmatcher.group(1));
                }
                catch (Exception exception) {
                    MythicLogger.errorMobConfig(this, mc, "Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + (String)var33_36);
                    continue;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Mechanic set on timer with interval {0}", interval);
                skillMechanic.setTimerInterval(interval);
                this.timerSkills.add(skillMechanic);
                continue;
            }
            if (var33_36.contains("~onSignal:")) {
                String string5;
                Rpattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                Rmatcher = Rpattern.matcher((CharSequence)var33_36);
                Rmatcher.find();
                try {
                    string5 = Rmatcher.group(1);
                }
                catch (Exception e) {
                    MythicLogger.errorMobConfig(this, mc, "Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + (String)var33_36);
                    continue;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Mechanic set on Signal with key '{0}'", string5);
                if (this.signalSkills.containsKey(string5)) {
                    this.signalSkills.get(string5).add(skillMechanic);
                    continue;
                }
                ArrayList<SkillMechanic> signalMechanics = new ArrayList<SkillMechanic>();
                signalMechanics.add(skillMechanic);
                this.signalSkills.put(string5, signalMechanics);
                continue;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Loading mechanic to base skill tree...", new Object[0]);
            SkillTrigger skillTrigger = skillMechanic.getTrigger();
            if (skillTrigger.equals(SkillTriggers.SPAWN_OR_LOAD)) {
                if (!this.skills.containsKey(SkillTriggers.SPAWN)) {
                    this.skills.put(SkillTriggers.SPAWN, Queues.newConcurrentLinkedQueue());
                }
                if (!this.skills.containsKey(SkillTriggers.LOAD)) {
                    this.skills.put(SkillTriggers.LOAD, Queues.newConcurrentLinkedQueue());
                }
                this.skills.get(SkillTriggers.SPAWN).add(skillMechanic);
                this.skills.get(SkillTriggers.LOAD).add(skillMechanic);
                continue;
            }
            if (!this.skills.containsKey(skillTrigger)) {
                this.skills.put(skillTrigger, Queues.newConcurrentLinkedQueue());
            }
            this.skills.get(skillMechanic.getTrigger()).add(skillMechanic);
        }
        if (!this.timerSkills.isEmpty()) {
            this.usingTimers = true;
        }
        if (this.hasSkills(SkillTriggers.COMBAT)) {
            this.hasCombatSkills = true;
        }
        this.optionShowHealthInChat = mc.getBoolean("ShowHealth", false);
        this.useThreatTable = mc.getBoolean("Modules.ThreatTable", false);
        this.useImmunityTable = mc.getBoolean("Modules.ImmunityTable", false);
        this.useCustomNameplate = mc.getBoolean("Nameplate.Enabled", strDisplayName != null && strDisplayName.contains("\\n"));
        this.useThreatTable = mc.getBoolean("Options.UseThreatTable", this.useThreatTable);
        this.useImmunityTable = mc.getBoolean("Options.UseImmunityTable", this.useImmunityTable);
        this.useThreatTable = mc.getBoolean("ThreatTable.Enabled", this.useThreatTable);
        this.optionTTFromDamage = mc.getBoolean("ThreatTable.UseDamageTaken", true);
        this.optionTTDecayUnreachable = mc.getBoolean("ThreatTable.DecayUnreachable", true);
        this.useThreatTable = mc.getBoolean("ThreatTables.Enabled", this.useThreatTable);
        this.optionTTFromDamage = mc.getBoolean("ThreatTables.UseDamageTaken", this.optionTTFromDamage);
        this.optionTTDecayUnreachable = mc.getBoolean("ThreatTables.DecayUnreachable", this.optionTTDecayUnreachable);
        this.useHearing = mc.getBoolean("Hearing.Enabled", false);
        this.maxAttackRange = mc.getInteger("Options.MaxAttackRange", 64);
        this.maxAttackableRange = mc.getInteger("Options.MaxCombatDistance", 256);
        this.maxAttackableRange = mc.getInteger("Options.MaxAttackableRange", this.maxAttackableRange);
        this.maxThreatDistance = mc.getInteger("Options.MaxThreatDistance", 40);
        this.alwaysShowName = mc.getBoolean("Options.AlwaysShowName", false);
        this.showNameOnDamage = mc.getBoolean("Options.ShowNameOnDamaged", false);
        this.repeatAllSkills = mc.getBoolean("Options.RepeatAllSkills", false);
        this.preventVanillaDamage = mc.getBoolean("Options.PreventVanillaDamage", this.getPlugin().getConfiguration().getPreventVanillaDamageByDefault());
        this.preventOtherDrops = mc.getBoolean("Options.PreventOtherDrops", this.getPlugin().getConfiguration().getPreventOtherDropsByDefault());
        this.preventRandomEquipment = mc.getBoolean("Options.PreventRandomEquipment", false);
        this.preventLeashing = mc.getBoolean("Options.PreventLeashing", true);
        this.preventKnockback = mc.getBoolean("Options.PreventKnockback", false);
        this.preventRename = mc.getBoolean("Options.PreventRenaming", true);
        this.preventSunburn = mc.getBoolean("Options.PreventSunburn", false);
        this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleport", false);
        this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleporting", this.preventEndermanTeleport);
        this.preventTransformation = mc.getBoolean("Options.PreventTransformation", true);
        this.preventTransformation = mc.getBoolean("Options.PreventTransforming", this.preventTransformation);
        this.preventTransformation = mc.getBoolean("Options.PreventTransform", this.preventTransformation);
        this.preventMounts = mc.getBoolean("Options.PreventMounts", false);
        this.preventMounts = mc.getBoolean("Options.PreventJockey", this.preventMounts);
        this.preventMounts = mc.getBoolean("Options.PreventJockeyMounts", this.preventMounts);
        this.preventItemPickup = mc.getBoolean("Options.PreventItemPickup", true);
        this.preventMobKillDrops = mc.getBoolean("Options.PreventMobKillDrops", false);
        this.passthroughDamage = mc.getBoolean("Options.PassthroughDamage", false);
        this.applyInvisibility = mc.getBoolean("Options.ApplyInvisibility", false);
        this.applyInvisibility = mc.getBoolean("Options.Invisibility", this.applyInvisibility);
        this.applyInvisibility = mc.getBoolean("Options.Invisible", this.applyInvisibility);
        this.randomizeProperties = mc.getBoolean("Options.RandomizeProperties", true);
        this.aiNavigator = mc.getString("AINavigator", null);
        List<String> lstAIGoalSelectors = mc.getStringList("AIGoalSelectors", mc.getStringList("AIGoals"));
        if (lstAIGoalSelectors != null) {
            for (String string : lstAIGoalSelectors) {
                String string6 = MythicLineConfigImpl.unparseBlock(string);
                this.aiGoalSelectors.add(string6);
            }
        }
        if ((list3 = mc.getStringList("AITargetSelectors", mc.getStringList("AITargets"))) != null) {
            for (String string : list3) {
                String string7 = MythicLineConfigImpl.unparseBlock(string);
                this.aiTargetSelectors.add(string7);
            }
        }
        if ((list2 = mc.getStringList("AIPathfindingMalus")) != null) {
            for (String s5 : list2) {
                try {
                    String[] split = s5.split(" ");
                    this.aiPathfindingMalus.put(split[0], Float.valueOf(Float.parseFloat(split[1])));
                }
                catch (Error | Exception ex) {
                    MythicLogger.errorMobConfig(this, mc, "Invalid format for PathfindingMalus line " + s5);
                    ex.printStackTrace();
                }
            }
        }
        this.visibleByDefault = mc.getBoolean("Options.VisibleByDefault", true);
        List<String> list4 = mc.getStringList("Drops");
        this.dropTable = new DropTable(this.file.getAbsolutePath(), "Mob:" + this.internalName, list4, true);
        this.dropMethod = DropMethod.valueOf(mc.getString("DropOptions.DropMethod", "VANILLA").toUpperCase());
        this.showChatLeaderboardOnDeath = mc.getBoolean("DropOptions.ShowDeathChatMessage", false);
        this.showHologramLeaderboardOnDeath = mc.getBoolean("DropOptions.ShowDeathHologram", false);
        this.fancyDropHologramMessage = mc.getStringList("DropOptions.HologramMessage", configManager.getMobDrosDefaultDeathHologram());
        this.fancyDropChatMessage = mc.getStringList("DropOptions.ChatMessage", configManager.getMobDropsDefaultChatMessage());
        if (!this.fancyDropChatMessage.isEmpty()) {
            this.fancyDropChatMessage.replaceAll(line -> {
                if (line == null || line.isEmpty() || line.equals(" ")) {
                    return "<red> ";
                }
                return line;
            });
        }
        this.dropsPerPlayer = mc.getBoolean("DropOptions.PerPlayerDrops", configManager.isMobDropsPerPlayer());
        this.dropsDoLootsplosion = mc.getBoolean("DropOptions.Lootsplosion", configManager.isMobDropsDoLoopslosion());
        this.dropsAreClientsideByDefault = mc.getBoolean("DropOptions.ClientSideDrops", configManager.isMobDropsAreClientside());
        this.dropsShowNameByDefault = mc.getBoolean("DropOptions.HologramItemNames", configManager.isMobDropsDoNameHologram());
        this.dropsGlowByDefault = mc.getBoolean("DropOptions.ItemGlowByDefault", configManager.isMobDropsDoItemGlow());
        this.dropsHaveBeamByDefault = mc.getBoolean("DropOptions.ItemBeamByDefault", configManager.isMobDropsDoItemBeam());
        this.dropsHaveVFXByDefault = mc.getBoolean("DropOptions.ItemVFXByDefault", configManager.isMobDropsDoItemVFX());
        this.hologramLeaderboardTimeout = mc.getInt("DropOptions.HologramTimeout", configManager.getHologramLeaderboardTimeout());
        try {
            this.dropsItemVFXMaterial = Material.valueOf((String)mc.getString("DropOptions.ItemVFX.Material", configManager.getMobDropsItemVFXMaterial().toString()));
            this.dropsItemVFXModel = mc.getInt("DropOptions.ItemVFX.Model", configManager.getMobDropsItemVFXModel());
        }
        catch (Throwable ex) {
            MythicLogger.errorMobConfig(this, mc, "Error in DropOptions.ItemVFX configuration");
        }
        this.dropsPerPlayerRequiredDamagePercent = mc.getDouble("DropOptions.RequiredDamagePercent", configManager.getMobDropsPerPlayerRequiredDamagePercent());
        if (this.dropMethod == DropMethod.VANILLA && (this.dropsDoLootsplosion.booleanValue() || this.dropsAreClientsideByDefault.booleanValue() || this.dropsShowNameByDefault.booleanValue() || this.dropsGlowByDefault.booleanValue() || this.dropsHaveBeamByDefault.booleanValue())) {
            this.dropMethod = DropMethod.FANCY;
        }
        if (this.dropMethod == DropMethod.FANCY || this.dropsPerPlayer || this.showChatLeaderboardOnDeath.booleanValue() || this.showHologramLeaderboardOnDeath.booleanValue()) {
            this.damageLeaderboard = true;
        }
        List<String> equipment = mc.getStringList("Equipment");
        this.equipmentTable = new DropTable(this.file.getAbsolutePath(), "MobEquipment:" + this.internalName, equipment, true);
        List<String> lstDamageMod = mc.getStringList("DamageModifiers");
        this.damageModifiers = new HashMap<String, Double>();
        if (lstDamageMod != null && !lstDamageMod.isEmpty()) {
            for (String string : lstDamageMod) {
                try {
                    String[] stringArray = string.split(" ");
                    String string8 = stringArray[0];
                    Double mod = Double.valueOf(stringArray[1]);
                    this.damageModifiers.put(string8, mod);
                }
                catch (Exception exception) {
                    MythicLogger.errorMobConfig(this, mc, "Invalid syntax for DamageModifier line: " + string);
                }
            }
        }
        List<String> lstEntDamageMod = mc.getStringList("EntityDamageModifiers");
        this.entityDamageModifiers = new HashMap<String, Double>();
        if (lstEntDamageMod != null && lstEntDamageMod.size() > 0) {
            for (String string : lstEntDamageMod) {
                try {
                    String[] stringArray = string.split(" ");
                    String type = stringArray[0];
                    double mod = Double.valueOf(stringArray[1]);
                    this.entityDamageModifiers.put(type, mod);
                }
                catch (Exception exception) {
                    MythicLogger.errorMobConfig(this, mc, "Invalid syntax for DamageModifier");
                }
            }
        }
        if ((list = mc.getStringList("KillMessages")) != null && !list.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Loading mob kill messages...", new Object[0]);
            if (this.killMessages == null) {
                this.killMessages = new ArrayList<PlaceholderString>();
            }
            list.forEach(message -> this.killMessages.add(PlaceholderString.of(message)));
        }
        if (mc.isSet("LevelModifiers")) {
            this.statLevelModifiers = new ConcurrentHashMap<StatType, Double>();
            if (mc.isConfigurationSection("LevelModifiers")) {
                for (String string : mc.getKeys("LevelModifiers")) {
                    statName = StatManager.translateLegacyStatAliases(string);
                    Optional<StatType> maybeStat = this.getPlugin().getStatManager().getStat(statName);
                    if (!maybeStat.isPresent()) continue;
                    statType = maybeStat.get();
                    double value = mc.getDouble("LevelModifiers." + string, 0.0);
                    this.statLevelModifiers.put(statType, value);
                }
            } else if (mc.isList("LevelModifiers")) {
                for (String string : mc.getStringList("LevelModifiers")) {
                    try {
                        String[] split = string.split(" ");
                        String statName2 = StatManager.translateLegacyStatAliases(split[0]);
                        Optional<StatType> maybeStat = this.getPlugin().getStatManager().getStat(statName2);
                        if (!maybeStat.isPresent()) continue;
                        StatType statType3 = maybeStat.get();
                        Double value = Double.valueOf(split[1]);
                        this.statLevelModifiers.put(statType3, value);
                    }
                    catch (Exception split) {}
                }
            }
        }
        for (Map.Entry<String, String> entry : configManager.getStatDefaultLevelModifiers().entrySet()) {
            PlaceholderDouble baseValue;
            if (this.statLevelModifiers == null) {
                this.statLevelModifiers = new ConcurrentHashMap<StatType, Double>();
            }
            statName = StatManager.translateLegacyStatAliases(entry.getKey());
            Optional<StatType> maybeStat = this.getPlugin().getStatManager().getStat(statName);
            if (maybeStat.isEmpty() || this.statLevelModifiers.containsKey(statType = maybeStat.get()) || (baseValue = this.stats.get(statType)) == null || !baseValue.isStatic()) continue;
            String strDefaultModifier = entry.getValue();
            try {
                double modifier = strDefaultModifier.startsWith("+") ? Double.valueOf(strDefaultModifier.substring(1)) : (strDefaultModifier.startsWith("*") ? baseValue.get() * Double.valueOf(strDefaultModifier.substring(1)) : baseValue.get() * Double.valueOf(strDefaultModifier));
                this.statLevelModifiers.put(statType, modifier);
            }
            catch (Exception ex) {
                MythicLogger.error("Error calculating Damage Level Modifier: Default configuration is bad.", ex);
            }
        }
        this.digOutOfGround = mc.getBoolean("Options.DigOutOfGround", false);
        String string = mc.getString("SpawnModifiers.VelocityX", "0");
        String string9 = mc.getString("SpawnModifiers.VelocityY", "0");
        String strSpawnVelocityZ = mc.getString("SpawnModifiers.VelocityZ", "0");
        if (string.contains("to")) {
            String[] split = string.split("to");
            try {
                this.spawnVelocityX = Double.valueOf(split[0]);
                this.spawnVelocityXMax = Double.valueOf(split[1]);
                this.spawnVelocityXRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityX = Double.valueOf(string);
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        }
        if (string9.contains("to")) {
            String[] split = string9.split("to");
            try {
                this.spawnVelocityY = Double.valueOf(split[0]);
                this.spawnVelocityYMax = Double.valueOf(split[1]);
                this.spawnVelocityYRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityY = Double.valueOf(string9);
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        }
        if (strSpawnVelocityZ.contains("to")) {
            String[] split = strSpawnVelocityZ.split("to");
            try {
                this.spawnVelocityZ = Double.valueOf(split[0]);
                this.spawnVelocityZMax = Double.valueOf(split[1]);
                this.spawnVelocityZRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityZ = Double.valueOf(strSpawnVelocityZ);
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        }
        if (mc.isSet("Disguise")) {
            this.disguise = mc.getPlaceholderString("Disguise", null);
        }
        Map<String, MythicConfig> mobSpecificMetaSkills = mc.getNestedConfigs("MetaSkills");
        for (Map.Entry<String, MythicConfig> entry : mobSpecificMetaSkills.entrySet()) {
            String key = entry.getKey();
            MythicConfig metaConfig = entry.getValue();
            String metaSkillName = "mob:" + this.getInternalName() + ":" + key;
            MetaSkill metaSkill = new MetaSkill(this.getPlugin().getSkillManager(), this, pack, file, metaSkillName, metaConfig);
            this.getPlugin().getSkillManager().registerSkill(metaSkillName, metaSkill);
        }
        this.buildCache(false);
    }

    @Override
    public void buildCache() {
        this.buildCache(true);
    }

    public void buildCache(boolean refreshMobs) {
        this.cachedMenuItem = this.entityBaseSpawner.getHead();
        this.cachedMenuItem = ItemFactory.of(this.cachedMenuItem).hideAttributes().lore("<red> ").lore("<rainbow>\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583").lore("<red> ").lore("<gray>\u22b3 <white>Left-Click to get mob egg").lore("<gray>\u22b3 <white>Right-Click to Edit <red>(ALPHA FEATURE)").build();
        if (refreshMobs) {
            this.getManager().getActiveMobs(am -> am.getType().equals(this)).forEach(mob -> mob.remountType());
        }
    }

    @Override
    public ActiveMob spawn(AbstractLocation location, double level) {
        return this.spawn(location, level, SpawnReason.OTHER);
    }

    @Override
    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason) {
        return this.spawn(location, level, reason, null);
    }

    @Override
    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawn(location, level, reason, prespawnFunc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason, Consumer<Entity> prespawnFunc, MythicSpawner spawner) {
        MobExecutor.spawnflag = true;
        try {
            WorldGuardSupport worldGuardSupport;
            MythicMobPreSpawnEvent preEvent = Events.callAndReturn(new MythicMobPreSpawnEvent(this, location, level, reason));
            if (preEvent.isCancelled()) {
                ActiveMob activeMob = null;
                return activeMob;
            }
            if (this.getPlugin().getCompatibility().getWorldGuard().isPresent() && !(worldGuardSupport = this.getPlugin().getCompatibility().getWorldGuard().get()).getLocationAllowsMobSpawning(BukkitAdapter.adapt(location))) {
                ActiveMob activeMob = null;
                return activeMob;
            }
            if (this.entityBaseSpawner == null) {
                ActiveMob activeMob = null;
                return activeMob;
            }
            Entity e = BukkitAdapter.adapt(this.entityBaseSpawner.spawn(location, reason.withRandomizeSpawnProperties(this.randomizeProperties), (Entity entity) -> {
                entity.getPersistentDataContainer().set(MobKeys.TYPE, PersistentDataType.STRING, (Object)this.internalName);
                entity.getPersistentDataContainer().set(MobKeys.LEVEL, PersistentDataType.DOUBLE, (Object)level);
                if (this.applyInvisibility.booleanValue() && entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
                }
                if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20)) {
                    entity.setVisibleByDefault(this.visibleByDefault.booleanValue());
                }
                if (this.model != null) {
                    this.model.apply(BukkitAdapter.adapt(entity));
                } else if (this.disguise != null && CompatibilityManager.LibsDisguises != null) {
                    CompatibilityManager.LibsDisguises.preDisguise((Entity)entity, this.disguise.get());
                }
                if (prespawnFunc != null) {
                    prespawnFunc.accept((Entity)entity);
                }
            }));
            ActiveMob am = new ActiveMob(BukkitAdapter.adapt(e), this, preEvent.getMobLevel());
            if (spawner != null) {
                am.setSpawner(spawner);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobSpawnEvent for " + this.getInternalName() + " (level: " + level + ")", new Object[0]);
            MythicMobSpawnEvent event = new MythicMobSpawnEvent(am, level, reason);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                e.remove();
                ActiveMob activeMob = null;
                return activeMob;
            }
            this.getManager().registerActiveMob(am);
            this.applyMobOptions(am, level, true);
            this.applyMobVolatileOptions(am);
            am = this.applySpawnModifiers(am);
            if (this.hasSkills(SkillTriggers.SPAWN)) {
                SkillMetadata data = this.getPlugin().getSkillManager().getEventBus().buildSkillMetadata(SkillTriggers.SPAWN, am, null, null, false);
                this.getPlugin().getSkillManager().getEventBus().processTriggerMechanics(data);
            }
            ActiveMob activeMob = am;
            return activeMob;
        }
        finally {
            MobExecutor.spawnflag = false;
        }
    }

    @Override
    public ActiveMob applyMobOptions(ActiveMob am, double level) {
        return this.applyMobOptions(am, level, false);
    }

    public ActiveMob applyMobOptions(ActiveMob am, double level, boolean firstSpawn) {
        AbstractEntity aEntity = am.getEntity();
        if (aEntity.isLiving() && am.isDead()) {
            aEntity.remove();
            am.unregister(true);
            return am;
        }
        aEntity.setRemoveWhenFarAway(am.getDespawnMode().getDespawnWithoutNearbyPlayers());
        aEntity.setPersistent(am.getDespawnMode().getSavesToDisk());
        aEntity.setAlwaysShowName(this.alwaysShowName);
        Entity bukkitEntity = aEntity.getBukkitEntity();
        if (aEntity.isLiving()) {
            double health;
            LivingEntity asLiving = (LivingEntity)bukkitEntity;
            if (this.preventItemPickup.booleanValue()) {
                asLiving.setCanPickupItems(false);
            }
            if (this.applyInvisibility.booleanValue()) {
                asLiving.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
            }
            if ((health = this.getHealth(am)) > 0.0) {
                if (this.optionHealOnReload) {
                    aEntity.setHealthAndMax(health);
                } else {
                    double hp = aEntity.getHealth();
                    if (hp < aEntity.getMaxHealth()) {
                        double ratio = hp / aEntity.getMaxHealth();
                        aEntity.setMaxHealth(health);
                        aEntity.setHealth(health * ratio);
                    } else {
                        aEntity.setHealthAndMax(health);
                    }
                }
            }
            if (!this.optionCollidable) {
                asLiving.setCollidable(false);
            }
            asLiving.setMaximumNoDamageTicks(this.noDamageTicks);
            ActiveMob amm = am;
            Schedulers.of(bukkitEntity).runLater(() -> {
                EntityEquipment ee;
                if (amm.getEntity() == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MythicMob {0} failed to spawn - was despawned by other plugin", this.internalName);
                    return;
                }
                if (this.preventOtherDrops.booleanValue() && asLiving instanceof Mob) {
                    ee = asLiving.getEquipment();
                    ee.setHelmetDropChance(0.0f);
                    ee.setChestplateDropChance(0.0f);
                    ee.setLeggingsDropChance(0.0f);
                    ee.setBootsDropChance(0.0f);
                }
                if (this.preventRandomEquipment.booleanValue() && System.currentTimeMillis() - amm.getSpawnTime() < 5000L) {
                    ee = asLiving.getEquipment();
                    assert (ee != null);
                    ee.clear();
                    ee.setArmorContents(new ItemStack[]{new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR)});
                }
                this.equipmentTable.generate(new DropMetadataImpl(amm, amm.getEntity())).equip(amm.getEntity());
                am.checkEquipment();
                ee = asLiving.getEquipment();
                assert (ee != null);
                if (asLiving instanceof Creature) {
                    Creature creature = (Creature)asLiving;
                    ee.setItemInMainHandDropChance(0.0f);
                    ee.setItemInOffHandDropChance(0.0f);
                    ee.setHelmetDropChance(0.0f);
                    ee.setChestplateDropChance(0.0f);
                    ee.setLeggingsDropChance(0.0f);
                    ee.setBootsDropChance(0.0f);
                }
                if (this.useCustomNameplate) {
                    amm.setShowCustomNameplate(true);
                }
            }, 5L);
            if (this.getDisplayName() != null) {
                aEntity.setCustomName(am.getDisplayName());
            }
        }
        if (this.optionInvincible) {
            bukkitEntity.setInvulnerable(true);
        }
        if (this.optionGlowing) {
            bukkitEntity.setGlowing(true);
        }
        if (this.optionNoGravity) {
            bukkitEntity.setGravity(false);
        }
        if (this.optionSilent) {
            bukkitEntity.setSilent(true);
        }
        if (!firstSpawn && this.model != null) {
            this.model.apply(am.getEntity());
        }
        if (firstSpawn && this.mount.isPresent() && !MobExecutor.mountflag && this.getManager().getMythicMob(this.mount.get()) != null) {
            this.getManager();
            MobExecutor.mountflag = true;
            if (bukkitEntity.getVehicle() != null) {
                bukkitEntity.getVehicle().remove();
            }
            AbstractEntity mount = this.getManager().getMythicMob(this.mount.get()).get().spawn(am.getLocation(), level, SpawnReason.SUMMON).getEntity();
            this.getManager();
            MobExecutor.mountflag = false;
            mount.setPassenger(bukkitEntity);
            ActiveMob mountInstance = this.getManager().getMythicMobInstance(mount);
            am.setMount(mountInstance);
            mountInstance.setParent(am);
        }
        if (this.rider.isPresent()) {
            this.getManager();
            if (!MobExecutor.mountflag && this.getManager().getMythicMob(this.rider.get()) != null) {
                this.getManager();
                MobExecutor.mountflag = true;
                AbstractEntity rider = this.getManager().getMythicMob(this.rider.get()).get().spawn(am.getLocation(), level, SpawnReason.SUMMON).getEntity();
                this.getManager();
                MobExecutor.mountflag = false;
                rider.setPassenger(bukkitEntity);
                ActiveMob riderInstance = this.getManager().getMythicMobInstance(rider);
                riderInstance.setMount(am);
                riderInstance.setParent(am);
            }
        }
        return am;
    }

    @Override
    public ActiveMob applyMobVolatileOptions(ActiveMob am) {
        Entity e = am.getEntity().getBukkitEntity();
        if (am.getEntity().isMob()) {
            if (this.optionNoAI) {
                am.getEntity().setAI(false);
            }
            if (!this.optionAware) {
                am.getEntity().setAware(false);
            }
            if (this.aiNavigator != null) {
                this.getPlugin().getVolatileCodeHandler().getAIHandler().setNavigationController(am.getEntity(), this.aiNavigator);
            }
            if (this.getAIGoalSelectors() != null) {
                this.getPlugin().getVolatileCodeHandler().getAIHandler().addPathfinderGoals((LivingEntity)e, this.getAIGoalSelectors());
            }
            if (this.getAITargetSelectors() != null) {
                this.getPlugin().getVolatileCodeHandler().getAIHandler().addTargetGoals((LivingEntity)e, this.getAITargetSelectors());
            }
            if (!this.aiPathfindingMalus.isEmpty()) {
                for (Map.Entry<String, Float> entry : this.aiPathfindingMalus.entrySet()) {
                    this.getPlugin().getVolatileCodeHandler().getAIHandler().setPathfindingMalus(am.getEntity(), entry.getKey(), entry.getValue().floatValue());
                }
            }
        }
        if (this.disguise != null && CompatibilityManager.LibsDisguises != null) {
            Schedulers.of(e).run(() -> CompatibilityManager.LibsDisguises.setDisguise(am, this.disguise.get(am)));
        }
        return am;
    }

    @Override
    public ActiveMob applySpawnModifiers(ActiveMob am) {
        double vl;
        AbstractEntity e = am.getEntity();
        AbstractVector v = e.getVelocity();
        if (this.spawnVelocityXRange.booleanValue()) {
            vl = Numbers.randomDouble() * (this.spawnVelocityXMax - this.spawnVelocityX) + this.spawnVelocityX;
            v.setX(vl);
        } else {
            v.setX(this.spawnVelocityX);
        }
        if (this.spawnVelocityYRange.booleanValue()) {
            vl = Numbers.randomDouble() * (this.spawnVelocityYMax - this.spawnVelocityY) + this.spawnVelocityY;
            v.setY(vl);
        } else {
            v.setY(this.spawnVelocityY);
        }
        if (this.spawnVelocityZRange.booleanValue()) {
            vl = Numbers.randomDouble() * (this.spawnVelocityZMax - this.spawnVelocityZ) + this.spawnVelocityZ;
            v.setZ(vl);
        } else {
            v.setZ(this.spawnVelocityZ);
        }
        e.setVelocity(v);
        return am;
    }

    @Override
    public void executeSkills(SkillTrigger cause, SkillMetadata data) {
        block7: {
            try {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Mechanics for ActiveMob {0} (uuid: {1})", this.internalName, data.getCaster().getEntity().getUniqueId());
                if (data.getCaster().getEntity() == null || !data.getCaster().getEntity().getWorld().isLoaded()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "! Mob is not loaded. Ignoring skills.", new Object[0]);
                    return;
                }
                if (data.getIsAsync()) {
                    for (SkillMechanic ms : this.getSkills(cause)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Running Mechanics for ActiveMob '{0}' (uuid: {1})", this.internalName, data.getCaster().getEntity().getUniqueId());
                        if (ms.getRunAsync() || !ms.isUsableFromCaster(data)) continue;
                        ms.execute(data.deepClone().setIsAsync(false));
                    }
                    Schedulers.async().run(() -> {
                        for (SkillMechanic ms : this.getSkills(cause)) {
                            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", ms.getConfigLine());
                            if (!ms.getRunAsync() || !ms.isUsableFromCaster(data)) continue;
                            ms.execute(data);
                        }
                    });
                } else {
                    for (SkillMechanic ms : this.getSkills(cause)) {
                        if (!ms.isUsableFromCaster(data)) continue;
                        ms.execute(data);
                    }
                }
            }
            catch (Error | Exception ex) {
                MythicLogger.errorMobConfig(this, this.config, "Error processing skills for mob " + this.internalName + ". Mob type may no longer exist, or may have become corrupted by a server crash, and will be removed.");
                MythicLogger.handleMinorError(ex);
                if (data.getCaster() == null || !(data.getCaster() instanceof ActiveMob)) break block7;
                this.getPlugin().getMobManager().unregisterActiveMob((ActiveMob)data.getCaster());
            }
        }
    }

    @Override
    public void executeSignalSkill(String signal, SkillMetadata data) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Executing signal skills...", new Object[0]);
        if (this.signalSkills.containsKey(signal)) {
            List<SkillMechanic> signalSkills = this.signalSkills.get(signal);
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Found {0} skills for signal {1}", signalSkills.size(), signal);
            for (SkillMechanic ms : signalSkills) {
                if (!ms.isUsableFromCaster(data)) continue;
                ms.execute(data);
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Signal skills for signal {0} not found", signal);
        }
        Queue<SkillMechanic> genericSignalSkills = this.getSkills(SkillTriggers.SIGNAL);
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Found {0} generic signal skills for signal {1}", genericSignalSkills.size(), signal);
        for (SkillMechanic ms : this.getSkills(SkillTriggers.SIGNAL)) {
            if (!ms.isUsableFromCaster(data)) continue;
            ms.execute(data);
        }
    }

    @Override
    public Queue<SkillMechanic> getSkills(SkillTrigger trigger) {
        if (this.hasCombatSkills && (trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.ATTACK || trigger == SkillTriggers.DAMAGED || trigger == SkillTriggers.DEATH)) {
            ConcurrentLinkedQueue skills = Queues.newConcurrentLinkedQueue((Iterable)this.skills.getOrDefault(trigger, new LinkedList()));
            skills.addAll((Collection)this.skills.get(SkillTriggers.COMBAT));
            return skills;
        }
        if (trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.LOAD) {
            ConcurrentLinkedQueue skills = Queues.newConcurrentLinkedQueue((Iterable)this.skills.getOrDefault(trigger, new LinkedList()));
            if (this.skills.containsKey(SkillTriggers.SPAWN_OR_LOAD)) {
                skills.addAll((Collection)this.skills.get(SkillTriggers.SPAWN_OR_LOAD));
            }
            return skills;
        }
        return this.skills.getOrDefault(trigger, new LinkedList());
    }

    @Override
    public boolean hasSkills(SkillTrigger trigger) {
        return this.skills.containsKey(trigger);
    }

    @Override
    public Queue<SkillMechanic> getTimerSkills() {
        return this.timerSkills;
    }

    @Override
    public void setEntityType(MythicEntityType type) {
        this.entityTypeString = type.toString();
        this.entityType = type;
        this.entityBaseSpawner = BukkitEntityType.getMythicEntity(this.entityType);
        this.entityBaseSpawner.instantiate(this.config);
        this.config.set("Type", this.entityTypeString);
    }

    @Override
    public String getEntityTypeString() {
        return this.entityTypeString;
    }

    @Override
    public BukkitEntityType getMythicEntity() {
        return this.entityBaseSpawner;
    }

    @Override
    public DespawnMode getDespawnMode() {
        return this.despawnMode;
    }

    @Override
    public double getPerLevelHealth() {
        return this.statLevelModifiers == null ? 0.0 : this.statLevelModifiers.getOrDefault(Stats.HEALTH, 0.0);
    }

    @Override
    public double getPerLevelDamage() {
        return this.statLevelModifiers == null ? 0.0 : this.statLevelModifiers.getOrDefault(Stats.ATTACK_DAMAGE, 0.0);
    }

    @Override
    public double getPerLevelPower() {
        return this.statLevelModifiers == null ? 0.0 : this.statLevelModifiers.getOrDefault(Stats.SKILL_POWER, 0.0);
    }

    @Override
    public Optional<Double> getBaseStatValue(ActiveMob am, StatType statType) {
        PlaceholderDouble value = this.stats.get(statType);
        if (value == null) {
            return Optional.empty();
        }
        double level = am.getLevel();
        double attr = value.get(am);
        if (level > 1.0) {
            double levelMod;
            double d = levelMod = this.statLevelModifiers == null ? 0.0 : this.statLevelModifiers.getOrDefault(statType, 0.0);
            if (levelMod > 0.0) {
                attr += levelMod * (level - 1.0);
            } else {
                Optional<Expression> maybeEq = this.getPlugin().getConfiguration().getStatScalingEquation(statType);
                if (maybeEq.isPresent()) {
                    attr = maybeEq.get().setVariable("v", attr).setVariable("l", am.getLevel()).evaluate();
                }
            }
        }
        return Optional.of(attr);
    }

    @Override
    public PlaceholderDouble getArmor() {
        return this.getStats().getOrDefault(Stats.ARMOR, PlaceholderDouble.of("0"));
    }

    @Override
    public double getPerLevelArmor() {
        return this.statLevelModifiers == null ? 0.0 : this.statLevelModifiers.getOrDefault(Stats.ARMOR, 0.0);
    }

    @Override
    public double getArmor(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.ARMOR).orElse(-1.0);
    }

    @Override
    public PlaceholderDouble getDamage() {
        return this.getStats().getOrDefault(Stats.ATTACK_DAMAGE, PlaceholderDouble.of("0"));
    }

    @Override
    public PlaceholderDouble getHealth() {
        return this.getStats().getOrDefault(Stats.HEALTH, PlaceholderDouble.of("0"));
    }

    @Override
    public double getHealth(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.HEALTH).orElse(-1.0);
    }

    @Override
    public double getDamage(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.ATTACK_DAMAGE).orElse(-1.0);
    }

    @Override
    public double getAttackSpeed(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.ATTACK_SPEED).orElse(-1.0);
    }

    @Override
    public double getMovementSpeed(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.MOVEMENT_SPEED).orElse(-1.0);
    }

    @Override
    public double getFlyingSpeed(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.FLYING_SPEED).orElse(-1.0);
    }

    @Override
    public double getKnockbackResistance(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.KNOCKBACK_RESISTANCE).orElse(0.0);
    }

    public double getFollowRange(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.FOLLOW_RANGE).orElse(0.0);
    }

    public double AttackSpeed(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.ATTACK_SPEED).orElse(0.0);
    }

    public double getScale(ActiveMob am) {
        return this.getBaseStatValue(am, Stats.SCALE).orElse(-1.0);
    }

    @Override
    public double getReviveHealth(ActiveMob am) {
        return this.optionReviveHealth <= 0.0 ? this.getHealth(am) : this.optionReviveHealth;
    }

    @Override
    public boolean hasFaction() {
        return this.faction != null;
    }

    @Override
    public boolean getIsInvincible() {
        return this.optionInvincible;
    }

    @Override
    public boolean usesThreatTable() {
        return this.useThreatTable;
    }

    @Override
    public boolean usesImmunityTable() {
        return this.useImmunityTable;
    }

    @Override
    public boolean usesHearing() {
        return this.useHearing;
    }

    @Override
    public boolean getThreatTableUseDamageTaken() {
        return this.optionTTFromDamage;
    }

    @Override
    public boolean getThreatTableDecaysUnreachable() {
        return this.optionTTDecayUnreachable;
    }

    @Override
    public List<String> getAIGoalSelectors() {
        return this.aiGoalSelectors;
    }

    @Override
    public List<String> getAITargetSelectors() {
        return this.aiTargetSelectors;
    }

    @Override
    public boolean hasKillMessages() {
        return this.killMessages != null && !this.killMessages.isEmpty();
    }

    @Override
    public PlaceholderString getKillMessage() {
        if (!this.hasKillMessages()) {
            return null;
        }
        return this.killMessages.get(Numbers.randomInt(this.killMessages.size()));
    }

    @Override
    public double getSpawnVelocityX() {
        return this.spawnVelocityX;
    }

    @Override
    public double getSpawnVelocityY() {
        return this.spawnVelocityY;
    }

    @Override
    public double getSpawnVelocityZ() {
        return this.spawnVelocityZ;
    }

    @Override
    public boolean getIsInteractable() {
        return this.optionInteractable;
    }

    @Override
    public boolean usesBossBar() {
        return this.useBossBar;
    }

    @Override
    public int getBossBarRangeSquared() {
        return this.bossBarRangeSq;
    }

    @Override
    public Optional<AbstractBossBar> getBossBar() {
        if (!this.useBossBar) {
            return Optional.empty();
        }
        AbstractBossBar bar = this.getPlugin().getBootstrap().createBossBar(" ", this.bossBarColor, this.bossBarStyle);
        bar.setProgress(1.0);
        if (this.bossBarCreateFog) {
            bar.setCreateFog(true);
        }
        if (this.bossBarDarkenSky) {
            bar.setDarkenSky(true);
        }
        if (this.bossBarPlayMusic) {
            bar.setPlayBossMusic(true);
        }
        return Optional.of(bar);
    }

    @Override
    public PlaceholderString getBossBarTitle() {
        return this.bossBarTitle;
    }

    public boolean equals(Object o) {
        if (o instanceof MobType) {
            return ((MobType)o).getInternalName().equals(this.internalName);
        }
        return false;
    }

    public String toString() {
        return "MythicMob{" + this.internalName + "}";
    }

    @Override
    public int compareTo(MythicMob mm4) {
        return this.internalName.compareTo(mm4.getInternalName());
    }

    @Override
    public boolean getShowHealthInChat() {
        return this.optionShowHealthInChat;
    }

    @Override
    public boolean getShowNameOnDamaged() {
        return this.showNameOnDamage;
    }

    @Override
    public AbstractItemStack getEgg() {
        BukkitItemStack egg = this.eggItem != null ? (BukkitItemStack)this.eggItem : (BukkitItemStack)this.getPlugin().getConfiguration().getDefaultMobEggItem();
        PlaceholderString eggDisplay = this.eggDisplay != null ? this.eggDisplay : this.getPlugin().getConfiguration().getDefaultMobEggDisplay();
        PlaceholderString eggModel = this.eggModel != null ? this.eggModel : this.getPlugin().getConfiguration().getDefaultMobEggModel();
        List<PlaceholderString> eggLore = this.eggLore != null ? this.eggLore : this.getPlugin().getConfiguration().getDefaultMobEggLore();
        egg.enchant(VolatileEnchantment.UNBREAKING, 10).flags(AbstractItemFlag.HIDE_ATTRIBUTES);
        String displayName = eggDisplay.get();
        displayName = this.eggMobName != null ? displayName.replace("<caster.name>", this.eggMobName.get()) : (this.displayName != null ? displayName.replace("<caster.name>", this.displayName.get()) : displayName.replace("<caster.name>", this.entityType.name()));
        egg.customData("MYTHIC_EGG", new StringTag(this.getInternalName()));
        egg.name(Text.parse(displayName));
        ArrayList loreList = Lists.newArrayList();
        for (PlaceholderString line : eggLore) {
            String lore = line.get();
            lore = lore.replace("<caster.name>", displayName);
            loreList.add(Text.parse(lore));
        }
        egg.lore((List)loreList);
        if (eggModel != null) {
            Object model = eggModel.get();
            if (!((String)model).contains(":")) {
                model = "minecraft:" + (String)model;
            }
            egg.itemModel(NamespacedKey.fromString((String)model));
        }
        return egg;
    }

    @Override
    public Icon<MobMenuContext> getIcon() {
        return IconBuilder.create().itemStack(this.cachedMenuItem).hideFlags(true).name(this.internalName).lore(a -> {
            String display = this.displayName == null ? "<red>None" : this.displayName.get();
            return Lists.newArrayList((Object[])new String[]{"<red>", Text.colorizeLegacy("<gold>Type<white>: " + this.entityType.toString()), Text.colorizeLegacy("<gold>Display<white>: " + display), Text.colorizeLegacy("<red> "), Text.colorizeLegacy("<gray>\u22b3 <yellow>Left-Click to get Mob Egg"), Text.colorizeLegacy("<gray>\u22b3 <yellow>Right-Click to Edit")});
        }).click((context, player) -> {
            player.performCommand("mythicmobs egg get " + this.internalName);
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }).rightClick((context, player) -> {
            MobEditorMenuContext ctx = new MobEditorMenuContext(this, (MobMenuContext)context);
            this.getPlugin().getMenuManager().getMobEditorMenu().open((Player)player, ctx);
        }).build();
    }

    private void setupDefaultVariableValues() {
        MythicConfig config = this.getConfig();
        this.defaultVariables = new VariableRegistry();
        for (String node : config.getKeys("Variables")) {
            String innerNode = "Variables." + node;
            String value = config.getString(innerNode);
            this.defaultVariables.put(node, VariableUtils.createVariableFromPrefixedValue(value));
        }
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public MobExecutor getManager() {
        return this.manager;
    }

    @Override
    public Pack getPack() {
        return this.pack;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public MythicConfig getConfig() {
        return this.config;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public ItemStack getCachedMenuItem() {
        return this.cachedMenuItem;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public MythicEntityType getEntityType() {
        return this.entityType;
    }

    public BukkitEntityType getEntityBaseSpawner() {
        return this.entityBaseSpawner;
    }

    @Override
    public PlaceholderString getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(PlaceholderString displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getFaction() {
        return this.faction;
    }

    @Override
    public void setFaction(String faction) {
        this.faction = faction;
    }

    @Override
    public PlaceholderString getEggDisplay() {
        return this.eggDisplay;
    }

    public PlaceholderString getEggModel() {
        return this.eggModel;
    }

    public PlaceholderString getEggMobName() {
        return this.eggMobName;
    }

    public List<PlaceholderString> getEggLore() {
        return this.eggLore;
    }

    public TotemConfig getTotemConfig() {
        return this.totemConfig;
    }

    @Override
    public MobModel getModel() {
        return this.model;
    }

    @Override
    public DropTable getDropTable() {
        return this.dropTable;
    }

    @Override
    public DropTable getEquipmentTable() {
        return this.equipmentTable;
    }

    public double getOptionReviveHealth() {
        return this.optionReviveHealth;
    }

    public void setOptionReviveHealth(double optionReviveHealth) {
        this.optionReviveHealth = optionReviveHealth;
    }

    @Override
    public Boolean getOptionLockPitch() {
        return this.optionLockPitch;
    }

    @Override
    public Map<StatType, PlaceholderDouble> getStats() {
        return this.stats;
    }

    public Map<StatType, Double> getStatLevelModifiers() {
        return this.statLevelModifiers;
    }

    @Override
    public VariableRegistry getDefaultVariables() {
        return this.defaultVariables;
    }

    @Override
    public Map<String, Double> getDamageModifiers() {
        return this.damageModifiers;
    }

    @Override
    public Map<String, Double> getEntityDamageModifiers() {
        return this.entityDamageModifiers;
    }

    @Override
    public String getAiNavigator() {
        return this.aiNavigator;
    }

    @Override
    public boolean isUsingTimers() {
        return this.usingTimers;
    }

    @Override
    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    @Override
    public int getMaxAttackRange() {
        return this.maxAttackRange;
    }

    @Override
    public int getMaxAttackableRange() {
        return this.maxAttackableRange;
    }

    @Override
    public int getMaxThreatDistance() {
        return this.maxThreatDistance;
    }

    @Override
    public boolean isUseCustomNameplate() {
        return this.useCustomNameplate;
    }

    @Override
    public Boolean getRepeatAllSkills() {
        return this.repeatAllSkills;
    }

    @Override
    public Boolean getPreventVanillaDamage() {
        return this.preventVanillaDamage;
    }

    @Override
    public Boolean getPreventOtherDrops() {
        return this.preventOtherDrops;
    }

    @Override
    public Boolean getPreventRandomEquipment() {
        return this.preventRandomEquipment;
    }

    @Override
    public Boolean getPreventLeashing() {
        return this.preventLeashing;
    }

    @Override
    public Boolean getPreventKnockback() {
        return this.preventKnockback;
    }

    @Override
    public Boolean getPreventRename() {
        return this.preventRename;
    }

    @Override
    public Boolean getPreventEndermanTeleport() {
        return this.preventEndermanTeleport;
    }

    @Override
    public Boolean getPreventItemPickup() {
        return this.preventItemPickup;
    }

    @Override
    public Boolean getPreventSilverfishInfection() {
        return this.preventSilverfishInfection;
    }

    @Override
    public Boolean getPreventSunburn() {
        return this.preventSunburn;
    }

    @Override
    public Boolean getPreventExploding() {
        return this.preventExploding;
    }

    @Override
    public Boolean getPreventMobKillDrops() {
        return this.preventMobKillDrops;
    }

    @Override
    public Boolean getPreventTransformation() {
        return this.preventTransformation;
    }

    @Override
    public Boolean getPreventMounts() {
        return this.preventMounts;
    }

    @Override
    public Boolean getPassthroughDamage() {
        return this.passthroughDamage;
    }

    @Override
    public Boolean getApplyInvisibility() {
        return this.applyInvisibility;
    }

    public Boolean getVisibleByDefault() {
        return this.visibleByDefault;
    }

    @Override
    public Boolean getDigOutOfGround() {
        return this.digOutOfGround;
    }

    public Boolean getRandomizeProperties() {
        return this.randomizeProperties;
    }

    @Override
    public Boolean getUsesHealthBar() {
        return this.usesHealthBar;
    }

    @Override
    public float getSpeechBubbleOffset() {
        return this.speechBubbleOffset;
    }

    @Override
    public double getSpawnVelocityXMax() {
        return this.spawnVelocityXMax;
    }

    @Override
    public double getSpawnVelocityYMax() {
        return this.spawnVelocityYMax;
    }

    @Override
    public double getSpawnVelocityZMax() {
        return this.spawnVelocityZMax;
    }

    @Override
    public Boolean getSpawnVelocityXRange() {
        return this.spawnVelocityXRange;
    }

    @Override
    public Boolean getSpawnVelocityYRange() {
        return this.spawnVelocityYRange;
    }

    @Override
    public Boolean getSpawnVelocityZRange() {
        return this.spawnVelocityZRange;
    }

    @Override
    public PlaceholderString getDisguise() {
        return this.disguise;
    }

    @Override
    public DropMethod getDropMethod() {
        return this.dropMethod;
    }

    @Override
    public boolean isDropsPerPlayer() {
        return this.dropsPerPlayer;
    }

    @Override
    public Boolean getDropsDoLootsplosion() {
        return this.dropsDoLootsplosion;
    }

    @Override
    public Boolean getDropsAreClientsideByDefault() {
        return this.dropsAreClientsideByDefault;
    }

    @Override
    public Boolean getDropsShowNameByDefault() {
        return this.dropsShowNameByDefault;
    }

    @Override
    public Boolean getDropsGlowByDefault() {
        return this.dropsGlowByDefault;
    }

    @Override
    public Boolean getDropsHaveBeamByDefault() {
        return this.dropsHaveBeamByDefault;
    }

    @Override
    public Boolean getDropsHaveVFXByDefault() {
        return this.dropsHaveVFXByDefault;
    }

    @Override
    public Material getDropsItemVFXMaterial() {
        return this.dropsItemVFXMaterial;
    }

    @Override
    public int getDropsItemVFXModel() {
        return this.dropsItemVFXModel;
    }

    @Override
    public double getDropsPerPlayerRequiredDamagePercent() {
        return this.dropsPerPlayerRequiredDamagePercent;
    }

    @Override
    public Boolean getDamageLeaderboard() {
        return this.damageLeaderboard;
    }

    @Override
    public Boolean getShowChatLeaderboardOnDeath() {
        return this.showChatLeaderboardOnDeath;
    }

    @Override
    public Boolean getShowHologramLeaderboardOnDeath() {
        return this.showHologramLeaderboardOnDeath;
    }

    @Override
    public Integer getHologramLeaderboardTimeout() {
        return this.hologramLeaderboardTimeout;
    }

    @Override
    public List<String> getFancyDropHologramMessage() {
        return this.fancyDropHologramMessage;
    }

    @Override
    public List<String> getFancyDropChatMessage() {
        return this.fancyDropChatMessage;
    }
}

