/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.totems;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.mobs.totems.TotemPatternBlock;
import io.lumine.mythic.core.skills.SkillCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class TotemConfig {
    private final MobType mobType;
    private final AbstractBlock triggerBlock;
    private final List<TotemPatternBlock> pattern;
    private final List<TotemPatternBlock> replacePattern;
    private final List<TotemPatternBlock> triggerPatternBlocks;
    private final List<SkillCondition> conditions = new ArrayList<SkillCondition>();

    public TotemConfig(MobType mobType, MythicConfig config) {
        this.mobType = mobType;
        String triggerBlockStr = config.getString("Head");
        List<String> listPattern = config.getStringList("Pattern");
        List<String> listReplacePattern = config.getStringList("Replacement");
        List<String> listConditions = config.getStringList("Conditions");
        this.triggerBlock = mobType.getPlugin().getBootstrap().getBlock(triggerBlockStr);
        this.pattern = this.parsePatternBlocks(listPattern);
        this.triggerPatternBlocks = this.pattern.stream().filter(pb -> pb.material().getBlockData().getMaterial() == this.triggerBlock.getBlockData().getMaterial()).collect(Collectors.toList());
        this.replacePattern = config.isSet("Replacement") ? this.parsePatternBlocks(listReplacePattern) : this.generateDefaultReplacePattern();
        for (String line : listConditions) {
            SkillCondition condition = MythicBukkit.inst().getSkillManager().getCondition(line);
            if (condition == null) continue;
            this.conditions.add(condition);
        }
    }

    private List<TotemPatternBlock> parsePatternBlocks(List<String> config) {
        ArrayList<TotemPatternBlock> patternBlocks = new ArrayList<TotemPatternBlock>();
        for (String line : config) {
            String[] parts = line.trim().split("\\s+");
            if (parts.length != 2) {
                MythicLogger.errorMobConfig(this.mobType, this.mobType.getConfig(), "Invalid totem pattern line: " + line);
                continue;
            }
            String[] coords = parts[0].split(",");
            if (coords.length != 3) {
                MythicLogger.errorMobConfig(this.mobType, this.mobType.getConfig(), "Invalid totem coordinates in pattern line: " + line);
                continue;
            }
            try {
                int dx = Integer.parseInt(coords[0]);
                int dy = Integer.parseInt(coords[1]);
                int dz = Integer.parseInt(coords[2]);
                AbstractBlock material = MythicBukkit.inst().getBootstrap().getBlock(parts[1]);
                if (material == null || material instanceof AbstractBlock.InvalidBlock) {
                    MythicLogger.errorMobConfig(this.mobType, this.mobType.getConfig(), "Invalid totem material in pattern line: " + line);
                    continue;
                }
                patternBlocks.add(new TotemPatternBlock(dx, dy, dz, material));
            }
            catch (NumberFormatException e) {
                MythicLogger.errorMobConfig(this.mobType, this.mobType.getConfig(), "Invalid number in totem pattern line: " + line);
            }
        }
        return patternBlocks;
    }

    private List<TotemPatternBlock> generateDefaultReplacePattern() {
        AbstractBlock air = MythicBukkit.inst().getBootstrap().getBlock("air");
        return this.pattern.stream().map(pb -> new TotemPatternBlock(pb.dx(), pb.dy(), pb.dz(), air)).collect(Collectors.toList());
    }

    private MatchResult findMatch(Block triggerBlock) {
        Material triggerMaterial = this.triggerBlock.getBlockData().getMaterial();
        for (TotemPatternBlock patternTriggerBlock : this.triggerPatternBlocks) {
            if (patternTriggerBlock.material().getBlockData().getMaterial() != triggerMaterial) continue;
            for (int rotation = 0; rotation < 4; ++rotation) {
                int yawDegrees = rotation * 90;
                int[] rotatedTriggerCoords = this.rotateCoords(patternTriggerBlock.dx(), patternTriggerBlock.dz(), yawDegrees);
                Location originLocation = triggerBlock.getLocation().clone().subtract((double)rotatedTriggerCoords[0], (double)patternTriggerBlock.dy(), (double)rotatedTriggerCoords[1]);
                boolean match = true;
                for (TotemPatternBlock patternBlock : this.pattern) {
                    int[] rotatedCoords = this.rotateCoords(patternBlock.dx(), patternBlock.dz(), yawDegrees);
                    int x = originLocation.getBlockX() + rotatedCoords[0];
                    int y = originLocation.getBlockY() + patternBlock.dy();
                    int z = originLocation.getBlockZ() + rotatedCoords[1];
                    Block relativeBlock = triggerBlock.getWorld().getBlockAt(x, y, z);
                    AbstractBlock abstractBlock = patternBlock.material();
                    if (abstractBlock instanceof BukkitBlock) {
                        BukkitBlock bukkitBlock = (BukkitBlock)abstractBlock;
                        if (patternBlock.material().getBlockData().getMaterial() == relativeBlock.getBlockData().getMaterial()) continue;
                        match = false;
                        break;
                    }
                    if (patternBlock.material().getBlockData().matches(relativeBlock.getBlockData())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return new MatchResult(originLocation, yawDegrees);
            }
        }
        return null;
    }

    public void replacePattern(Block triggerBlock) {
        if (this.replacePattern == null || this.replacePattern.isEmpty()) {
            return;
        }
        MatchResult match = this.findMatch(triggerBlock);
        if (match == null) {
            return;
        }
        Location origin = match.origin;
        int rotation = match.rotation;
        for (TotemPatternBlock patternBlock : this.replacePattern) {
            int[] rotatedCoords = this.rotateCoords(patternBlock.dx(), patternBlock.dz(), rotation);
            int x = origin.getBlockX() + rotatedCoords[0];
            int y = origin.getBlockY() + patternBlock.dy();
            int z = origin.getBlockZ() + rotatedCoords[1];
            Block relativeBlock = triggerBlock.getWorld().getBlockAt(x, y, z);
            relativeBlock.setBlockData(patternBlock.material().getBlockData());
        }
    }

    public boolean isValidTotemStructure(Block triggerBlock) {
        AbstractLocation aLocation = BukkitAdapter.adapt(triggerBlock.getLocation());
        for (SkillCondition condition : this.conditions) {
            if (condition.evaluateLocation(aLocation)) continue;
            return false;
        }
        return this.findMatch(triggerBlock) != null;
    }

    private int[] rotateCoords(int dx, int dz, int yawDegrees) {
        switch (yawDegrees % 360) {
            case 90: {
                return new int[]{-dz, dx};
            }
            case 180: {
                return new int[]{-dx, -dz};
            }
            case 270: {
                return new int[]{dz, -dx};
            }
        }
        return new int[]{dx, dz};
    }

    public void summonMob(Block triggerBlock) {
        MatchResult match = this.findMatch(triggerBlock);
        if (match == null) {
            return;
        }
        AbstractLocation spawnLocation = BukkitAdapter.adapt(match.origin).center();
        this.mobType.spawn(spawnLocation, 1.0, SpawnReason.TOTEM);
    }

    public MobType getMobType() {
        return this.mobType;
    }

    public AbstractBlock getTriggerBlock() {
        return this.triggerBlock;
    }

    public List<TotemPatternBlock> getPattern() {
        return this.pattern;
    }

    public List<TotemPatternBlock> getReplacePattern() {
        return this.replacePattern;
    }

    public List<TotemPatternBlock> getTriggerPatternBlocks() {
        return this.triggerPatternBlocks;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TotemConfig)) {
            return false;
        }
        TotemConfig other = (TotemConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MobType this$mobType = this.getMobType();
        MobType other$mobType = other.getMobType();
        if (this$mobType == null ? other$mobType != null : !((Object)this$mobType).equals(other$mobType)) {
            return false;
        }
        AbstractBlock this$triggerBlock = this.getTriggerBlock();
        AbstractBlock other$triggerBlock = other.getTriggerBlock();
        if (this$triggerBlock == null ? other$triggerBlock != null : !this$triggerBlock.equals(other$triggerBlock)) {
            return false;
        }
        List<TotemPatternBlock> this$pattern = this.getPattern();
        List<TotemPatternBlock> other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern)) {
            return false;
        }
        List<TotemPatternBlock> this$replacePattern = this.getReplacePattern();
        List<TotemPatternBlock> other$replacePattern = other.getReplacePattern();
        if (this$replacePattern == null ? other$replacePattern != null : !((Object)this$replacePattern).equals(other$replacePattern)) {
            return false;
        }
        List<TotemPatternBlock> this$triggerPatternBlocks = this.getTriggerPatternBlocks();
        List<TotemPatternBlock> other$triggerPatternBlocks = other.getTriggerPatternBlocks();
        if (this$triggerPatternBlocks == null ? other$triggerPatternBlocks != null : !((Object)this$triggerPatternBlocks).equals(other$triggerPatternBlocks)) {
            return false;
        }
        List<SkillCondition> this$conditions = this.getConditions();
        List<SkillCondition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TotemConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MobType $mobType = this.getMobType();
        result = result * 59 + ($mobType == null ? 43 : $mobType.hashCode());
        AbstractBlock $triggerBlock = this.getTriggerBlock();
        result = result * 59 + ($triggerBlock == null ? 43 : $triggerBlock.hashCode());
        List<TotemPatternBlock> $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
        List<TotemPatternBlock> $replacePattern = this.getReplacePattern();
        result = result * 59 + ($replacePattern == null ? 43 : ((Object)$replacePattern).hashCode());
        List<TotemPatternBlock> $triggerPatternBlocks = this.getTriggerPatternBlocks();
        result = result * 59 + ($triggerPatternBlocks == null ? 43 : ((Object)$triggerPatternBlocks).hashCode());
        List<SkillCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    public String toString() {
        return "TotemConfig(mobType=" + String.valueOf(this.getMobType()) + ", triggerBlock=" + String.valueOf(this.getTriggerBlock()) + ", pattern=" + String.valueOf(this.getPattern()) + ", replacePattern=" + String.valueOf(this.getReplacePattern()) + ", triggerPatternBlocks=" + String.valueOf(this.getTriggerPatternBlocks()) + ", conditions=" + String.valueOf(this.getConditions()) + ")";
    }

    private static class MatchResult {
        final Location origin;
        final int rotation;

        MatchResult(Location origin, int rotation) {
            this.origin = origin;
            this.rotation = rotation;
        }
    }
}

