/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.packs;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.packs.PackManager;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.packs.PackImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class PackExecutor
extends ReloadableModule<MythicBukkit>
implements PackManager {
    private Pack basePack;
    private Pack cosmeticsPack;
    private final Map<String, Pack> packs = Maps.newConcurrentMap();

    public PackExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadPacks();
    }

    @Override
    public void unload() {
        this.packs.clear();
    }

    public Pack registerPack(File folder) {
        PackImpl pack = new PackImpl(folder);
        this.packs.put(pack.getKey(), pack);
        return pack;
    }

    private void loadBasePacks() {
        this.basePack = new PackImpl((MythicBukkit)this.getPlugin());
        this.packs.put("", this.basePack);
        File mythicCosmeticsPacks = new File(((MythicBukkit)this.getPlugin()).getDataFolder().getParent(), "MythicCosmetics");
        if (mythicCosmeticsPacks.exists()) {
            this.cosmeticsPack = new PackImpl(mythicCosmeticsPacks, "MythicCosmetics");
            this.packs.put("MythicCosmetics", this.cosmeticsPack);
        }
    }

    public void loadPacks() {
        MythicLogger.log("Loading Packs...");
        this.packs.clear();
        this.loadBasePacks();
        for (File baseFolder : this.getPackFolders()) {
            if (!baseFolder.exists() || !baseFolder.isDirectory()) continue;
            for (File packFolder : baseFolder.listFiles()) {
                if (!packFolder.isDirectory()) continue;
                this.registerPack(packFolder);
            }
        }
    }

    private Collection<File> getPackFolders() {
        ArrayList folders = Lists.newArrayList();
        File packsFolder1 = new File(String.valueOf(((MythicBukkit)this.getPlugin()).getDataFolder()) + System.getProperty("file.separator") + "packs");
        File packsFolder2 = new File(String.valueOf(((MythicBukkit)this.getPlugin()).getDataFolder()) + System.getProperty("file.separator") + "Packs");
        if (!packsFolder1.exists() && !packsFolder2.exists()) {
            packsFolder1.mkdir();
        }
        folders.add(packsFolder1);
        folders.add(packsFolder2);
        File mythicCosmeticsPacks = new File(((MythicBukkit)this.getPlugin()).getDataFolder().getParent(), "MythicCosmetics" + System.getProperty("file.separator") + "packs");
        if (mythicCosmeticsPacks.exists()) {
            folders.add(mythicCosmeticsPacks);
        }
        return folders;
    }

    public Optional<Pack> getPack(String key) {
        if (key == null) {
            return Optional.of(this.basePack);
        }
        return Optional.ofNullable(this.packs.getOrDefault(key, null));
    }

    public Collection<Pack> getPacks() {
        return this.packs.values();
    }

    public Pack getBasePack() {
        return this.basePack;
    }

    public Pack getCosmeticsPack() {
        return this.cosmeticsPack;
    }
}

