/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.packs;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.entity.Player;

public class PackImpl
implements Pack,
PropertyHolder {
    private final File folder;
    private final String key;
    private final boolean allowFolderCreation;
    private String name = null;
    private List<String> description;
    private String author = null;
    private String url = null;
    private String version = null;
    private String icon = null;
    public Integer itemCount = 0;
    private List<String> fullDescription;

    public PackImpl(MythicBukkit plugin) {
        this.folder = plugin.getDataFolder();
        this.key = "Mythic";
        this.allowFolderCreation = true;
        this.name = "<gold>Mythic Base Pack";
        this.description = Lists.newArrayList((Object[])new String[]{"The Mythic Base Pack", "Located in the plugin directory"});
        this.author = "MythicCraft";
        this.version = "1.0.0";
        this.url = "https://www.mythiccraft.io";
        this.icon = "CHEST";
        this.setupDescription();
    }

    public PackImpl(File folder) {
        this.folder = folder;
        this.key = folder.getName();
        this.allowFolderCreation = true;
        File packinfo = new File(folder, "packinfo.yml");
        if (packinfo.exists() && packinfo.isFile() && packinfo.length() > 0L) {
            MythicConfig config = MythicConfig.of(packinfo);
            this.name = config.getString("Name");
            this.description = config.getStringList("Description");
            this.author = config.getString("Author");
            this.url = config.getString("URL");
            this.version = config.getString("Version");
            if (config.isConfigurationSection("Icon")) {
                this.icon = config.getString("Icon.Material");
                config.set("Icon", this.icon);
                config.save();
            }
            this.icon = config.getString("Icon");
        } else if (!packinfo.exists() || packinfo.length() == 0L) {
            try {
                if (!packinfo.exists()) {
                    packinfo.createNewFile();
                }
                MythicConfig config = MythicConfig.of(packinfo);
                config.set("Name", this.key);
                config.set("Description", Collections.emptyList());
                config.set("Author", "Unknown");
                config.set("URL", "Unknown");
                config.set("Version", "1.0.0");
                config.set("Icon", "CHEST");
                config.save();
            }
            catch (Throwable ex) {
                MythicLogger.error("Failed to generate default packinfo.yml for pack {0}", this.key);
                ex.printStackTrace();
            }
        }
        this.setDefaultData();
        this.setupDescription();
    }

    public PackImpl(LuminePlugin plugin, String packName) {
        this(plugin.getDataFolder(), packName);
    }

    public PackImpl(File folder, String packName) {
        this.folder = folder;
        this.key = packName;
        this.allowFolderCreation = false;
        File packinfo = new File(folder, "packinfo.yml");
        if (packinfo.exists() && packinfo.isFile() && packinfo.length() > 0L) {
            MythicConfig config = MythicConfig.of(packinfo);
            this.name = config.getString("Name");
            this.description = config.getStringList("Description");
            this.author = config.getString("Author");
            this.url = config.getString("URL");
            this.version = config.getString("Version");
            if (config.isConfigurationSection("Icon")) {
                this.icon = config.getString("Icon.Material");
                config.set("Icon", this.icon);
                config.save();
            }
            this.icon = config.getString("Icon");
        }
        this.setDefaultData();
        this.setupDescription();
    }

    private void setDefaultData() {
        if (this.name == null) {
            this.name = "<gold>" + this.folder.getName();
        }
        if (this.description == null) {
            this.description = Collections.emptyList();
        }
        if (this.author == null) {
            this.author = "Unknown";
        }
        if (this.url == null) {
            this.url = "";
        }
        if (this.version == null) {
            this.version = "";
        }
        if (this.icon == null) {
            this.icon = "CHEST";
        }
    }

    private void setupDescription() {
        this.fullDescription = Lists.newArrayList();
        if (!this.author.isEmpty()) {
            this.fullDescription.add("<yellow>Author<white>: " + this.author);
        }
        if (!this.url.isEmpty()) {
            this.fullDescription.add("<yellow>URL<white>: " + this.url);
        }
        if (!this.version.isEmpty()) {
            this.fullDescription.add("<yellow>Version<white>: " + this.version);
        }
        if (!this.description.isEmpty()) {
            this.fullDescription.add("<gray> ");
        }
        if (!this.description.isEmpty()) {
            this.fullDescription.addAll(this.description);
        }
        this.fullDescription.add("<gray> ");
        this.fullDescription.add("<gray>Click to Open Menu");
    }

    @Override
    public String getPropertyNode() {
        return "";
    }

    @Override
    public File getPackFolder(String name, boolean create) {
        if (name.contains("\\.")) {
            throw new IllegalArgumentException("Unsupported folder name");
        }
        File file = new File(this.folder, name.toLowerCase());
        if (!file.exists() && !(file = new File(this.folder, name)).exists()) {
            file = new File(this.folder, name.toLowerCase());
            if (this.allowFolderCreation && create) {
                file.mkdir();
            }
        }
        return file;
    }

    @Override
    public Collection<File> getPackFolders(String name, boolean create, boolean readMono) {
        File monoFolder;
        if (name.contains("\\.")) {
            throw new IllegalArgumentException("Unsupported folder name");
        }
        ArrayList files = Lists.newArrayList();
        File folder = new File(this.folder, name.toLowerCase());
        File folderOG = new File(this.folder, name);
        if (folder.exists() && folder.isDirectory()) {
            files.add(folder);
        } else if (this.allowFolderCreation && create && !folderOG.exists() && !folderOG.isDirectory()) {
            folder.mkdir();
        }
        if (!folderOG.equals(folder) && folderOG.exists() && folderOG.isDirectory()) {
            files.add(folderOG);
        }
        if (readMono && (monoFolder = new File(this.folder, "Mono".toLowerCase())).exists() && monoFolder.isDirectory()) {
            files.add(monoFolder);
        }
        return files;
    }

    @Override
    public void addItem() {
        Integer n = this.itemCount;
        this.itemCount = this.itemCount + 1;
    }

    @Override
    public File getPackFile(String name) {
        return new File(this.folder, name);
    }

    @Override
    public File getSchematicDirectory() {
        return this.getPackFolder("Schematics");
    }

    @Override
    public <T> Icon<T> createMenuIcon(BiConsumer<T, Player> clickEvent) {
        AbstractItemStack iconItem = MythicBukkit.inst().getBootstrap().createItem(this.icon);
        return IconBuilder.create().itemStack(BukkitAdapter.adapt(iconItem)).hideFlags(true).name(this.name).lore(this.fullDescription).click(clickEvent).build();
    }

    @Override
    public File getFolder() {
        return this.folder;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean isAllowFolderCreation() {
        return this.allowFolderCreation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getDescription() {
        return this.description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getIcon() {
        return this.icon;
    }

    @Override
    public Integer getItemCount() {
        return this.itemCount;
    }

    public List<String> getFullDescription() {
        return this.fullDescription;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public void setFullDescription(List<String> fullDescription) {
        this.fullDescription = fullDescription;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackImpl)) {
            return false;
        }
        PackImpl other = (PackImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowFolderCreation() != other.isAllowFolderCreation()) {
            return false;
        }
        Integer this$itemCount = this.getItemCount();
        Integer other$itemCount = other.getItemCount();
        if (this$itemCount == null ? other$itemCount != null : !((Object)this$itemCount).equals(other$itemCount)) {
            return false;
        }
        File this$folder = this.getFolder();
        File other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$description = this.getDescription();
        List<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        List<String> this$fullDescription = this.getFullDescription();
        List<String> other$fullDescription = other.getFullDescription();
        return !(this$fullDescription == null ? other$fullDescription != null : !((Object)this$fullDescription).equals(other$fullDescription));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowFolderCreation() ? 79 : 97);
        Integer $itemCount = this.getItemCount();
        result = result * 59 + ($itemCount == null ? 43 : ((Object)$itemCount).hashCode());
        File $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        List<String> $fullDescription = this.getFullDescription();
        result = result * 59 + ($fullDescription == null ? 43 : ((Object)$fullDescription).hashCode());
        return result;
    }

    public String toString() {
        return "PackImpl(folder=" + String.valueOf(this.getFolder()) + ", key=" + this.getKey() + ", allowFolderCreation=" + this.isAllowFolderCreation() + ", name=" + this.getName() + ", description=" + String.valueOf(this.getDescription()) + ", author=" + this.getAuthor() + ", url=" + this.getUrl() + ", version=" + this.getVersion() + ", icon=" + this.getIcon() + ", itemCount=" + this.getItemCount() + ", fullDescription=" + String.valueOf(this.getFullDescription()) + ")";
    }
}

