/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillManager;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.conditions.ConditionAction;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;

public abstract class AbstractSkill
implements SkillHolder {
    protected ThreadSafetyLevel threadSafetyLevel = ThreadSafetyLevel.EITHER;
    private final MythicBukkit plugin;
    private final SkillExecutor manager;
    protected final UUID uuid;
    protected final File file;
    protected Pack pack = null;
    @MythicField(name="cooldown", aliases={"cd"}, description="The cooldown of the mechanic in seconds. Accepts decimals.", defValue="0")
    protected PlaceholderDouble cooldown = null;
    @MythicField(name="power", description="The power multiplier of the mechanic", defValue="1")
    protected float power = 1.0f;
    @MythicField(name="delay", description="Delays the execution of the mechanic by a set number of ticks", defValue="0")
    protected PlaceholderInt delay = PlaceholderInt.of("0");
    @MythicField(name="repeat", description="The amount of repetitions the mechanic will do")
    protected PlaceholderInt repeat = PlaceholderInt.of("0");
    @MythicField(name="repeatInterval", aliases={"repeatI"}, description="The amount of ticks must elapse between repetitions")
    protected PlaceholderInt repeatInterval = PlaceholderInt.of("0");
    @MythicField(name="targetInterval", aliases={"targetI"}, description="The amount of ticks must elapse between target selection")
    protected PlaceholderDouble targetInterval = PlaceholderDouble.of("0");
    @MythicField(name="chance", description="The likelihood of the mechanic executing. 1 = 100%, 0.5 = 50%")
    protected float chance = 1.0f;
    @MythicField(name="splitPower", aliases={"powersplitbetweentargets", "powersplit"}, description="Whether to split the power between targets")
    protected boolean powerSplitBetweenTargets = false;
    protected SkillTrigger trigger = SkillTriggers.COMBAT;
    @MythicField(name="sourceIsOrigin")
    protected boolean sourceIsOrigin = false;
    @MythicField(name="faulty", description="Whether to use the old faulty vector calculation.")
    protected boolean faulty = true;
    protected Optional<SkillTargeter> targeter = Optional.empty();
    @MythicField(name="targetCreative", description="Whether to target creative players")
    protected boolean target_creative = false;
    protected List<SkillCondition> conditions = null;
    protected List<SkillCondition> conditionsTarget = null;
    protected List<SkillCondition> conditionsTrigger = null;

    public AbstractSkill(SkillManager manager, File file) {
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = (SkillExecutor)manager;
        this.file = file;
        this.uuid = UUID.randomUUID();
    }

    public String getFilePath() {
        return this.file == null ? "Unknown" : this.file.getAbsolutePath();
    }

    public void triggerCooldown(SkillMetadata data) {
        if (this.cooldown != null) {
            this.setCooldown(data.getCaster(), this.cooldown.get(data));
        }
    }

    public boolean onCooldown(SkillCaster skillCaster) {
        return this.getCooldown(skillCaster) > 0.0;
    }

    public double getCooldown(SkillCaster skillCaster) {
        return skillCaster.getSkillCooldownRemainingSeconds(this);
    }

    public void setCooldown(SkillCaster skillCaster, double cooldown) {
        skillCaster.setSkillCooldownMillis(this, cooldown * 1000.0);
    }

    protected boolean rollChance() {
        if (this.chance == 1.0f) {
            return true;
        }
        return !(Numbers.randomDouble() > (double)this.chance);
    }

    @Deprecated
    protected boolean checkSkillTrigger(SkillTrigger trigger) {
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", trigger, this.trigger);
        if (this.trigger.equals(trigger)) {
            return true;
        }
        if (trigger.equals(SkillTriggers.SIGNAL)) {
            return true;
        }
        if (SkillTriggers.TIMER.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.API.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SIGNAL.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.LOAD.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD);
        }
        if (SkillTriggers.COMBAT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK);
        }
        if (SkillTriggers.KILL.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.KILL) || trigger.equals(SkillTriggers.KILLPLAYER);
        }
        if (SkillTriggers.DEFAULT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK) || trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD) || trigger.equals(SkillTriggers.DEATH) || trigger.equals(SkillTriggers.TIMER);
        }
        return this.trigger.equals(trigger);
    }

    protected boolean checkSkillTrigger(SkillMetadata meta) {
        SkillTrigger trigger = meta.getCause();
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", trigger, this.trigger);
        if (trigger.equals(SkillTriggers.SIGNAL) || trigger.equals(SkillTriggers.API)) {
            return true;
        }
        if (SkillTriggers.TIMER.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SIGNAL.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SPAWN_OR_LOAD.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD);
        }
        if (SkillTriggers.COMBAT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK);
        }
        if (SkillTriggers.KILL.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.KILL) || trigger.equals(SkillTriggers.KILLPLAYER);
        }
        if (SkillTriggers.DEFAULT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK) || trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD) || trigger.equals(SkillTriggers.DEATH) || trigger.equals(SkillTriggers.TIMER);
        }
        return this.trigger.equals(trigger);
    }

    protected SkillTrigger parseSkillTrigger(String strTrigger) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTrigger {0}", strTrigger);
        String search = strTrigger.contains(":") ? strTrigger.substring(3, strTrigger.indexOf(":")).toUpperCase() : strTrigger.substring(3).toUpperCase();
        return SkillTrigger.get(search);
    }

    protected SkillTargeter parseSkillTargeter(String strTarget) {
        return this.getPlugin().getSkillManager().getTargeter(strTarget);
    }

    protected SkillCondition parseSkillCondition(String strCondition) {
        String search = strCondition.substring(1);
        boolean n = false;
        if (search.startsWith("!")) {
            search = search.substring(1);
            n = true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillCondition {0}", search);
        SkillCondition cond = this.getPlugin().getSkillManager().getCondition(search);
        if (cond != null && n) {
            cond.setAction(ConditionAction.CANCEL);
        }
        return cond;
    }

    public void setTargetsCreativePlayers(boolean b) {
        this.target_creative = b;
    }

    public boolean targetsCreativePlayers() {
        return this.target_creative;
    }

    public SkillMetadata evaluateTargets(SkillMetadata data) {
        if (this.targeter.isPresent()) {
            return this.evaluateTargets(data, this.targeter.get());
        }
        return data;
    }

    protected SkillMetadata evaluateTargets(SkillMetadata data, SkillTargeter targeter) {
        return this.getPlugin().getSkillManager().processTargets(data, targeter, this.targetsCreativePlayers(), this.powerSplitBetweenTargets);
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return this.threadSafetyLevel;
    }

    public void setThreadSafetyLevel(ThreadSafetyLevel threadSafetyLevel) {
        this.threadSafetyLevel = threadSafetyLevel;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public SkillExecutor getManager() {
        return this.manager;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Pack getPack() {
        return this.pack;
    }

    public void setPack(Pack pack) {
        this.pack = pack;
    }

    public PlaceholderDouble getCooldown() {
        return this.cooldown;
    }

    public SkillTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(SkillTrigger trigger) {
        this.trigger = trigger;
    }

    public Optional<SkillTargeter> getTargeter() {
        return this.targeter;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public List<SkillCondition> getConditionsTarget() {
        return this.conditionsTarget;
    }

    public List<SkillCondition> getConditionsTrigger() {
        return this.conditionsTrigger;
    }

    protected static class DelayedSkill
    implements Runnable {
        private SkillMetadata data;
        private Queue<SkillMechanic> skills;
        private boolean cancelled;

        public DelayedSkill(SkillMetadata data, Queue<SkillMechanic> skills) {
            this.data = data;
            this.skills = skills;
            this.cancelled = false;
        }

        public void cancel() {
            this.skills = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                try {
                    if (this.data.getCaster().getEntity().isDead() && !this.data.getCause().equals(SkillTriggers.DEATH) && !this.data.getCause().equals(SkillTriggers.DESPAWNED) && !this.data.getCause().equals(SkillTriggers.EXPLODE)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Mob is dead, cancelling skill (cause = {0})", this.data.getCause());
                        this.cancel();
                        return;
                    }
                    MetaSkill.execute(this.data, this.skills);
                }
                catch (NullPointerException ex) {
                    this.cancel();
                    ex.printStackTrace();
                }
                return;
            }
        }
    }
}

