/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.MythicUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class CommandSkillExecutor
implements Listener {
    private static final Set<MetaSkillCommand> COMMANDS = new HashSet<MetaSkillCommand>();

    public void reloadCommands() {
        CommandSkillExecutor.popCommands();
        CommandSkillExecutor.loadCommands();
        CommandSkillExecutor.pushCommands();
        CommandSkillExecutor.syncCommands();
    }

    static void popCommands() {
        COMMANDS.forEach(c -> Bukkit.getCommandMap().getKnownCommands().remove(c.getName()));
    }

    static void loadCommands() {
        COMMANDS.clear();
        for (Skill skill : MythicBukkit.inst().getSkillManager().getSkills()) {
            String id;
            MythicConfig config;
            if (skill.getConfig() == null || (config = skill.getConfig().getNestedConfig("Command")) == null || (id = config.getString("Id", null)) == null) continue;
            List<String> aliases = config.getStringList("Aliases", List.of());
            MythicConfig completionsConfig = config.isConfigurationSection("Completions") ? config.getNestedConfig("Completions") : null;
            CommandSkillExecutor.makeCommand(id, skill.getInternalName(), completionsConfig);
            aliases.forEach(alias -> CommandSkillExecutor.makeCommand(alias, skill.getInternalName(), completionsConfig));
        }
        MythicLogger.log("Loaded {0} skill commands", COMMANDS.size());
    }

    static void pushCommands() {
        for (MetaSkillCommand c : COMMANDS) {
            Bukkit.getCommandMap().getKnownCommands().put(c.getName(), c);
            Bukkit.getServer().getCommandMap().register(MythicBukkit.inst().getName(), (Command)c);
        }
    }

    static void syncCommands() {
        try {
            Method method = Bukkit.getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static void makeCommand(String name, String skill, MythicConfig completionsConfig) {
        MetaSkillCommand skillCommand = new MetaSkillCommand(name.toLowerCase(), skill);
        if (completionsConfig != null) {
            for (String key : completionsConfig.getKeys()) {
                skillCommand.addCompletion(key, completionsConfig.getStringList(key, List.of()));
            }
        }
        COMMANDS.add(skillCommand);
    }

    static class MetaSkillCommand
    extends Command {
        String skill;
        LinkedList<Pair<String, List<String>>> commandCompletions = new LinkedList();

        protected MetaSkillCommand(String name, String skill) {
            super(name, "", "", List.of());
            this.skill = skill;
        }

        public boolean execute(@NotNull CommandSender commandSender, @NotNull String s2, @NotNull String[] args) {
            if (!(commandSender instanceof Player)) {
                return false;
            }
            Player player = (Player)commandSender;
            LivingEntity target = MythicUtil.getTargetedEntity(player);
            ArrayList<Entity> targets = new ArrayList<Entity>();
            targets.add((Entity)target);
            MythicBukkit.inst().getAPIHelper().castSkill((Entity)player, this.skill, (Entity)player, player.getLocation(), targets, null, 1.0f, meta -> {
                for (int i = 0; i < Math.min(args.length, this.commandCompletions.size()); ++i) {
                    String argId = (String)this.commandCompletions.get(i).getKey();
                    meta.getVariables().putString(argId, args[i]);
                }
                if (args.length > this.commandCompletions.size()) {
                    String remainingArgs = String.join((CharSequence)" ", Arrays.copyOfRange(args, this.commandCompletions.size(), args.length));
                    meta.getVariables().putString("excessArgs", remainingArgs);
                }
            });
            return true;
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
            int index = args.length - 1;
            ArrayList<String> results = new ArrayList<String>();
            if (index < this.commandCompletions.size()) {
                Pair<String, List<String>> pair = this.commandCompletions.get(index);
                Iterator iterator = ((List)pair.getValue()).iterator();
                block12: while (iterator.hasNext()) {
                    String s2;
                    switch (s2 = (String)iterator.next()) {
                        case "worlds": {
                            Bukkit.getWorlds().forEach(w -> results.add(w.getName()));
                            break;
                        }
                        case "players": {
                            Bukkit.getOnlinePlayers().forEach(p -> results.add(p.getName()));
                            break;
                        }
                        case "items": {
                            for (Material m4 : Material.values()) {
                                results.add(m4.name());
                            }
                            continue block12;
                        }
                        case "mythicitems": {
                            results.addAll(MythicBukkit.inst().getItemManager().getItemNames());
                            break;
                        }
                        default: {
                            results.add(s2);
                        }
                    }
                }
                return results;
            }
            return results;
        }

        public void addCompletion(String key, List<String> completions) {
            this.commandCompletions.add((Pair<String, List<String>>)Pair.of((Object)key, completions));
        }
    }
}

