/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.auras;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.auras.AuraAttachment;
import io.lumine.mythic.core.skills.auras.AuraAttachmentType;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public abstract class Aura
extends SkillMechanic {
    @MythicField(name="auraName", aliases={"buffname", "debuffname"}, description="Optional name, required to use associated mechanics & conditions that reference a specific aura")
    protected Optional<PlaceholderString> auraName;
    protected Optional<PlaceholderString> auraGroup = Optional.empty();
    protected Optional<AuraAttachmentType> attachmentType;
    protected AuraAttachment attachment;
    @MythicField(name="charges", aliases={"c"}, description="The amount of charges the aura can hold before decaying to zero and terminating the aura", defValue="0")
    protected PlaceholderInt charges;
    @MythicField(name="interval", aliases={"i"}, description="Sets how often the aura will tick", defValue="1")
    protected PlaceholderInt interval;
    @MythicField(name="duration", aliases={"ticks", "t", "d", "time", "t"}, description="The max duration the aura will persist", defValue="200")
    protected PlaceholderInt duration;
    @MythicField(name="maxStacks", aliases={"ms"}, description="The amount of times the aura can stack on the same target", defValue="1")
    protected PlaceholderInt maxStacks;
    @MythicField(name="mergeAll", aliases={"ma"}, description="Merges all of the same auras applied by any and all entities to another into one aura (Prevents multiple mobs from being able to stack an aura multiple times on the same entity)", defValue="false")
    protected boolean mergeAll;
    @MythicField(name="mergeSameCaster", aliases={"msc", "mc"}, description="Merges all of the same auras applied by one entity to another into one aura (Prevents a mob from being able to stack an aura multiple times on the same entity)", defValue="false")
    protected boolean mergeSameCaster;
    @MythicField(name="overwriteAll", aliases={"overwrite", "ow"}, description="When applied, stops all of the same auras applied on the target and replaces them with the new aura", defValue="false")
    protected boolean overwriteAll;
    @MythicField(name="overwriteSameCaster", aliases={"osc", "oc"}, description="When applied, stops all of the same auras applied on the target by the same caster and replaces them with the new aura", defValue="false")
    protected boolean overwriteCaster;
    @MythicField(name="refreshDuration", aliases={"rd"}, description="Makes the aura's duration refresh to the amount defined in the mechanic should the entity have the same aura applied to it again", defValue="true")
    protected boolean refreshDuration;
    @MythicField(name="showBarTimer", aliases={"bartimer", "bt"}, description="Whether to display a bar timer for the caster while the aura is active", defValue="false")
    protected boolean showBarTimer;
    @MythicField(name="barTimerDisplay", aliases={"barTimerText"}, description="The text to display on the boss bar", defValue="<skill.var.aura-name>")
    protected PlaceholderString barTimerDisplay = null;
    @MythicField(name="barTimerColor", description="The color of the boss bar", defValue="RED")
    protected AbstractBossBar.BarColor barTimerColor = null;
    @MythicField(name="barTimerStyle", description="The style of the boss bar", defValue="SOLID")
    protected AbstractBossBar.BarStyle barTimerStyle = null;
    @MythicField(name="cancelOnGiveDamage", aliases={"cogd"}, description="Terminates the aura when the entity deals damage to another entity", defValue="false")
    protected boolean cancelOnGiveDamage;
    @MythicField(name="cancelOnTakeDamage", aliases={"cotd"}, description="Terminates the aura when the entity takes damage", defValue="false")
    protected boolean cancelOnTakeDamage;
    @MythicField(name="cancelonDeath", aliases={"cod"}, description="Terminates the aura when the entity when the entity dies", defValue="true")
    protected boolean cancelOnDeath;
    @MythicField(name="cancelOnCasterDeath", aliases={"cod"}, description="Terminates the aura when the caster dies", defValue="false")
    protected boolean cancelOnCasterDeath;
    @MythicField(name="cancelOnTeleport", aliases={"cod"}, description="Terminates the aura when the entity when the entity teleports", defValue="false")
    protected boolean cancelOnTeleport;
    @MythicField(name="cancelOnChangeWorld", aliases={"cocw"}, description="Terminates the aura when the entity changes world. Mostly applies to players", defValue="false")
    protected boolean cancelOnChangeWorld;
    @MythicField(name="cancelOnSkillCaster", aliases={"cosc"}, description="Terminates the aura if the entity with the aura uses another skill while the aura is active.", defValue="false")
    protected boolean cancelOnSkillCast;
    @MythicField(name="cancelOnQuit", aliases={"coq"}, description="Terminates the aura when the entity(player) quits the server", defValue="true")
    protected boolean cancelOnQuit;
    @MythicField(name="doEndSkillOnTerminate", aliases={"desot", "alwaysrunendskill", "ares"}, description="Whether to execute the onEnd skill when the aura is terminated", defValue="true")
    protected boolean doEndSkillOnTerminate;
    @MythicField(name="onStartSkill", aliases={"onstart", "os"}, description="The meta-skill to execute when the aura first starts")
    protected Optional<Skill> onStartSkill = Optional.empty();
    @MythicField(name="onTick", aliases={"ontick", "ot"}, description="The meta-skill to execute every time the aura is ticked")
    protected Optional<Skill> onTickSkill = Optional.empty();
    @MythicField(name="onEndSkill", aliases={"onend", "oe"}, description="The meta-skill to execute when the aura is terminated")
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected String onStartSkillName;
    protected String onTickSkillName;
    protected String onEndSkillName;

    public Aura(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.auraName = Optional.ofNullable(mlc.getPlaceholderString(new String[]{"aura", "auraname", "b", "buff", "buffname", "debuff", "debuffname", "n", "name"}, null, new String[0]));
        this.auraGroup = Optional.ofNullable(mlc.getPlaceholderString(new String[]{"auragroup", "auratype", "group", "type", "g"}, null, new String[0]));
        String attachmentType = mlc.getString(new String[]{"attachmenttype", "attachment", "attach"}, "NONE", new String[0]);
        try {
            this.attachmentType = AuraAttachmentType.get(attachmentType);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid aura attachment type specified");
            this.attachmentType = Optional.empty();
        }
        if (this.attachmentType.isPresent()) {
            this.attachment = this.attachmentType.get().create(this, mlc);
        }
        this.charges = mlc.getPlaceholderInteger(new String[]{"charges", "c"}, 0, new String[0]);
        this.interval = mlc.getPlaceholderInteger(new String[]{"interval", "i"}, 1, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"ticks", "t", "duration", "d", "time", "t"}, 200, new String[0]);
        this.maxStacks = mlc.getPlaceholderInteger(new String[]{"maxstacks", "ms"}, 1, new String[0]);
        this.mergeAll = mlc.getBoolean(new String[]{"mergeall", "ma"}, false);
        this.overwriteAll = mlc.getBoolean(new String[]{"overwriteall", "overwrite", "ow"}, false);
        this.overwriteCaster = mlc.getBoolean(new String[]{"overwritesamecaster", "osc", "oc"}, false);
        this.mergeSameCaster = mlc.getBoolean(new String[]{"mergesamecaster", "msc", "mc"}, !this.mergeAll && !this.overwriteAll && !this.overwriteCaster);
        this.refreshDuration = mlc.getBoolean(new String[]{"refreshduration", "rd"}, true);
        this.showBarTimer = mlc.getBoolean(new String[]{"showbartimer", "bartimer", "bt"}, false);
        if (this.showBarTimer) {
            this.barTimerDisplay = mlc.getPlaceholderString(new String[]{"bartimerdisplay", "bartimertext"}, "<skill.var.aura-name>", new String[0]);
            String barTimerColor = mlc.getString("bartimercolor", "RED");
            String barTimerStyle = mlc.getString("bartimerstyle", "SOLID");
            try {
                this.barTimerColor = AbstractBossBar.BarColor.valueOf(barTimerColor);
            }
            catch (Exception ex) {
                this.barTimerColor = AbstractBossBar.BarColor.RED;
            }
            try {
                this.barTimerStyle = AbstractBossBar.BarStyle.valueOf(barTimerStyle);
            }
            catch (Exception ex) {
                this.barTimerStyle = AbstractBossBar.BarStyle.SOLID;
            }
        }
        this.cancelOnGiveDamage = mlc.getBoolean(new String[]{"cancelongivedamage", "cogd"}, false);
        this.cancelOnTakeDamage = mlc.getBoolean(new String[]{"cancelontakedamage", "cotd"}, false);
        this.cancelOnDeath = mlc.getBoolean(new String[]{"cancelondeath", "cod"}, true);
        this.cancelOnCasterDeath = mlc.getBoolean(new String[]{"canceloncasterdeath", "cocd"}, false);
        this.cancelOnTeleport = mlc.getBoolean(new String[]{"cancelonteleport", "cot"}, false);
        this.cancelOnChangeWorld = mlc.getBoolean(new String[]{"cancelonchangeworld", "cocw"}, false);
        this.cancelOnSkillCast = mlc.getBoolean(new String[]{"cancelonskilluse", "cosu"}, false);
        this.cancelOnQuit = mlc.getBoolean(new String[]{"cancelonquit", "coq"}, true);
        this.doEndSkillOnTerminate = mlc.getBoolean(new String[]{"doendskillonterminate", "desot", "alwaysrunendskill", "ares"}, true);
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.getManager().queueSecondPass(() -> {
            if (this.onStartSkillName != null) {
                this.onStartSkill = this.getManager().getSkill(file, this, this.onStartSkillName);
            }
            if (this.onTickSkillName != null) {
                this.onTickSkill = this.getManager().getSkill(file, this, this.onTickSkillName);
            }
            if (this.onEndSkillName != null) {
                this.onEndSkill = this.getManager().getSkill(file, this, this.onEndSkillName);
            }
        });
    }

    public abstract class AuraTracker
    implements Terminable,
    TerminableConsumer,
    Runnable,
    IParentSkill {
        protected final TerminableRegistry components = TerminableRegistry.create();
        private Task task;
        public SkillMetadata skillMetadata;
        protected Optional<AbstractEntity> entity;
        protected Optional<AbstractLocation> location;
        protected AuraAttachment.AttachmentTracker attachment;
        protected transient AbstractBossBar barTimer = null;
        private String name;
        protected int stacks = 1;
        protected int maxStacks;
        protected int chargesRemaining;
        protected int ticksRemaining;
        protected int startDuration;
        protected int startCharges;
        protected int interval;
        protected boolean hasEnded = false;

        public AuraTracker(SkillMetadata data) {
            this.entity = Optional.of(data.getCaster().getEntity());
            this.location = Optional.empty();
            this.skillMetadata = data.deeperClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data);
            this.ticksRemaining = Aura.this.duration.get(data);
            this.maxStacks = Aura.this.maxStacks.get(data);
            this.startDuration = Aura.this.duration.get(data);
            this.startCharges = Aura.this.charges.get(data);
            this.interval = Aura.this.interval.get(data);
        }

        public AuraTracker(SkillCaster caster, AbstractEntity target, SkillMetadata data) {
            this.entity = Optional.of(caster.getEntity());
            this.location = Optional.empty();
            this.skillMetadata = data.deeperClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata.setEntityTarget(target);
            this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data, target);
            this.ticksRemaining = Aura.this.duration.get(data, target);
            this.maxStacks = Aura.this.maxStacks.get(data, target);
            this.startDuration = Aura.this.duration.get(data, target);
            this.startCharges = Aura.this.charges.get(data, target);
            this.interval = Aura.this.interval.get(data, target);
        }

        public AuraTracker(AbstractEntity entity, SkillMetadata data) {
            this.entity = Optional.of(entity);
            this.location = Optional.empty();
            this.skillMetadata = data.deeperClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata = this.skillMetadata.setEntityTarget(entity);
            this.skillMetadata = this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data, entity);
            this.ticksRemaining = Aura.this.duration.get(data, entity);
            this.maxStacks = Aura.this.maxStacks.get(data, entity);
            this.startDuration = Aura.this.duration.get(data, entity);
            this.startCharges = Aura.this.charges.get(data, entity);
            this.interval = Aura.this.interval.get(data, entity);
        }

        public AuraTracker(SkillCaster caster, AbstractLocation target, SkillMetadata data) {
            this.entity = Optional.of(caster.getEntity());
            this.location = Optional.empty();
            this.skillMetadata = data.deeperClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata = this.skillMetadata.setLocationTarget(target);
            this.skillMetadata = this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data);
            this.ticksRemaining = Aura.this.duration.get(data);
            this.maxStacks = Aura.this.maxStacks.get(data);
            this.startDuration = Aura.this.duration.get(data);
            this.startCharges = Aura.this.charges.get(data);
            this.interval = Aura.this.interval.get(data);
        }

        public AuraTracker(AbstractLocation location, SkillMetadata data) {
            this.entity = Optional.empty();
            this.location = Optional.of(location);
            this.skillMetadata = data.deeperClone();
            this.skillMetadata.setCallingEvent(this);
            this.skillMetadata.setLocationTarget(location);
            this.skillMetadata.setIsAsync(true);
            this.skillMetadata.setExecuteAfterDeath(true);
            this.chargesRemaining = Aura.this.charges.get(data);
            this.ticksRemaining = Aura.this.duration.get(data);
            this.maxStacks = Aura.this.maxStacks.get(data);
            this.startDuration = Aura.this.duration.get(data);
            this.startCharges = Aura.this.charges.get(data);
            this.interval = Aura.this.interval.get(data);
        }

        public void registerAuraComponent(Terminable component) {
            this.components.accept(component);
        }

        public UUID getCasterUUID() {
            return this.skillMetadata.getCaster().getEntity().getUniqueId();
        }

        public Optional<String> getGroup() {
            return Aura.this.auraGroup.map(placeholderString -> placeholderString.get(this.skillMetadata));
        }

        public void merge(AuraTracker tracker) {
            this.stacks += tracker.getStacks();
            if (this.stacks > this.maxStacks) {
                this.stacks = this.maxStacks;
            }
            if (Aura.this.refreshDuration) {
                this.chargesRemaining = Aura.this.charges.get(this.skillMetadata);
                this.ticksRemaining = Aura.this.duration.get(this.skillMetadata);
            }
        }

        public boolean executeAuraSkill(Optional<Skill> skill, SkillMetadata data) {
            return this.executeAuraSkill(skill, data, false);
        }

        public boolean executeAuraSkill(Optional<Skill> skill, SkillMetadata data, boolean atCaster) {
            data = data.deepClone();
            if (atCaster) {
                data = data.setEntityTarget(data.getCaster().getEntity());
            } else if (this.entity.isPresent()) {
                data.setEntityTarget(this.entity.get());
            }
            return this.execute(skill, data);
        }

        public boolean executeTargetedAuraSkill(Optional<Skill> skill, SkillMetadata data, AbstractEntity target) {
            data = data.deepClone();
            data.setEntityTarget(target);
            return this.execute(skill, data);
        }

        public boolean executeTargetedAuraSkill(Optional<Skill> skill, SkillMetadata data, AbstractLocation target) {
            if ((data = data.deepClone()).getEntityTargets() != null) {
                data.getEntityTargets().clear();
            }
            if (data.getLocationTargets() != null) {
                data.getLocationTargets().clear();
            }
            data.setLocationTarget(target);
            return this.execute(skill, data);
        }

        protected boolean execute(Optional<Skill> skill, SkillMetadata data) {
            VariableRegistry vars = data.getVariables();
            if (Aura.this.auraName.isPresent()) {
                vars.putString("aura-name", Aura.this.auraName.get().get(this.skillMetadata));
            }
            if (Aura.this.auraGroup.isPresent()) {
                vars.putString("aura-type", Aura.this.auraGroup.get().get(this.skillMetadata));
            }
            vars.putInt("aura-charges", this.chargesRemaining);
            vars.putInt("aura-duration", this.ticksRemaining);
            vars.putInt("aura-duration-millis", this.ticksRemaining * 50);
            vars.putInt("aura-stacks", this.stacks);
            if (this.barTimer != null) {
                double progress = (double)this.ticksRemaining / (double)this.startDuration;
                this.barTimer.setTitle(Aura.this.barTimerDisplay.get((PlaceholderMeta)data, this.entity.get()));
                this.barTimer.setProgress(progress);
            }
            if (skill == null || !skill.isPresent()) {
                return true;
            }
            if (skill.get().isUsable(data)) {
                skill.get().execute(data);
                return true;
            }
            return false;
        }

        public boolean start() {
            String string = this.name = Aura.this.auraName.isPresent() ? Aura.this.auraName.get().get(this.skillMetadata) : Aura.this.getUuid().toString();
            if (this.entity.isPresent()) {
                if (Aura.this.mergeAll || Aura.this.mergeSameCaster) {
                    if (((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).mergeAura(this.name, this, Aura.this.mergeSameCaster)) {
                        return false;
                    }
                } else {
                    if (Aura.this.overwriteAll || Aura.this.overwriteCaster) {
                        ((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).removeAll(this.name);
                    }
                    ((MythicBukkit)Aura.this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).registerAura(this.name, this);
                }
                if (Aura.this.attachment != null) {
                    this.attachment = Aura.this.attachment.create(this, this.entity.get());
                    this.attachment.spawn(this.entity.get());
                }
            }
            this.setupAuraEvents();
            this.auraStart();
            return true;
        }

        public void setupAuraEvents() {
            SkillCaster caster = this.skillMetadata.getCaster();
            if (Aura.this.cancelOnCasterDeath) {
                if (caster.getEntity().isPlayer()) {
                    Events.subscribe(PlayerDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())).handler(event -> this.terminate()).bindWith(this);
                } else if (caster instanceof ActiveMob) {
                    ActiveMob am = (ActiveMob)caster;
                    Events.subscribe(MythicMobDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())).handler(event -> this.terminate()).bindWith(this);
                    Events.subscribe(MythicMobDespawnEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())).handler(event -> this.terminate()).bindWith(this);
                } else {
                    Events.subscribe(EntityDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())).handler(event -> {
                        if (ServerVersion.isPaper() && event.isCancelled()) {
                            return;
                        }
                        this.terminate();
                    }).bindWith(this);
                }
            }
            if (this.entity.isPresent()) {
                AbstractEntity entity = this.entity.get();
                UUID uuid = entity.getUniqueId();
                if (Aura.this.cancelOnGiveDamage) {
                    Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getDamager().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                }
                if (Aura.this.cancelOnTakeDamage) {
                    Events.subscribe(EntityDamageEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                    Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                    Events.subscribe(EntityDamageByBlockEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                }
                if (Aura.this.cancelOnTeleport && entity.isPlayer()) {
                    Events.subscribe(PlayerTeleportEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                    Events.subscribe(PlayerPortalEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                }
                if (Aura.this.cancelOnChangeWorld && entity.isPlayer()) {
                    Events.subscribe(PlayerTeleportEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).filter(event -> event.getTo().getWorld() != event.getFrom().getWorld()).handler(event -> this.terminate()).bindWith(this);
                    Events.subscribe(PlayerPortalEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).filter(event -> event.getTo().getWorld() != event.getFrom().getWorld()).handler(event -> this.terminate()).bindWith(this);
                }
                if (Aura.this.cancelOnQuit && entity.isPlayer()) {
                    Events.subscribe(PlayerQuitEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                }
                if (Aura.this.cancelOnDeath) {
                    Events.subscribe(EntityDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                    Events.subscribe(PlayerDeathEvent.class).filter(event -> event.getEntity().getUniqueId().equals(uuid)).handler(event -> this.terminate()).bindWith(this);
                }
                if (Aura.this.showBarTimer && entity.isPlayer()) {
                    this.barTimer = MythicProvider.get().getBootstrap().createBossBar(" ", Aura.this.barTimerColor, Aura.this.barTimerStyle);
                    this.barTimer.setProgress(1.0);
                    this.barTimer.addPlayer(entity.asPlayer());
                    this.components.accept(this.barTimer);
                }
            }
            if (Aura.this.forceSync || Aura.this.threadSafetyLevel == ThreadSafetyLevel.SYNC_ONLY) {
                this.task = this.entity.isPresent() ? Schedulers.of(this.entity.get().getBukkitEntity()).runRepeating(this, 0L, (long)this.interval) : (this.location.isPresent() ? Schedulers.of(BukkitAdapter.adapt(this.location.get())).runRepeating(this, 0L, (long)this.interval) : Schedulers.of(this.skillMetadata.getCaster().getEntity().getBukkitEntity()).runRepeating(this, 0L, (long)this.interval));
                this.task.bindWith(this);
            } else {
                this.task = Schedulers.async().runRepeating(this, 0L, (long)this.interval);
                this.task.bindWith(this);
            }
        }

        public int getTimesRan() {
            return this.task == null ? 0 : this.task.getTimesRan();
        }

        public boolean isValid() {
            if (this.components.hasTerminated() || this.hasEnded) {
                return false;
            }
            if (this.startCharges > 0 && this.chargesRemaining <= 0) {
                return false;
            }
            if (this.ticksRemaining <= 0) {
                return false;
            }
            return !this.entity.isPresent() || this.entity.get().isValid();
        }

        @Override
        public void run() {
            this.ticksRemaining -= this.interval;
            if (!this.hasEnded && !this.isValid()) {
                this.terminate();
            } else {
                if (this.entity.isPresent()) {
                    this.skillMetadata.setOrigin(this.entity.get().getLocation());
                }
                this.auraTick();
            }
        }

        public void consumeCharge() {
            if (this.startCharges <= 0) {
                return;
            }
            --this.chargesRemaining;
            if (this.chargesRemaining <= 0) {
                this.terminate();
            }
        }

        public void auraStart() {
            this.executeAuraSkill(Aura.this.onStartSkill, this.skillMetadata);
        }

        public void auraTick() {
            this.executeAuraSkill(Aura.this.onTickSkill, this.skillMetadata);
        }

        public void auraStop() {
            this.executeAuraSkill(Aura.this.onEndSkill, this.skillMetadata, false);
        }

        public void terminateFromRegistry() {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker cancelled from Registry for " + this.skillMetadata.getCaster().getEntity().getName() + ": skill = " + Aura.this.line, new Object[0]);
            if (!this.hasEnded) {
                try {
                    if (Aura.this.doEndSkillOnTerminate) {
                        this.auraStop();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.entity.isPresent()) {
                    MythicProvider.get().getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).unregisterAura(this.name, this);
                    if (this.attachment != null) {
                        this.attachment.despawn();
                    }
                }
                if (this.barTimer != null) {
                    this.barTimer = null;
                }
                this.hasEnded = true;
            }
            this.components.terminate();
        }

        @Override
        public void close() {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "++ AuraTracker cancelled for {0}: skill = {1}", this.skillMetadata.getCaster().getName(), Aura.this.line);
            if (!this.hasEnded) {
                try {
                    this.auraStop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.entity.isPresent()) {
                    MythicProvider.get().getSkillManager().getAuraManager().getAuraRegistry(this.entity.get()).unregisterAura(this.name, this);
                    if (this.attachment != null) {
                        this.attachment.despawn();
                    }
                }
                if (this.barTimer != null) {
                    this.barTimer = null;
                }
                this.hasEnded = true;
            }
            this.components.terminate();
        }

        @Override
        public <T extends AutoCloseable> T bind(T terminable) {
            this.components.accept((Terminable)terminable);
            return terminable;
        }

        @Override
        public void setCancelled() {
            this.close();
        }

        @Override
        public boolean getCancelled() {
            return this.hasTerminated();
        }

        public SkillMetadata getSkillMetadata() {
            return this.skillMetadata;
        }

        public String getName() {
            return this.name;
        }

        public int getStacks() {
            return this.stacks;
        }

        public void setStacks(int stacks) {
            this.stacks = stacks;
        }

        public int getMaxStacks() {
            return this.maxStacks;
        }

        public int getChargesRemaining() {
            return this.chargesRemaining;
        }

        public int getTicksRemaining() {
            return this.ticksRemaining;
        }

        public int getStartDuration() {
            return this.startDuration;
        }

        public int getStartCharges() {
            return this.startCharges;
        }

        public int getInterval() {
            return this.interval;
        }

        public boolean isHasEnded() {
            return this.hasEnded;
        }
    }
}

