/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.auras;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.auras.AuraManager;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.auras.AuraRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class AuraExecutor
implements AuraManager {
    private final MythicPlugin core;
    private final SkillExecutor skillManager;
    private ConcurrentHashMap<UUID, AuraRegistry> auraRegistries = new ConcurrentHashMap();
    private Terminable garbageCollector;

    public AuraExecutor(MythicPlugin core, SkillExecutor skillManager) {
        this.core = core;
        this.skillManager = skillManager;
        this.garbageCollector = Schedulers.async().runRepeating(() -> this.auraRegistries.values().forEach(registry -> {}), 20L, 100L);
    }

    public void shutdown() {
        this.garbageCollector.terminate();
    }

    @Override
    public AuraRegistry getAuraRegistry(AbstractEntity entity) {
        return this.getAuraRegistry(entity.getUniqueId());
    }

    @Override
    public AuraRegistry getAuraRegistry(UUID uuid) {
        if (this.auraRegistries.containsKey(uuid)) {
            return this.auraRegistries.get(uuid);
        }
        AuraRegistry registry = new AuraRegistry(uuid);
        this.auraRegistries.put(uuid, registry);
        return registry;
    }

    @Override
    public boolean getHasAura(AbstractEntity entity, String name) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return false;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        return registry.hasAura(name);
    }

    @Override
    public int getAuraStacks(AbstractEntity entity, String name) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return 0;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        return registry.getStacks(name);
    }

    @Override
    public void removeAuraStacks(AbstractEntity entity, String buffName, int a) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        registry.removeStack(buffName, a);
    }

    public void sendAuraDebugInfo(CommandSender sender) {
        int registries = 0;
        int auras = 0;
        int auraTrackers = 0;
        int activeHolders = 0;
        int inactiveHolders = 0;
        HashMap auraTypeCounts = Maps.newHashMap();
        for (AuraRegistry registry : this.auraRegistries.values()) {
            ++registries;
            UUID holderUUID = registry.getHolder();
            Entity holderEntity = Bukkit.getEntity((UUID)holderUUID);
            if (holderEntity == null) {
                ++inactiveHolders;
            } else {
                ++activeHolders;
            }
            for (Map.Entry<String, Queue<Aura.AuraTracker>> entry : registry.getAuras().entrySet()) {
                String auraType = entry.getKey();
                ++auras;
                for (Aura.AuraTracker auraTracker : entry.getValue()) {
                    if (auraType == null || auraType.isEmpty()) {
                        auraType = entry.getValue().getClass().getSimpleName();
                    }
                    ++auraTrackers;
                }
                auraTypeCounts.put(auraType, auraTypeCounts.getOrDefault(auraType, 0) + 1);
            }
        }
        List topAuras = auraTypeCounts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).collect(Collectors.toList());
        CommandHelper.send(sender, "<gold>Aura Registries<gray>: <white>" + registries);
        CommandHelper.send(sender, "<gold>Aura Types<gray>: <white>" + auras);
        CommandHelper.send(sender, "<gold>Aura Trackers<gray>: <white>" + auraTrackers);
        CommandHelper.send(sender, "<gold>Active Holders<gray>: <white>" + activeHolders);
        CommandHelper.send(sender, "<gold>Inactive Holders<gray>: <white>" + inactiveHolders);
        for (Map.Entry aura : topAuras) {
            CommandHelper.send(sender, "<gold>Top Aura: <gray>" + (String)aura.getKey() + "<white>, Count: " + String.valueOf(aura.getValue()));
        }
    }
}

