/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractBlockMatcher;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.List;

@MythicCondition(author="Ashijin", name="blockType", aliases={"inblock", "insideblock"}, description="Tests the material type present at the target location")
public class BlockTypeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="types", aliases={"block", "b", "type", "t", "material", "mat", "m"}, description="A list of materials to check")
    private AbstractBlockMatcher matcher;

    public BlockTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        BlockTypeCondition.getPlugin().getClock().queuePostReload(() -> {
            List<String> list = mlc.getStringList(new String[]{"types", "type", "t", "material", "mat", "m", "block", "b"}, "DIRT", this.conditionVar);
            try {
                this.matcher = BlockTypeCondition.getPlugin().getBootstrap().getBlockMatcher(list);
            }
            catch (Throwable ex) {
                MythicLogger.errorCondition(this, "Failed to initialize BlockMatcher");
                ex.printStackTrace();
            }
        });
    }

    @Override
    public boolean check(AbstractLocation location) {
        if (this.matcher == null) {
            MythicLogger.errorCondition(this, "BlockMatcher failed to initialize");
            return false;
        }
        return this.matcher.matches(location);
    }
}

