/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaComparisonCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.util.HashMap;
import java.util.Map;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicCondition(author="Lxlp", name="CompareValues", aliases={"comparevalue"}, version="5.9.1", description="Compares two values based on a specified operation")
public class CompareValuesCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaComparisonCondition {
    private PlaceholderString value1;
    private PlaceholderString value2;
    private final PlaceholderString operator;
    private VariableType type;
    private static final Map<String, Operator> OPERATOR_MAP = new HashMap<String, Operator>();

    public CompareValuesCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.operator = PlaceholderString.of(mlc.getString(new String[]{"operator", "op"}, "EQUALS", new String[0]));
        String strType = mlc.getString(new String[]{"type", "t"}, null, new String[0]);
        if (strType != null) {
            try {
                this.type = VariableType.valueOf(strType.toUpperCase());
            }
            catch (Exception ex) {
                this.type = null;
            }
        } else {
            this.type = null;
        }
        try {
            this.value1 = PlaceholderString.of(mlc.getString(new String[]{"value1", "val1", "v1"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Value1 attribute must be set.");
            return;
        }
        try {
            this.value2 = PlaceholderString.of(mlc.getString(new String[]{"value2", "val2", "v2"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Value2 attribute must be set.");
            return;
        }
    }

    private double parseMath(String eq) {
        return new ExpressionBuilder(eq).operator(Operators.operators).functions(Functions.functions).build().evaluate();
    }

    private boolean compareLogic(String value1, String value2, String operatorString) {
        if (value1 == null || value2 == null) {
            return false;
        }
        Operator op = Operator.getOperator(operatorString);
        if (this.type != null) {
            try {
                return switch (this.type) {
                    case VariableType.INTEGER -> this.compareValues((long)this.parseMath(value1), (long)this.parseMath(value2), op);
                    case VariableType.FLOAT -> this.compareValues(Float.valueOf((float)this.parseMath(value1)), Float.valueOf((float)this.parseMath(value2)), op);
                    case VariableType.DOUBLE -> this.compareValues(this.parseMath(value1), this.parseMath(value2), op);
                    default -> this.compareValues(value1, value2, op);
                };
            }
            catch (Exception ex) {
                return false;
            }
        }
        try {
            return this.compareValues(this.parseMath(value1), this.parseMath(value2), op);
        }
        catch (Exception exception) {
            return this.compareValues(value1, value2, op);
        }
    }

    private <T extends Comparable<T>> boolean compareValues(T compare1, T compare2, Operator op) {
        int comparison = compare1.compareTo(compare2);
        return switch (op.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (comparison == 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (comparison != 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (comparison > 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (comparison < 0) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (comparison >= 0) {
                    yield true;
                }
                yield false;
            }
            case 5 -> comparison <= 0;
        };
    }

    @Override
    public boolean check(AbstractEntity e) {
        String value1 = this.value1.get(e);
        String value2 = this.value2.get(e);
        String operator = this.operator.get(e);
        return this.compareLogic(value1, value2, operator);
    }

    @Override
    public boolean check(AbstractLocation l) {
        String value1 = this.value1.get();
        String value2 = this.value2.get();
        String operator = this.operator.get();
        return this.compareLogic(value1, value2, operator);
    }

    @Override
    public boolean check(SkillMetadata meta, AbstractEntity target) {
        String value1 = this.value1.get((PlaceholderMeta)meta, target);
        String value2 = this.value2.get((PlaceholderMeta)meta, target);
        String operator = this.operator.get((PlaceholderMeta)meta, target);
        return this.compareLogic(value1, value2, operator);
    }

    private static enum Operator {
        EQUALS("==", "EQUALS", "EQUAL", "EQ", "EQL"),
        NOT_EQUALS("!=", "NOT_EQUALS", "NOTEQUALS", "NOTEQUAL", "NE", "NEQ", "NEQL"),
        GREATER_THAN(">", "GT", "GREATERTHAN", "GTR", "GREATER_THAN"),
        LESS_THAN("<", "LT", "LESSTHAN", "LTR", "LESS_THAN"),
        GREATER_THAN_OR_EQUALS(">=", "GTE", "GREATERTHANOREQUALS", "GTEO", "GREATER_THAN_OR_EQUALS"),
        LESS_THAN_OR_EQUALS("<=", "LTE", "LESSTHANOREQUALS", "LTEO", "LESS_THAN_OR_EQUALS");


        private Operator(String ... aliases) {
            for (String alias : aliases) {
                OPERATOR_MAP.put(alias, this);
            }
        }

        public static Operator getOperator(String op) {
            return OPERATOR_MAP.getOrDefault(op.toUpperCase(), EQUALS);
        }
    }
}

