/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.conditions.ICasterCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Optional;

@MythicCondition(author="Ashijin", name="skillOnCooldown", aliases={}, description="Whether the caster has the specified skill on cooldown.")
public class SkillOnCooldownCondition
extends SkillCondition
implements ICasterCondition,
IEntityCondition {
    @MythicField(name="skill", aliases={"s"}, description="The skill name to test")
    private String skillName;
    private MetaSkill skill;

    public SkillOnCooldownCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.skillName = mlc.getString(new String[]{"skill", "s"}, "", this.conditionVar);
        SkillOnCooldownCondition.getPlugin().getClock().queueSecondPass(() -> {
            Optional<Skill> maybeSkill = SkillOnCooldownCondition.getPlugin().getSkillManager().getSkill(this.skillName);
            if (maybeSkill.isPresent()) {
                this.skill = (MetaSkill)maybeSkill.get();
            }
        });
    }

    @Override
    public boolean check(SkillCaster caster) {
        return this.skill.onCooldown(caster);
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (target.isPlayer()) {
            PlayerData profile = SkillOnCooldownCondition.getPlugin().getPlayerManager().getProfile(target.asPlayer());
            return this.skill.onCooldown(profile);
        }
        ActiveMob am = SkillOnCooldownCondition.getPlugin().getMobManager().getMythicMobInstance(target);
        if (am != null) {
            return this.skill.onCooldown(am);
        }
        return false;
    }
}

