/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.util.EulerAngle;

@MythicMechanic(author="jaylawl", name="animatearmorstand", aliases={"animateas", "animas"}, description="Makes an armor stand assume a pose over a specified time")
public class AnimateArmorStandMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="duration", aliases={"d"}, defValue="1", description="The duration of the animation in ticks.")
    protected int duration;
    @MythicField(name="smart", defValue="true", description="Whether to apply smart angle conversion.")
    boolean smart;
    @MythicField(name="ignoreEmpty", aliases={"ie"}, defValue="true", description="Whether to ignore empty pose values.")
    boolean ignoreEmpty;
    @MythicField(name="useDegrees", aliases={"ud"}, defValue="true", description="Whether to use degrees for pose values.")
    boolean useDegrees;
    @MythicField(name="head", aliases={"h"}, description="The pose for the armor stand's head.")
    PlaceholderString head;
    @MythicField(name="body", aliases={"b"}, description="The pose for the armor stand's body.")
    PlaceholderString body;
    @MythicField(name="leftArm", aliases={"la"}, description="The pose for the armor stand's left arm.")
    PlaceholderString leftArm;
    @MythicField(name="rightArm", aliases={"ra"}, description="The pose for the armor stand's right arm.")
    PlaceholderString rightArm;
    @MythicField(name="leftLeg", aliases={"ll"}, description="The pose for the armor stand's left leg.")
    PlaceholderString leftLeg;
    @MythicField(name="rightLeg", aliases={"rl"}, description="The pose for the armor stand's right leg.")
    PlaceholderString rightLeg;
    private EulerAngle h;
    private EulerAngle b;
    private EulerAngle la;
    private EulerAngle ra;
    private EulerAngle ll;
    private EulerAngle rl;

    public AnimateArmorStandMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        double z;
        double y;
        double x;
        String[] split;
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 1, new String[0]).get();
        this.smart = mlc.getBoolean(new String[]{"smart"}, true);
        this.ignoreEmpty = mlc.getBoolean(new String[]{"ignoreempty", "ie"}, true);
        this.useDegrees = mlc.getBoolean(new String[]{"usedegrees", "ud"}, true);
        this.head = mlc.getPlaceholderString(new String[]{"head", "h"}, null, new String[0]);
        this.body = mlc.getPlaceholderString(new String[]{"body", "b"}, null, new String[0]);
        this.leftArm = mlc.getPlaceholderString(new String[]{"leftarm", "la"}, null, new String[0]);
        this.rightArm = mlc.getPlaceholderString(new String[]{"rightarm", "ra"}, null, new String[0]);
        this.leftLeg = mlc.getPlaceholderString(new String[]{"leftleg", "ll"}, null, new String[0]);
        this.rightLeg = mlc.getPlaceholderString(new String[]{"rightleg", "rl"}, null, new String[0]);
        if (this.head != null) {
            split = this.head.get().split(",");
            x = Double.valueOf(split[0]);
            y = Double.valueOf(split[1]);
            z = Double.valueOf(split[2]);
            if (this.smart) {
                if (x > 180.0) {
                    x -= 360.0;
                }
                if (y > 180.0) {
                    y -= 360.0;
                }
                if (z > 180.0) {
                    z -= 360.0;
                }
            }
            if (this.useDegrees) {
                x = Math.toRadians(x);
                y = Math.toRadians(y);
                z = Math.toRadians(z);
            }
            this.h = new EulerAngle(x, y, z);
        } else if (!this.ignoreEmpty) {
            this.h = EulerAngle.ZERO;
        }
        if (this.body != null) {
            split = this.body.get().split(",");
            x = Double.valueOf(split[0]);
            y = Double.valueOf(split[1]);
            z = Double.valueOf(split[2]);
            if (this.smart) {
                if (x > 180.0) {
                    x -= 360.0;
                }
                if (y > 180.0) {
                    y -= 360.0;
                }
                if (z > 180.0) {
                    z -= 360.0;
                }
            }
            if (this.useDegrees) {
                x = Math.toRadians(x);
                y = Math.toRadians(y);
                z = Math.toRadians(z);
            }
            this.b = new EulerAngle(x, y, z);
        } else if (!this.ignoreEmpty) {
            this.b = EulerAngle.ZERO;
        }
        if (this.leftArm != null) {
            split = this.leftArm.get().split(",");
            x = Double.valueOf(split[0]);
            y = Double.valueOf(split[1]);
            z = Double.valueOf(split[2]);
            if (this.smart) {
                if (x > 180.0) {
                    x -= 360.0;
                }
                if (y > 180.0) {
                    y -= 360.0;
                }
                if (z > 180.0) {
                    z -= 360.0;
                }
            }
            if (this.useDegrees) {
                x = Math.toRadians(x);
                y = Math.toRadians(y);
                z = Math.toRadians(z);
            }
            this.la = new EulerAngle(x, y, z);
        } else if (!this.ignoreEmpty) {
            this.la = EulerAngle.ZERO;
        }
        if (this.rightArm != null) {
            split = this.rightArm.get().split(",");
            x = Double.valueOf(split[0]);
            y = Double.valueOf(split[1]);
            z = Double.valueOf(split[2]);
            if (this.smart) {
                if (x > 180.0) {
                    x -= 360.0;
                }
                if (y > 180.0) {
                    y -= 360.0;
                }
                if (z > 180.0) {
                    z -= 360.0;
                }
            }
            if (this.useDegrees) {
                x = Math.toRadians(x);
                y = Math.toRadians(y);
                z = Math.toRadians(z);
            }
            this.ra = new EulerAngle(x, y, z);
        } else if (!this.ignoreEmpty) {
            this.ra = EulerAngle.ZERO;
        }
        if (this.leftLeg != null) {
            split = this.leftLeg.get().split(",");
            x = Double.valueOf(split[0]);
            y = Double.valueOf(split[1]);
            z = Double.valueOf(split[2]);
            if (this.smart) {
                if (x > 180.0) {
                    x -= 360.0;
                }
                if (y > 180.0) {
                    y -= 360.0;
                }
                if (z > 180.0) {
                    z -= 360.0;
                }
            }
            if (this.useDegrees) {
                x = Math.toRadians(x);
                y = Math.toRadians(y);
                z = Math.toRadians(z);
            }
            this.ll = new EulerAngle(x, y, z);
        } else if (!this.ignoreEmpty) {
            this.ll = EulerAngle.ZERO;
        }
        if (this.rightLeg != null) {
            split = this.rightLeg.get().split(",");
            x = Double.valueOf(split[0]);
            y = Double.valueOf(split[1]);
            z = Double.valueOf(split[2]);
            if (this.smart) {
                if (x > 180.0) {
                    x -= 360.0;
                }
                if (y > 180.0) {
                    y -= 360.0;
                }
                if (z > 180.0) {
                    z -= 360.0;
                }
            }
            if (this.useDegrees) {
                x = Math.toRadians(x);
                y = Math.toRadians(y);
                z = Math.toRadians(z);
            }
            this.rl = new EulerAngle(x, y, z);
        } else if (!this.ignoreEmpty) {
            this.rl = EulerAngle.ZERO;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof ArmorStand)) {
            return SkillResult.INVALID_TARGET;
        }
        ArmorStand as = (ArmorStand)entity;
        double hxD = this.h != null ? (this.h.getX() - as.getHeadPose().getX()) / (double)this.duration : 0.0;
        double hyD = this.h != null ? (this.h.getY() - as.getHeadPose().getY()) / (double)this.duration : 0.0;
        double hzD = this.h != null ? (this.h.getZ() - as.getHeadPose().getZ()) / (double)this.duration : 0.0;
        double bxD = this.b != null ? (this.b.getX() - as.getBodyPose().getX()) / (double)this.duration : 0.0;
        double byD = this.b != null ? (this.b.getY() - as.getBodyPose().getY()) / (double)this.duration : 0.0;
        double bzD = this.b != null ? (this.b.getZ() - as.getBodyPose().getZ()) / (double)this.duration : 0.0;
        double laxD = this.la != null ? (this.la.getX() - as.getLeftArmPose().getX()) / (double)this.duration : 0.0;
        double layD = this.la != null ? (this.la.getY() - as.getLeftArmPose().getY()) / (double)this.duration : 0.0;
        double lazD = this.la != null ? (this.la.getZ() - as.getLeftArmPose().getZ()) / (double)this.duration : 0.0;
        double raxD = this.ra != null ? (this.ra.getX() - as.getRightArmPose().getX()) / (double)this.duration : 0.0;
        double rayD = this.ra != null ? (this.ra.getY() - as.getRightArmPose().getY()) / (double)this.duration : 0.0;
        double razD = this.ra != null ? (this.ra.getZ() - as.getRightArmPose().getZ()) / (double)this.duration : 0.0;
        double llxD = this.ll != null ? (this.ll.getX() - as.getLeftLegPose().getX()) / (double)this.duration : 0.0;
        double llyD = this.ll != null ? (this.ll.getY() - as.getLeftLegPose().getY()) / (double)this.duration : 0.0;
        double llzD = this.ll != null ? (this.ll.getZ() - as.getLeftLegPose().getZ()) / (double)this.duration : 0.0;
        double rlxD = this.rl != null ? (this.rl.getX() - as.getRightLegPose().getX()) / (double)this.duration : 0.0;
        double rlyD = this.rl != null ? (this.rl.getY() - as.getRightLegPose().getY()) / (double)this.duration : 0.0;
        double rlzD = this.rl != null ? (this.rl.getZ() - as.getRightLegPose().getZ()) / (double)this.duration : 0.0;
        for (int i = 0; i < this.duration; ++i) {
            Schedulers.of((Entity)as).runLater(() -> {
                if (this.h != null) {
                    as.setHeadPose(as.getHeadPose().add(hxD, hyD, hzD));
                }
                if (this.b != null) {
                    as.setBodyPose(as.getBodyPose().add(bxD, byD, bzD));
                }
                if (this.la != null) {
                    as.setLeftArmPose(as.getLeftArmPose().add(laxD, layD, lazD));
                }
                if (this.ra != null) {
                    as.setRightArmPose(as.getRightArmPose().add(raxD, rayD, razD));
                }
                if (this.ll != null) {
                    as.setLeftLegPose(as.getLeftLegPose().add(llxD, llyD, llzD));
                }
                if (this.rl != null) {
                    as.setRightLegPose(as.getRightLegPose().add(rlxD, rlyD, rlzD));
                }
            }, i + 1);
        }
        return SkillResult.SUCCESS;
    }
}

