/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

@MythicMechanic(author="Ashijin", version="5.11", name="fear", description="Applies an aura that makes the target run around in fear")
public class FearMechanic
extends Aura
implements ITargetedEntitySkill {
    private final PlaceholderFloat speed;
    private final PlaceholderInt changeDirInterval;
    private final PlaceholderFloat fearDistance;
    private final PlaceholderInt rotationTicks;

    public FearMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.auraGroup = Optional.ofNullable(mlc.getPlaceholderString(new String[]{"auragroup", "auratype", "group", "type", "g"}, "#fear", new String[0]));
        this.speed = mlc.getPlaceholderFloat(new String[]{"speed", "s"}, 0.35f, new String[0]);
        this.changeDirInterval = mlc.getPlaceholderInteger(new String[]{"directionChangeInterval", "dirchange", "dci"}, 20, new String[0]);
        this.fearDistance = mlc.getPlaceholderFloat(new String[]{"feardistance", "fearrange", "fdist", "fd"}, 10.0f, new String[0]);
        this.rotationTicks = mlc.getPlaceholderInteger(new String[]{"rotationticks", "rotateticks", "rt"}, 5, new String[0]);
        this.interval = PlaceholderInt.of("1");
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isLiving()) {
            return SkillResult.INVALID_TARGET;
        }
        new FearMechanicTracker(target, data);
        return SkillResult.SUCCESS;
    }

    protected class FearMechanicTracker
    extends Aura.AuraTracker {
        private AbstractVector currentDirection;
        private int ticksUntilChange;
        private float startYaw;
        private float endYaw;
        private int rotationTicksRemaining;
        private int rotationTicksTotal;

        public FearMechanicTracker(AbstractEntity target, SkillMetadata data) {
            super(target, data);
            this.pickNewDirection();
            this.start();
        }

        @Override
        public void auraStart() {
            this.executeAuraSkill(FearMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            AbstractVector dirVec;
            float spd;
            if (!this.entity.isPresent() || !((AbstractEntity)this.entity.get()).isLiving()) {
                this.terminate();
                return;
            }
            AbstractEntity abstractEntity = (AbstractEntity)this.entity.get();
            if (this.ticksUntilChange-- <= 0 || this.currentDirection == null) {
                this.pickNewDirection();
            }
            if ((spd = FearMechanic.this.speed.get(this.skillMetadata, abstractEntity)) <= 0.0f) {
                return;
            }
            AbstractVector vel = this.currentDirection.clone().multiply(spd);
            vel.setY(abstractEntity.getVelocity().getY());
            abstractEntity.setVelocity(vel);
            if (this.currentDirection != null && (dirVec = this.currentDirection.clone()).lengthSquared() > 0.0) {
                dirVec.setY(0);
                if (dirVec.lengthSquared() > 0.0) {
                    dirVec.normalize();
                    float targetYaw = (float)Math.toDegrees(Math.atan2(-dirVec.getX(), dirVec.getZ()));
                    float pitch = 0.0f;
                    if (abstractEntity.isPlayer()) {
                        this.updatePlayerRotation(abstractEntity, targetYaw, pitch);
                    } else {
                        ((MythicBukkit)FearMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(abstractEntity, pitch, targetYaw);
                    }
                }
            }
        }

        @Override
        public void auraStop() {
            this.executeAuraSkill(FearMechanic.this.onEndSkill, this.skillMetadata);
        }

        private void pickNewDirection() {
            if (!this.entity.isPresent()) {
                return;
            }
            AbstractEntity target = (AbstractEntity)this.entity.get();
            AbstractLocation targetLoc = target.getLocation();
            AbstractVector dir = this.randomHorizontalDirection();
            if (this.skillMetadata != null && this.skillMetadata.getCaster() != null && this.skillMetadata.getCaster().getEntity() != null) {
                double fearRangeSq;
                double distSq;
                AbstractLocation casterLoc = this.skillMetadata.getCaster().getEntity().getLocation();
                AbstractVector away = targetLoc.toVector().subtract(casterLoc.toVector());
                away.setY(0);
                float fearRange = FearMechanic.this.fearDistance.get(this.skillMetadata, target);
                if (fearRange > 0.0f && (distSq = away.lengthSquared()) <= (fearRangeSq = (double)fearRange * (double)fearRange) && distSq > 1.0E-4) {
                    dir = away.normalize();
                    double baseAngle = Math.atan2(dir.getZ(), dir.getX());
                    double wobble = ThreadLocalRandom.current().nextDouble(-0.7853981633974483, 0.7853981633974483);
                    double newAngle = baseAngle + wobble;
                    dir.setX(Math.cos(newAngle));
                    dir.setZ(Math.sin(newAngle));
                    dir.normalize();
                }
            }
            this.currentDirection = dir;
            this.ticksUntilChange = Math.max(1, FearMechanic.this.changeDirInterval.get(this.skillMetadata, (AbstractEntity)this.entity.get()));
            if (this.entity.isPresent() && ((AbstractEntity)this.entity.get()).isPlayer()) {
                float currentYaw = ((AbstractEntity)this.entity.get()).getLocation().getYaw();
                if (dir.lengthSquared() > 0.0) {
                    dir.setY(0);
                    if (dir.lengthSquared() > 0.0) {
                        dir.normalize();
                        float newYaw = (float)Math.toDegrees(Math.atan2(-dir.getX(), dir.getZ()));
                        this.startYaw = this.normalizeYaw(currentYaw);
                        this.endYaw = this.normalizeYaw(newYaw);
                        this.rotationTicksRemaining = this.rotationTicksTotal = Math.max(1, FearMechanic.this.rotationTicks.get(this.skillMetadata, (AbstractEntity)this.entity.get()));
                    }
                }
            }
        }

        private AbstractVector randomHorizontalDirection() {
            double angle = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
            return new AbstractVector(Math.cos(angle), 0.0, Math.sin(angle)).normalize();
        }

        private void updatePlayerRotation(AbstractEntity abstractEntity, float targetYaw, float pitch) {
            if (this.rotationTicksTotal <= 0) {
                ((MythicBukkit)FearMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerRotation(abstractEntity.asPlayer(), targetYaw, pitch, false);
                return;
            }
            if (this.rotationTicksRemaining > 0) {
                float t2 = 1.0f - (float)this.rotationTicksRemaining / (float)this.rotationTicksTotal;
                float lerpedYaw = this.lerpAngle(this.startYaw, this.endYaw, t2);
                ((MythicBukkit)FearMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerRotation(abstractEntity.asPlayer(), lerpedYaw, pitch, false);
                --this.rotationTicksRemaining;
            } else {
                ((MythicBukkit)FearMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerRotation(abstractEntity.asPlayer(), targetYaw, pitch, false);
            }
        }

        private float normalizeYaw(float yaw) {
            if ((yaw %= 360.0f) <= -180.0f) {
                yaw += 360.0f;
            }
            if (yaw > 180.0f) {
                yaw -= 360.0f;
            }
            return yaw;
        }

        private float lerpAngle(float a, float b, float t2) {
            a = this.normalizeYaw(a);
            b = this.normalizeYaw(b);
            float diff = this.normalizeYaw(b - a);
            return this.normalizeYaw(a + diff * t2);
        }
    }
}

