/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitTriggerMetadata;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.events.MythicProjectileHitEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="ondamaged", description="Applies an aura to the target that triggers a skill when they take damage")
public class OnDamagedMechanic
extends Aura
implements ITargetedEntitySkill {
    protected Optional<Skill> onDamagedSkill = Optional.empty();
    protected String onAttackSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.6", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelDamage;
    protected boolean modDamage = false;
    protected boolean deflect = false;
    @MythicField(name="modDamageType", aliases={"dt"}, defValue="0", version="4.6", description="")
    protected PlaceholderString modDamageType;
    @MythicField(name="damageSub", aliases={"s"}, defValue="0", version="4.6", description="")
    protected PlaceholderDouble damageSub;
    @MythicField(name="damageMultiplier", aliases={"m"}, defValue="1", version="4.6", description="")
    protected PlaceholderDouble damageMult;
    @MythicField(name="damageModifiers", aliases={"damagemods", "damageMod"}, defValue="", version="4.6", description="")
    private PlaceholderString damageModifiers;
    protected String deflectConditionsString;
    @MythicField(name="conditions", aliases={"cond", "c"}, defValue="NONE", version="5.1", description="Conditions applied to the caster when triggered")
    protected List<SkillCondition> deflectConditions = null;

    public OnDamagedMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.onAttackSkillName = mlc.getString(new String[]{"ondamagedskill", "ondamaged", "od", "onhitskill", "onhit", "oh"});
        this.modDamageType = mlc.getPlaceholderString(new String[]{"modDamageType", "damagetype"}, null, new String[0]);
        this.cancelDamage = mlc.getBoolean(new String[]{"cancelevent", "ce", "canceldamage"}, false);
        String damageSub = mlc.getString(new String[]{"damagesub", "sub", "s"}, null, new String[0]);
        String damageMult = mlc.getString(new String[]{"damagemultiplier", "multiplier", "m"}, null, new String[0]);
        this.deflect = mlc.getBoolean(new String[]{"deflectProjectiles", "deflect", "reflect"}, false);
        this.damageSub = damageSub == null ? PlaceholderDouble.of("0") : PlaceholderDouble.of(damageSub);
        this.damageMult = damageMult == null ? PlaceholderDouble.of("1") : PlaceholderDouble.of(damageMult);
        this.damageModifiers = mlc.getPlaceholderString(new String[]{"damagemodifiers", "damagemods", "damagemod"}, "", new String[0]);
        if (damageSub != null || damageMult != null || this.damageModifiers.isPresent()) {
            this.modDamage = true;
        }
        this.deflectConditionsString = mlc.getString(new String[]{"deflectconditions", "dconditions"}, null, new String[0]);
        this.getManager().queueSecondPass(() -> {
            if (this.onAttackSkillName != null) {
                this.onDamagedSkill = this.getManager().getSkill(file, this, this.onAttackSkillName);
            }
            if (this.deflectConditionsString != null) {
                this.deflectConditions = this.getManager().getConditions(this.deflectConditionsString);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return SkillResult.SUCCESS;
    }

    protected void calculateDamage(SkillMetadata meta, AbstractEntity entity, EntityDamageEvent event) {
        Optional<Object> maybeData = entity.getMetadata("skill-damage");
        if (maybeData.isPresent()) {
            DamageMetadata damageData = (DamageMetadata)maybeData.get();
            this.modSkillDamage(meta, entity, event, damageData);
        } else {
            this.modVanillaDamage(meta, entity, event);
        }
    }

    private void modVanillaDamage(SkillMetadata meta, AbstractEntity entity, EntityDamageEvent event) {
        double mod;
        double damage = event.getFinalDamage();
        String damageType = event.getCause().toString();
        if (this.damageModifiers.isPresent()) {
            HashMap damageModifiers = Maps.newHashMap();
            for (String dm : this.damageModifiers.get((PlaceholderMeta)meta, entity).split(",")) {
                try {
                    String[] split = dm.split(" ");
                    String type = split[0];
                    damageModifiers.put(type, Double.valueOf(split[1]));
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    MythicLogger.errorMechanicConfig(this, this.getConfig(), "Invalid syntax for DamageModifier");
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, this.getConfig(), "Invalid syntax for DamageModifier");
                    ex.printStackTrace();
                }
            }
            mod = damageModifiers.getOrDefault(damageType.toUpperCase(), 1.0);
        } else {
            mod = 1.0;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura: damageMod {0} has multiplier {1}", damageType, mod);
        event.setDamage((damage - this.damageSub.get(meta, entity)) * this.damageMult.get(meta, entity) * mod);
    }

    private void modSkillDamage(SkillMetadata meta, AbstractEntity entity, EntityDamageEvent event, DamageMetadata data) {
        double mod;
        double baseDamage = data.getAmount();
        String baseDamageType = event.getCause().toString();
        if (this.damageModifiers.isPresent()) {
            HashMap damageModifiers = Maps.newHashMap();
            for (String dm : this.damageModifiers.get((PlaceholderMeta)meta, entity).split(",")) {
                try {
                    DamageMod modifier = new DamageMod(dm);
                    damageModifiers.put(modifier.getType(), modifier.getValue());
                    modifier.applySkill(data);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    MythicLogger.errorMechanicConfig(this, this.getConfig(), "Invalid syntax for DamageModifier");
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, this.getConfig(), "Invalid syntax for DamageModifier");
                    ex.printStackTrace();
                }
            }
            mod = damageModifiers.getOrDefault(baseDamageType.toUpperCase(), 1.0);
        } else {
            mod = 1.0;
        }
        double damageSubtract = this.damageSub.get(meta, entity);
        double damageMultiplier = this.damageMult.get(meta, entity);
        double damageBaseAmount = (baseDamage - damageSubtract) * mod;
        double damageMultiplied = damageBaseAmount * damageMultiplier;
        data.setAmount(damageBaseAmount);
        data.setMultiplier(data.getMultiplier() * damageMultiplier);
        event.setDamage(damageMultiplied);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura: damageMod modified damage to {0} with base {1} multiplier {2} mod {3}", damageMultiplied, damageBaseAmount, damageMultiplier, mod);
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super(entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            if (OnDamagedMechanic.this.deflect) {
                this.registerAuraComponent(Events.subscribe(ProjectileHitEvent.class).filter(event -> !event.isCancelled()).filter(event -> event.getHitEntity() != null).filter(event -> {
                    if (event.getHitEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())) {
                        return true;
                    }
                    Optional<AbstractModelEngineSupport> maybeSupport = ((MythicBukkit)OnDamagedMechanic.this.getPlugin()).getCompatibility().getModelEngine();
                    if (maybeSupport.isPresent()) {
                        AbstractModelEngineSupport megSupport = maybeSupport.get();
                        boolean bool = megSupport.isBoundToSubHitbox(event.getEntity().getUniqueId(), ((AbstractEntity)this.entity.get()).getUniqueId());
                        return bool;
                    }
                    return false;
                }).handler(event -> {
                    SkillMetadata meta = this.skillMetadata.deepClone();
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (projectileHit) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                    if (OnDamagedMechanic.this.conditions != null) {
                        for (SkillCondition condition : OnDamagedMechanic.this.deflectConditions) {
                            if (condition.evaluateCaster(meta)) continue;
                            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                            return;
                        }
                    }
                    event.setCancelled(true);
                    Projectile proj = event.getEntity();
                    Vector velocity = proj.getVelocity();
                    velocity.setX(velocity.getX() * -1.0);
                    velocity.setZ(velocity.getZ() * -1.0);
                    velocity.setY(velocity.getY() * -1.0);
                    Location location = proj.getLocation();
                    location.add(velocity.getX(), velocity.getY(), velocity.getZ());
                    proj.teleport(location);
                    proj.setVelocity(velocity);
                    Schedulers.sync().runLater(() -> proj.setVelocity(velocity), 1L);
                }));
                this.registerAuraComponent(Events.subscribe(MythicProjectileHitEvent.class).filter(event -> event.getEntity() != null).filter(event -> {
                    if (event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())) {
                        return true;
                    }
                    Optional<AbstractModelEngineSupport> maybeSupport = ((MythicBukkit)OnDamagedMechanic.this.getPlugin()).getCompatibility().getModelEngine();
                    if (maybeSupport.isPresent()) {
                        AbstractModelEngineSupport megSupport = maybeSupport.get();
                        boolean bool = megSupport.isBoundToSubHitbox(event.getEntity().getUniqueId(), ((AbstractEntity)this.entity.get()).getUniqueId());
                        return bool;
                    }
                    return false;
                }).handler(event -> {
                    SkillMetadata meta = this.skillMetadata.deepClone();
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (mythicProjectileHit) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                    if (OnDamagedMechanic.this.conditions != null) {
                        for (SkillCondition condition : OnDamagedMechanic.this.deflectConditions) {
                            if (condition.evaluateCaster(meta)) continue;
                            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                            return;
                        }
                    }
                    event.setCancelled(true);
                    Projectile.ProjectileTracker projectile = event.getProjectile();
                    AbstractVector velocity = projectile.getCurrentVelocity();
                    velocity.setX(velocity.getX() * -1.25);
                    velocity.setZ(velocity.getZ() * -1.25);
                    velocity.setY(velocity.getY() * -1.25);
                    projectile.setCurrentVelocity(velocity);
                }));
            }
            this.registerAuraComponent(Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.MONITOR).filter(event -> !event.isCancelled()).filter(event -> event.getDamage() != 0.0).filter(event -> {
                if (event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())) {
                    return true;
                }
                Optional<AbstractModelEngineSupport> maybeSupport = ((MythicBukkit)OnDamagedMechanic.this.getPlugin()).getCompatibility().getModelEngine();
                if (maybeSupport.isPresent()) {
                    AbstractModelEngineSupport megSupport = maybeSupport.get();
                    boolean bool = megSupport.isBoundToSubHitbox(event.getEntity().getUniqueId(), ((AbstractEntity)this.entity.get()).getUniqueId());
                    return bool;
                }
                return false;
            }).handler(event -> {
                AbstractEntity damager;
                SkillMetadata meta = this.skillMetadata.deepClone();
                BukkitTriggerMetadata.apply(meta, (EntityDamageEvent)event);
                if (event.getDamager() instanceof LivingEntity) {
                    damager = BukkitAdapter.adapt(event.getDamager());
                } else {
                    Entity patt0$temp = event.getDamager();
                    if (patt0$temp instanceof Projectile) {
                        Projectile projectile = (Projectile)patt0$temp;
                        ProjectileSource ps = projectile.getShooter();
                        if (ps instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)ps;
                            damager = BukkitAdapter.adapt((Entity)livingEntity);
                        } else {
                            damager = null;
                        }
                    } else {
                        damager = null;
                    }
                }
                if (damager != null) {
                    meta.setTrigger(damager);
                }
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (byEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (this.executeTargetedAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta, BukkitAdapter.adapt(event.getEntity()))) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.registerAuraComponent(Events.subscribe(EntityDamageEvent.class).filter(event -> !event.isCancelled()).filter(event -> event.getDamage() != 0.0).filter(event -> {
                if (event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())) {
                    return true;
                }
                Optional<AbstractModelEngineSupport> maybeSupport = ((MythicBukkit)OnDamagedMechanic.this.getPlugin()).getCompatibility().getModelEngine();
                if (maybeSupport.isPresent()) {
                    AbstractModelEngineSupport megSupport = maybeSupport.get();
                    return megSupport.isBoundToSubHitbox(event.getEntity().getUniqueId(), ((AbstractEntity)this.entity.get()).getUniqueId());
                }
                return false;
            }).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt(event.getEntity()));
                BukkitTriggerMetadata.apply(meta, event);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (nonEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (OnDamagedMechanic.this.conditions != null) {
                    for (SkillCondition condition : OnDamagedMechanic.this.conditions) {
                        if (condition.evaluateCaster(meta)) continue;
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                        return;
                    }
                }
                if (this.executeAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta)) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.registerAuraComponent(Events.subscribe(EntityDamageByBlockEvent.class, EventPriority.HIGH).filter(event -> !event.isCancelled()).filter(event -> event.getDamage() != 0.0).filter(event -> {
                if (event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())) {
                    return true;
                }
                Optional<AbstractModelEngineSupport> maybeSupport = ((MythicBukkit)OnDamagedMechanic.this.getPlugin()).getCompatibility().getModelEngine();
                if (maybeSupport.isPresent()) {
                    AbstractModelEngineSupport megSupport = maybeSupport.get();
                    return megSupport.isBoundToSubHitbox(event.getEntity().getUniqueId(), ((AbstractEntity)this.entity.get()).getUniqueId());
                }
                return false;
            }).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt(event.getEntity()));
                BukkitTriggerMetadata.apply(meta, (EntityDamageEvent)event);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura (nonEntity) listener called for {0}", ((AbstractEntity)this.entity.get()).getUniqueId());
                if (OnDamagedMechanic.this.conditions != null) {
                    for (SkillCondition condition : OnDamagedMechanic.this.conditions) {
                        if (condition.evaluateCaster(meta)) continue;
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Condition {0} failed", condition);
                        return;
                    }
                }
                if (this.executeAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta)) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura cancelling damage", new Object[0]);
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura modifying damage", new Object[0]);
                        OnDamagedMechanic.this.calculateDamage(meta, (AbstractEntity)this.entity.get(), (EntityDamageEvent)event);
                    } else {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "OnDamaged aura executed", new Object[0]);
                    }
                }
            }));
            this.executeAuraSkill(OnDamagedMechanic.this.onStartSkill, this.skillMetadata);
        }
    }

    private static class DamageMod {
        private String type;
        private double value;
        private StatModifierType modifierType = StatModifierType.ADDITIVE_MULTIPLIER;

        public DamageMod(String mod) {
            String[] parts = mod.split(" ");
            if (parts.length < 2) {
                throw new IllegalArgumentException("Invalid format for mod string. Expected format: 'type value [modifierType]'");
            }
            this.type = parts[0];
            try {
                this.value = Double.parseDouble(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Value is not a valid number: " + parts[1]);
            }
            if (parts.length > 2) {
                try {
                    this.modifierType = StatModifierType.valueOf(parts[2].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid modifierType: " + parts[2]);
                }
            }
        }

        public void applySkill(DamageMetadata damageMetadata) {
            switch (this.modifierType) {
                case ADDITIVE: {
                    damageMetadata.getBonusDamage().compute(this.type, (k, v) -> {
                        if (v == null) {
                            return this.value;
                        }
                        if ((v = Double.valueOf(v - this.value)) < 0.0) {
                            return 0.0;
                        }
                        return v;
                    });
                    break;
                }
                case ADDITIVE_MULTIPLIER: {
                    damageMetadata.getBonusDamageModifiers().compute(this.type, (k, v) -> v == null ? this.value : v + this.value);
                    break;
                }
                case COMPOUND_MULTIPLIER: {
                    damageMetadata.getBonusDamageModifiers().compute(this.type, (k, v) -> v == null ? this.value : v * this.value);
                    break;
                }
                case SETTER: {
                    damageMetadata.getBonusDamageModifiers().compute(this.type, (k, v) -> this.value);
                }
            }
        }

        public String getType() {
            return this.type;
        }

        public double getValue() {
            return this.value;
        }

        public StatModifierType getModifierType() {
            return this.modifierType;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public void setModifierType(StatModifierType modifierType) {
            this.modifierType = modifierType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DamageMod)) {
                return false;
            }
            DamageMod other = (DamageMod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getValue(), other.getValue()) != 0) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            StatModifierType this$modifierType = this.getModifierType();
            StatModifierType other$modifierType = other.getModifierType();
            return !(this$modifierType == null ? other$modifierType != null : !((Object)((Object)this$modifierType)).equals((Object)other$modifierType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DamageMod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = Double.doubleToLongBits(this.getValue());
            result = result * 59 + (int)($value >>> 32 ^ $value);
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            StatModifierType $modifierType = this.getModifierType();
            result = result * 59 + ($modifierType == null ? 43 : ((Object)((Object)$modifierType)).hashCode());
            return result;
        }

        public String toString() {
            return "OnDamagedMechanic.DamageMod(type=" + this.getType() + ", value=" + this.getValue() + ", modifierType=" + String.valueOf((Object)this.getModifierType()) + ")";
        }
    }
}

