/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.custom.CustomMenu;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;
import org.bukkit.entity.Player;

@MythicMechanic(name="openCustomMenu", aliases={"openMenu"}, description="Opens a custom menu")
public class OpenCustomMenuMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    private PlaceholderString menu;

    public OpenCustomMenuMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.menu = mlc.getPlaceholderString(new String[]{"menu", "m"}, "default", new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!MythicBukkit.isVolatile() && ((MythicBukkit)this.getPlugin()).getCompatibility().getRpg().isEmpty()) {
            MythicLogger.errorMechanicConfig(this, this.config, "OpenCustomMenu mechanic requires Mythic Premium or MythicRPG");
            return SkillResult.INVALID_CONFIG;
        }
        String menuName = this.menu.get(data);
        Optional<CustomMenu> maybeMenu = ((MythicBukkit)this.getPlugin()).getMenuManager().getMenu(menuName);
        if (maybeMenu.isEmpty()) {
            return SkillResult.INVALID_CONFIG;
        }
        CustomMenu menu = maybeMenu.get();
        Player player = BukkitAdapter.adapt(data.getCaster().getEntity().asPlayer());
        menu.openMenu(player);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!MythicBukkit.isVolatile() && ((MythicBukkit)this.getPlugin()).getCompatibility().getRpg().isEmpty()) {
            MythicLogger.errorMechanicConfig(this, this.config, "OpenCustomMenu mechanic requires Mythic Premium or MythicRPG");
            return SkillResult.INVALID_CONFIG;
        }
        String menuName = this.menu.get(data);
        Optional<CustomMenu> maybeMenu = ((MythicBukkit)this.getPlugin()).getMenuManager().getMenu(menuName);
        if (maybeMenu.isEmpty()) {
            return SkillResult.INVALID_CONFIG;
        }
        CustomMenu menu = maybeMenu.get();
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        menu.openMenu(player);
        return SkillResult.SUCCESS;
    }

    @Override
    public ThreadSafetyLevel getThreadSafetyLevel() {
        return ThreadSafetyLevel.SYNC_ONLY;
    }

    @Override
    public boolean getTargetsSpectators() {
        return true;
    }

    @Override
    public boolean getTargetsCreatives() {
        return true;
    }
}

