/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="rally", aliases={"callforhelp"}, description="Calls for nearby entities to attack the target")
public class RallyMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private double searchRadius;
    private double hRadius;
    private double vRadius;
    private boolean overwriteTarget;
    private String rallyConditionString;
    private List<SkillCondition> rallyConditions = Lists.newArrayList();

    public RallyMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.hRadius = mlc.getDouble(new String[]{"radius", "hradius", "hr", "r"}, 10.0);
        this.vRadius = mlc.getDouble(new String[]{"vradius", "vr"}, this.hRadius);
        this.overwriteTarget = mlc.getBoolean(new String[]{"overwritetarget, ot"}, true);
        this.searchRadius = Numbers.max(this.hRadius, this.vRadius);
        this.rallyConditionString = mlc.getString(new String[]{"rallyconditions", "conditions", "cond", "c"}, null, new String[0]);
        String typeString = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] types = typeString.split(",");
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (this.rallyConditionString != null) {
                this.rallyConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.rallyConditionString);
            }
            ArrayList converted = Lists.newArrayList();
            for (String type : types) {
                Optional<MythicMob> maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(type);
                if (maybeMob.isPresent()) {
                    converted.add("mythicMobType{type=" + type + "} true");
                    continue;
                }
                converted.add("entityType{type=" + type + "} true");
            }
            if (!converted.isEmpty()) {
                if (converted.size() == 1) {
                    this.rallyConditions.add(((MythicBukkit)this.getPlugin()).getSkillManager().getCondition((String)converted.get(0)));
                } else {
                    String convertedLine = "(" + String.join((CharSequence)" || ", converted) + ")";
                    this.rallyConditions.add(((MythicBukkit)this.getPlugin()).getSkillManager().getCondition(convertedLine));
                }
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isLiving()) {
            return SkillResult.INVALID_TARGET;
        }
        Collection<AbstractEntity> entities = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(data.getOrigin(), this.searchRadius, entity -> {
            if (!entity.isLiving()) {
                return false;
            }
            for (SkillCondition condition : this.rallyConditions) {
                if (condition.evaluateToEntity(data.getCaster().getEntity(), (AbstractEntity)entity)) continue;
                return false;
            }
            return true;
        });
        for (AbstractEntity entity2 : entities) {
            ActiveMob am = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity2);
            if (am != null) {
                am.setTarget(target);
                continue;
            }
            entity2.setTarget(target);
        }
        return SkillResult.SUCCESS;
    }
}

