/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="sendTitle", aliases={"title"}, description="Sends a title message to the target player")
public class SendTitleMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString title;
    protected PlaceholderString subtitle;
    protected int timeIn;
    protected int timeSt;
    protected int timeOt;

    public SendTitleMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.target_creative = true;
        this.title = mlc.getPlaceholderString(new String[]{"title", "t"}, "", new String[0]);
        this.subtitle = mlc.getPlaceholderString(new String[]{"subtitle", "st"}, "", new String[0]);
        this.timeIn = mlc.getInteger("fadein", 1);
        this.timeIn = mlc.getInteger("fi", this.timeIn);
        this.timeSt = mlc.getInteger("duration", 1);
        this.timeSt = mlc.getInteger("d", this.timeSt);
        this.timeOt = mlc.getInteger("fadeout", 1);
        this.timeOt = mlc.getInteger("fo", this.timeOt);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        String t2 = this.title.get((PlaceholderMeta)data, target);
        String st = this.subtitle.get((PlaceholderMeta)data, target);
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        target.asPlayer().sendTitle(t2, st, this.timeIn, this.timeSt, this.timeOt);
        return SkillResult.SUCCESS;
    }
}

