/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitAttribute;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="setspeed", description="Sets the speed attribute of the target entity")
public class SetSpeedMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat speed;
    protected Type type;

    public SetSpeedMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strType = mlc.getString(new String[]{"type", "t"}, "WALK", new String[0]).toUpperCase();
        this.speed = mlc.getPlaceholderFloat(new String[]{"speed", "s", "amount", "a", "value", "v", "multiplier", "m"}, 1.0f, new String[0]);
        this.type = strType.contains("FLY") ? Type.FLYING : Type.WALKING;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        float speed;
        if (!target.isLiving()) {
            return SkillResult.INVALID_TARGET;
        }
        SkillCaster caster = ((MythicBukkit)this.getPlugin()).getSkillManager().getCaster(target);
        if (caster instanceof ActiveMob) {
            ActiveMob activeMob = (ActiveMob)caster;
            MythicMob mobType = activeMob.getType();
            double defaultSpeed = mobType.getMovementSpeed(activeMob);
            if (defaultSpeed < 0.0) {
                Optional<Double> maybeDefault;
                LivingEntity livingEntity = (LivingEntity)BukkitAdapter.adapt(target);
                defaultSpeed = this.type == Type.FLYING ? ((maybeDefault = activeMob.getType().getEntityType().getAttributeDefault(BukkitAttribute.getAttribute("FLYING_SPEED"))).isPresent() ? maybeDefault.get() : 0.0) : ((maybeDefault = activeMob.getType().getEntityType().getAttributeDefault(BukkitAttribute.getAttribute("MOVEMENT_SPEED"))).isPresent() ? maybeDefault.get() : 0.0);
            }
            speed = (float)((double)this.speed.get(data, target) * defaultSpeed);
        } else {
            speed = this.speed.get(data, target) * this.type.defaultSpeed;
        }
        if (target.isPlayer()) {
            Player p = (Player)BukkitAdapter.adapt(target);
            if (this.type == Type.FLYING) {
                p.setFlySpeed(speed);
            } else {
                p.setWalkSpeed(speed);
            }
        } else if (target.isLiving()) {
            LivingEntity l = (LivingEntity)BukkitAdapter.adapt(target);
            if (this.type == Type.FLYING) {
                l.getAttribute(BukkitAttribute.getAttribute("FLYING_SPEED")).setBaseValue((double)speed);
            } else {
                l.getAttribute(BukkitAttribute.getAttribute("MOVEMENT_SPEED")).setBaseValue((double)speed);
            }
        }
        return SkillResult.SUCCESS;
    }

    protected static enum Type {
        WALKING(0.1f),
        FLYING(0.2f);

        private final float defaultSpeed;

        private Type(float defaultSpeed) {
            this.defaultSpeed = defaultSpeed;
        }
    }
}

