/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitParticle;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@MythicMechanic(author="Ashijin", name="summonAreaEffectCloud", aliases={"summonCloud"}, description="Summons an Area Effect Cloud")
public class SummonAreaEffectCloudMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String strParticle;
    protected BukkitParticle particle;
    protected Function<PlaceholderMeta, Object> particleData = null;
    protected PlaceholderString potionEffect;
    protected PlaceholderInt potionDuration;
    protected PlaceholderInt potionLevel;
    protected PlaceholderInt duration;
    protected PlaceholderInt durationReductionOnUse;
    protected PlaceholderInt radius;
    protected PlaceholderFloat radiusReductionOnUse;
    protected PlaceholderFloat radiusReductionOnTick;

    public SummonAreaEffectCloudMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strParticle = mlc.getString(new String[]{"particle", "p"}, "reddust", new String[0]);
        this.particle = BukkitParticle.get(this.strParticle);
        if (this.particle.requiresData()) {
            this.particleData = this.particle.parseDataOptions(mlc);
        }
        this.potionEffect = mlc.getPlaceholderString(new String[]{"type", "effect", "t"}, "SLOW", new String[0]);
        this.potionDuration = mlc.getPlaceholderInteger(new String[]{"potionduration", "pd"}, 100, new String[0]);
        this.potionLevel = mlc.getPlaceholderInteger(new String[]{"level", "lvl", "l"}, 1, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d", "cloudduration"}, 200, new String[0]);
        this.durationReductionOnUse = mlc.getPlaceholderInteger(new String[]{"durationreudctiononuse", "drou"}, 0, new String[0]);
        this.radius = mlc.getPlaceholderInteger(new String[]{"radius", "r"}, 2, new String[0]);
        this.radiusReductionOnUse = mlc.getPlaceholderFloat(new String[]{"radiusreductiononuse", "rrou"}, 0.0f, new String[0]);
        this.radiusReductionOnTick = mlc.getPlaceholderFloat(new String[]{"radiusreductionontick", "rrot"}, 0.0f, new String[0]);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        PotionEffect effect;
        Location location = BukkitAdapter.adapt(target);
        AreaEffectCloud cloud = (AreaEffectCloud)location.getWorld().spawnEntity(location, EntityType.AREA_EFFECT_CLOUD);
        if (this.particleData != null) {
            cloud.setParticle(this.particle.toBukkitParticle(), this.particleData.apply(data));
        } else {
            cloud.setParticle(this.particle.toBukkitParticle());
        }
        String potion = this.potionEffect.get(data);
        int pduration = this.potionDuration.get(data);
        int lvl = this.potionLevel.get(data);
        PotionEffectType type = PotionEffectType.getByName((String)potion);
        try {
            effect = new PotionEffect(type, pduration, lvl);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'type' attribute must be a valid potion type.");
            return SkillResult.INVALID_CONFIG;
        }
        cloud.addCustomEffect(effect, true);
        cloud.setDuration(this.duration.get(data));
        cloud.setDurationOnUse(this.durationReductionOnUse.get(data));
        cloud.setRadius((float)this.radius.get(data));
        cloud.setRadiusOnUse(this.radiusReductionOnUse.get(data));
        cloud.setRadiusPerTick(this.radiusReductionOnTick.get(data));
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.castAtLocation(data, target.getLocation());
        return SkillResult.SUCCESS;
    }
}

