/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ThreatMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="taunt", description="Modifies your threat level with the target entity")
public class TauntMechanic
extends ThreatMechanic {
    public TauntMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.mode = mlc.getPlaceholderString(new String[]{"mode", "m"}, "taunt", new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        String casterFaction;
        ActiveMob targetMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(target);
        if (targetMob == null) {
            return SkillResult.INVALID_TARGET;
        }
        if (target.isDead() || target.getHealth() <= 0.0) {
            return SkillResult.INVALID_TARGET;
        }
        if (targetMob.getThreatTable() == null) {
            return SkillResult.INVALID_CONFIG;
        }
        SkillCaster caster = data.getCaster();
        AbstractEntity casterEntity = caster.getEntity();
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            casterFaction = am.getFaction();
        } else {
            casterFaction = casterEntity.isPlayer() ? (String)((MythicBukkit)this.getPlugin()).getPlayerManager().getFactionProvider().getFaction(casterEntity.asPlayer()).orElse(null) : null;
        }
        if (casterFaction != null && casterFaction.equals(targetMob.getFaction())) {
            return SkillResult.INVALID_TARGET;
        }
        String mode = this.mode.get((PlaceholderMeta)data, target);
        double amount = this.amount.get(data, target);
        return this.modifyThreat(targetMob.getThreatTable(), casterEntity, mode, amount);
    }
}

