/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="directionalvelocity", aliases={"dvelocity"}, description="Sets the velocity on the target entity")
public class VelocityDirectionalMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat velocityYaw;
    protected PlaceholderFloat velocityPitch;
    protected PlaceholderFloat magnitude;
    protected VelocityMode mode;

    public VelocityDirectionalMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.velocityYaw = mlc.getPlaceholderFloat(new String[]{"yaw"}, null, new String[0]);
        this.velocityPitch = mlc.getPlaceholderFloat(new String[]{"pitch"}, null, new String[0]);
        this.magnitude = mlc.getPlaceholderFloat(new String[]{"velocity", "v"}, null, new String[0]);
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]);
        try {
            this.mode = VelocityMode.valueOf(strMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.mode = VelocityMode.SET;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        double velocityX = 0.0;
        double velocityY = 0.0;
        double velocityZ = 0.0;
        if (this.velocityYaw != null) {
            float velocityYaw = this.velocityYaw.get(data, target);
            double yawRad = Math.toRadians(velocityYaw);
            velocityX = -Math.sin(yawRad);
            velocityZ = Math.cos(yawRad);
        }
        if (this.velocityPitch != null) {
            float velocityPitch = this.velocityPitch.get(data, target);
            double pitchRad = Math.toRadians(velocityPitch);
            velocityY = -Math.sin(pitchRad);
            double horizontalFactor = Math.cos(pitchRad);
            velocityX *= horizontalFactor;
            velocityZ *= horizontalFactor;
        }
        double velocityMagnitude = this.magnitude != null ? (double)this.magnitude.get(data, target) : 1.0;
        AbstractVector velocityChange = new AbstractVector(velocityX, velocityY, velocityZ).normalize().multiply(velocityMagnitude);
        AbstractVector currentVelocity = target.getVelocity();
        switch (this.mode.ordinal()) {
            case 0: {
                currentVelocity = velocityChange;
                break;
            }
            case 1: {
                currentVelocity.add(velocityChange);
                break;
            }
            case 2: {
                currentVelocity.multiply(velocityChange);
                break;
            }
            case 3: {
                currentVelocity.subtract(velocityChange);
                break;
            }
            case 4: {
                currentVelocity.divide(velocityChange);
                break;
            }
            case 5: {
                currentVelocity.setX(velocityChange.getX());
                if (this.velocityPitch != null) {
                    currentVelocity.setY(Math.max(currentVelocity.getY(), velocityChange.getY()));
                }
                currentVelocity.setZ(velocityChange.getZ());
                break;
            }
            default: {
                return SkillResult.INVALID_CONFIG;
            }
        }
        if (Double.isNaN(currentVelocity.getX())) {
            currentVelocity.setX(0);
        }
        if (Double.isNaN(currentVelocity.getY())) {
            currentVelocity.setY(0);
        }
        if (Double.isNaN(currentVelocity.getZ())) {
            currentVelocity.setZ(0);
        }
        target.setVelocity(currentVelocity);
        return SkillResult.SUCCESS;
    }

    static enum VelocityMode {
        SET,
        ADD,
        MULTIPLY,
        REMOVE,
        DIVIDE,
        MINIMUM;

    }
}

