/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ShootMechanic;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;

@MythicMechanic(author="Ashijin", name="volley", aliases={"shootvolley"}, description="Fires a volley of projectiles")
public class VolleyMechanic
extends ShootMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="type", aliases={"source", "s"}, description="The type of volley (regular, rain)")
    protected VolleyType type;
    @MythicField(name="amount", aliases={"a"}, description="The number of projectiles to shoot")
    protected PlaceholderInt amount;
    @MythicField(name="radius", aliases={"r"}, description="The radius of the volley spread")
    protected double radius;
    @MythicField(name="yOffset", aliases={"y"}, description="The vertical offset of the volley")
    protected double yOffset;
    @MythicField(name="pickup", aliases={"canPickup"}, description="If the arrows can be picked up", defValue="true")
    protected boolean canPickup;

    public VolleyMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strType = mlc.getString(new String[]{"source", "s"}, "REGULAR", new String[0]).toUpperCase();
        this.type = strType.equals("RAIN") ? VolleyType.RAIN : VolleyType.REGULAR;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 10, new String[0]);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 0.0);
        this.yOffset = mlc.getDouble("yoffset", 1.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
        this.canPickup = mlc.getBoolean(new String[]{"pickup", "canPickup"}, true);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.shoot(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.shoot(data, target);
    }

    @Override
    public SkillResult shoot(SkillMetadata data, AbstractLocation target) {
        float startSideOffset;
        float startForwardOffset;
        float startYOffset;
        SkillCaster caster = data.getCaster();
        AbstractLocation origin = data.getOrigin().clone();
        AbstractLocation primeSource = null;
        if (this.type.equals((Object)VolleyType.RAIN)) {
            primeSource = target.clone().add(0.0, this.yOffset, 0.0);
        }
        if ((startYOffset = this.startYOffset.get(data)) > 0.0f) {
            origin = origin.add(0.0, startYOffset, 0.0);
        }
        if ((startForwardOffset = this.startForwardOffset.get(data)) != 0.0f) {
            origin = MythicUtil.move(this.faulty, origin, startForwardOffset, 0.0, 0.0);
        }
        if ((startSideOffset = this.startSideOffset.get(data)) != 0.0f) {
            origin = MythicUtil.move(this.faulty, origin, 0.0, 0.0, startSideOffset);
        }
        float velocity = (float)this.projectileVelocity.get(data);
        if (this.powerAffectsVelocity) {
            velocity *= this.power;
        }
        AbstractVector vector = this.fromOrigin == true ? target.toVector().subtract(origin.toVector()).normalize().multiply(velocity) : target.toVector().subtract(caster.getEntity().getLocation().toVector()).normalize().multiply(velocity);
        int amount = this.amount.get(data);
        for (int i = 0; i < amount; ++i) {
            AbstractEntity projectile;
            if (this.type.equals((Object)VolleyType.RAIN)) {
                AbstractLocation source = primeSource.clone();
                source.setX(source.getX() - this.radius + Numbers.randomDouble() * (this.radius * 2.0));
                source.setZ(source.getZ() - this.radius + Numbers.randomDouble() * (this.radius * 2.0));
                projectile = this.projectileType.equals((Object)ShootMechanic.ProjectileType.ITEM) ? SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity) : (this.projectileType.equals((Object)ShootMechanic.ProjectileType.BLOCK) ? SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity) : SkillAdapter.get().rainProjectile(caster, source, this.projectileClass, velocity));
            } else {
                projectile = this.projectileType.equals((Object)ShootMechanic.ProjectileType.ITEM) ? SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, vector, this) : (this.projectileType.equals((Object)ShootMechanic.ProjectileType.BLOCK) ? SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, vector, this) : SkillAdapter.get().shootProjectile(caster, target, data.getOrigin(), this.projectileClass, vector, this));
            }
            Entity entity = projectile.getBukkitEntity();
            if (entity instanceof Arrow) {
                Arrow arrow = (Arrow)entity;
                arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            }
            new ShootMechanic.ProjectileTracker(data, projectile, this.power);
        }
        return SkillResult.SUCCESS;
    }

    protected static enum VolleyType {
        REGULAR,
        RAIN;

    }
}

