/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GenericPlaceholderMeta
implements PlaceholderMeta {
    private final SkillCaster caster;
    private final AbstractEntity trigger;
    private Map<String, Object> metadata = Maps.newHashMap();

    public GenericPlaceholderMeta(SkillCaster caster) {
        this.caster = caster;
        this.trigger = null;
    }

    public GenericPlaceholderMeta(AbstractEntity caster) {
        this.caster = new GenericCaster(caster);
        this.trigger = null;
    }

    public GenericPlaceholderMeta(SkillCaster caster, AbstractEntity trigger) {
        this.caster = caster;
        this.trigger = trigger;
    }

    public GenericPlaceholderMeta(AbstractEntity caster, AbstractEntity trigger) {
        this.caster = new GenericCaster(caster);
        this.trigger = trigger;
    }

    @Override
    public PlaceholderMeta setMetadata(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        return Optional.ofNullable(this.metadata.get(key));
    }

    @Override
    public <T> Optional<T> getMetadata(Class<T> clazz, String key) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(key, "key");
        Object value = this.metadata.getOrDefault(key, null);
        if (value == null) {
            return Optional.empty();
        }
        if (!clazz.isInstance(value)) {
            return Optional.empty();
        }
        return Optional.of(clazz.cast(value));
    }

    @Override
    public Optional<Object> removeMetadata(String key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(this.metadata.remove(key));
    }

    @Override
    public <T> Optional<T> removeMetadata(Class<T> clazz, String key) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(key, "key");
        Object value = this.metadata.remove(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!clazz.isInstance(value)) {
            return Optional.empty();
        }
        return Optional.of(clazz.cast(value));
    }

    @Override
    public void clearMetadata() {
        this.metadata.clear();
    }

    @Override
    public SkillCaster getCaster() {
        return this.caster;
    }

    @Override
    public AbstractEntity getTrigger() {
        return this.trigger;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericPlaceholderMeta)) {
            return false;
        }
        GenericPlaceholderMeta other = (GenericPlaceholderMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SkillCaster this$caster = this.getCaster();
        SkillCaster other$caster = other.getCaster();
        if (this$caster == null ? other$caster != null : !this$caster.equals(other$caster)) {
            return false;
        }
        AbstractEntity this$trigger = this.getTrigger();
        AbstractEntity other$trigger = other.getTrigger();
        if (this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericPlaceholderMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SkillCaster $caster = this.getCaster();
        result = result * 59 + ($caster == null ? 43 : $caster.hashCode());
        AbstractEntity $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "GenericPlaceholderMeta(caster=" + String.valueOf(this.getCaster()) + ", trigger=" + String.valueOf(this.getTrigger()) + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
    }
}

