/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;

public record PlaceholderContext(PlaceholderMeta meta, AbstractEntity entity, AbstractLocation location, SkillCaster caster, MythicSpawner spawner) {
    public static PlaceholderContext of(PlaceholderMeta meta, AbstractEntity entity, AbstractLocation location, SkillCaster caster, MythicSpawner spawner) {
        return new PlaceholderContext(meta, entity, location, caster, spawner);
    }

    public static PlaceholderContext of(PlaceholderMeta meta, AbstractEntity entity, AbstractLocation location) {
        return new PlaceholderContext(meta, entity, location, null, null);
    }

    public static PlaceholderContext of() {
        return new PlaceholderContext(null, null, null, null, null);
    }

    public static PlaceholderContext ofMeta(PlaceholderMeta meta) {
        return new PlaceholderContext(meta, null, null, null, null);
    }

    public static PlaceholderContext ofEntity(AbstractEntity entity) {
        return new PlaceholderContext(null, entity, null, null, null);
    }

    public static PlaceholderContext ofLocation(AbstractLocation location) {
        return new PlaceholderContext(null, null, location, null, null);
    }

    public static PlaceholderContext ofCaster(SkillCaster caster) {
        return new PlaceholderContext(null, null, null, caster, null);
    }

    public static PlaceholderContext ofSpawner(MythicSpawner spawner) {
        return new PlaceholderContext(null, null, null, null, spawner);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PlaceholderMeta meta;
        private SkillMetadata skillMeta;
        private AbstractEntity entity;
        private AbstractLocation location;
        private SkillCaster caster;
        private MythicSpawner spawner;

        public Builder meta(PlaceholderMeta meta) {
            this.meta = meta;
            return this;
        }

        public Builder entity(AbstractEntity entity) {
            this.entity = entity;
            return this;
        }

        public Builder location(AbstractLocation location) {
            this.location = location;
            return this;
        }

        public Builder caster(SkillCaster caster) {
            this.caster = caster;
            return this;
        }

        public Builder spawner(MythicSpawner spawner) {
            this.spawner = spawner;
            return this;
        }

        public PlaceholderContext build() {
            return new PlaceholderContext(this.meta, this.entity, this.location, this.caster, this.spawner);
        }
    }
}

