/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.all.MetaTargetPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.EntityPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.GeneralPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.ItemPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.LocationPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.SpawnerPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.TargetPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.WorldPlaceholder;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class PlaceholderParser {
    protected String strValue;
    protected String strUnparsedValue;
    protected boolean papi;
    protected Map<String, PlaceholderExecutor.PlaceholderEntry> variables;
    protected boolean doMath = false;

    public PlaceholderParser() {
    }

    public PlaceholderParser(String string) {
        if (string == null) {
            this.strValue = null;
            this.strUnparsedValue = null;
            this.variables = null;
            this.papi = false;
            return;
        }
        try {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            } else if (string.startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        catch (Exception ex) {
            MythicLogger.error("Message '" + string + "' is incorrectly configured.");
            string = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
        }
        this.strUnparsedValue = SkillString.convertLegacyVariables(string);
        this.strValue = SkillString.parseMessageSpecialChars(this.strUnparsedValue);
        if (this.strValue.startsWith("eval ")) {
            this.doMath = true;
            string = string.substring(5);
        } else if (this.strValue.contains("+") || this.strValue.contains("-") || this.strValue.contains("*") || this.strValue.contains("/") || this.strValue.contains("^")) {
            this.doMath = true;
        }
        this.papi = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().isPresent() && this.strUnparsedValue.contains("%");
        this.getPlaceholderManager().registerParser(this);
        this.checkForVariables();
    }

    public void checkForVariables() {
        List<String> placeholders = PlaceholderExecutor.parsePlaceholders(this.strValue);
        if (!placeholders.isEmpty()) {
            this.variables = new HashMap<String, PlaceholderExecutor.PlaceholderEntry>();
            for (String found : placeholders) {
                PlaceholderExecutor.PlaceholderEntry transformer = this.getPlaceholderManager().getPlaceholder(found);
                if (transformer == null) continue;
                this.variables.put(found, transformer);
            }
        } else {
            this.variables = null;
        }
    }

    protected String parse() {
        if (this.variables == null || this.variables.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (!(pl instanceof GeneralPlaceholder)) continue;
                GeneralPlaceholder casted = (GeneralPlaceholder)pl;
                string = string.replace(key, (CharSequence)casted.apply(arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractEntity target) {
        if (this.variables == null || this.variables.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    GeneralPlaceholder generalPlaceholder = (GeneralPlaceholder)pl;
                    string = string.replace(key, (CharSequence)generalPlaceholder.apply(arg));
                    continue;
                }
                if (pl instanceof MetaPlaceholder) {
                    MetaPlaceholder metaPlaceholder = (MetaPlaceholder)pl;
                    string = string.replace(key, (CharSequence)metaPlaceholder.apply(data, arg));
                    continue;
                }
                if (pl instanceof EntityPlaceholder) {
                    EntityPlaceholder entityPlaceholder = (EntityPlaceholder)pl;
                    string = string.replace(key, (CharSequence)entityPlaceholder.apply(target, arg));
                    continue;
                }
                if (pl instanceof LocationPlaceholder) {
                    LocationPlaceholder locationPlaceholder = (LocationPlaceholder)pl;
                    string = string.replace(key, locationPlaceholder.apply(target.getLocation(), arg));
                    continue;
                }
                if (pl instanceof TargetPlaceholder) {
                    TargetPlaceholder targetPlaceholder = (TargetPlaceholder)pl;
                    string = string.replace(key, targetPlaceholder.apply(data, target, arg));
                    continue;
                }
                if (pl instanceof MetaTargetPlaceholder) {
                    MetaTargetPlaceholder metaTargetPlaceholder = (MetaTargetPlaceholder)pl;
                    string = string.replace(key, (CharSequence)metaTargetPlaceholder.apply(data, target, arg));
                    continue;
                }
                if (pl instanceof ItemPlaceholder) {
                    SkillMetadata skillMetadata;
                    ItemPlaceholder itemPlaceholder = (ItemPlaceholder)pl;
                    if (!(data instanceof SkillMetadata) || !(skillMetadata = (SkillMetadata)data).getVariables().has("equip-item")) continue;
                    ItemStack itemStack = (ItemStack)skillMetadata.getVariables().get("equip-item").get();
                    string = string.replace(key, itemPlaceholder.apply(BukkitAdapter.adapt(itemStack), arg));
                    continue;
                }
                if (!(pl instanceof WorldPlaceholder)) continue;
                WorldPlaceholder worldPlaceholder = (WorldPlaceholder)pl;
                string = string.replace(key, worldPlaceholder.apply(target.getWorld(), arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractLocation target) {
        if (this.variables == null || this.variables.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    GeneralPlaceholder generalPlaceholder = (GeneralPlaceholder)pl;
                    string = string.replace(key, (CharSequence)generalPlaceholder.apply(arg));
                    continue;
                }
                if (pl instanceof MetaPlaceholder) {
                    MetaPlaceholder metaPlaceholder = (MetaPlaceholder)pl;
                    string = string.replace(key, (CharSequence)metaPlaceholder.apply(data, arg));
                    continue;
                }
                if (pl instanceof LocationPlaceholder) {
                    LocationPlaceholder locationPlaceholder = (LocationPlaceholder)pl;
                    string = string.replace(key, locationPlaceholder.apply(target, arg));
                    continue;
                }
                if (pl instanceof ItemPlaceholder) {
                    SkillMetadata skillMetadata;
                    ItemPlaceholder itemPlaceholder = (ItemPlaceholder)pl;
                    if (!(data instanceof SkillMetadata) || !(skillMetadata = (SkillMetadata)data).getVariables().has("equip-item")) continue;
                    ItemStack itemStack = (ItemStack)skillMetadata.getVariables().get("equip-item").get();
                    string = string.replace(key, itemPlaceholder.apply(BukkitAdapter.adapt(itemStack), arg));
                    continue;
                }
                if (!(pl instanceof WorldPlaceholder)) continue;
                WorldPlaceholder worldPlaceholder = (WorldPlaceholder)pl;
                string = string.replace(key, worldPlaceholder.apply(target.getWorld(), arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractItemStack itemStack) {
        if (this.variables == null || this.variables.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    GeneralPlaceholder generalPlaceholder = (GeneralPlaceholder)pl;
                    string = string.replace(key, (CharSequence)generalPlaceholder.apply(arg));
                    continue;
                }
                if (pl instanceof MetaPlaceholder) {
                    string = string.replace(key, (CharSequence)((MetaPlaceholder)pl).apply(data, arg));
                    continue;
                }
                if (!(pl instanceof ItemPlaceholder)) continue;
                ItemPlaceholder itemPlaceholder = (ItemPlaceholder)pl;
                string = string.replace(key, itemPlaceholder.apply(itemStack, arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(MythicSpawner spawner) {
        if (this.variables == null || this.variables.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    GeneralPlaceholder generalPlaceholder = (GeneralPlaceholder)pl;
                    string = string.replace(key, (CharSequence)generalPlaceholder.apply(arg));
                    continue;
                }
                if (pl instanceof SpawnerPlaceholder) {
                    SpawnerPlaceholder spawnerPlaceholder = (SpawnerPlaceholder)pl;
                    string = string.replace(key, spawnerPlaceholder.apply(spawner, arg));
                    continue;
                }
                if (!(pl instanceof WorldPlaceholder)) continue;
                WorldPlaceholder worldPlaceholder = (WorldPlaceholder)pl;
                string = string.replace(key, worldPlaceholder.apply(spawner.getLocation().getWorld(), arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    public boolean isStatic() {
        return (this.variables == null || this.variables.isEmpty()) && !this.doMath && !this.papi;
    }

    public boolean isPresent() {
        return this.strValue != null && !this.strValue.isEmpty();
    }

    protected PlaceholderExecutor getPlaceholderManager() {
        return MythicBukkit.inst().getPlaceholderManager();
    }

    public String serialize() {
        return this.strUnparsedValue;
    }

    public boolean isDoMath() {
        return this.doMath;
    }

    public void setDoMath(boolean doMath) {
        this.doMath = doMath;
    }
}

