/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.EntityPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.LocationPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;

@MythicPlaceholder(placeholder="parent")
public class ParentPlaceholder
implements MetaPlaceholder {
    private Placeholder targetPlaceholder;

    public ParentPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        if (args.length == 0) {
            return;
        }
        ((MythicBukkit)manager.getPlugin()).getClock().queueAfterLoad(() -> {
            String targetPlaceholderName = "target." + String.join((CharSequence)".", args);
            this.targetPlaceholder = manager.getPlaceholder(targetPlaceholderName).getPlaceholder();
        });
    }

    @Override
    public String apply(PlaceholderMeta placeholderMeta, String args) {
        ActiveMob am;
        if (this.targetPlaceholder == null) {
            return "[InvalidPlaceholder]";
        }
        SkillCaster skillCaster = placeholderMeta.getCaster();
        if (skillCaster instanceof ActiveMob && (am = (ActiveMob)skillCaster).getParent().isPresent()) {
            AbstractEntity parent = am.getParent().get();
            Placeholder placeholder = this.targetPlaceholder;
            if (placeholder instanceof EntityPlaceholder) {
                EntityPlaceholder entityPlaceholder = (EntityPlaceholder)placeholder;
                return (String)entityPlaceholder.apply(parent, args);
            }
            placeholder = this.targetPlaceholder;
            if (placeholder instanceof LocationPlaceholder) {
                LocationPlaceholder locationPlaceholder = (LocationPlaceholder)placeholder;
                return locationPlaceholder.apply(parent.getLocation(), args);
            }
        }
        return null;
    }
}

