/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.all.EntityNumericPlaceholder;
import io.lumine.mythic.core.skills.placeholders.all.MetaTargetPlaceholder;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;

@MythicPlaceholder(placeholder="target.fovoffset")
public class TargetFOVOffsetPlaceholder
extends EntityNumericPlaceholder
implements MetaTargetPlaceholder {
    @MythicField(name="rotation", aliases={"r"}, description="Rotates the FOV to check in")
    private double rotation = 0.0;
    @MythicField(name="absolute", aliases={"abs"}, description="If true, returns the absolute angle. If false, returns signed angle.")
    private boolean absolute;

    public TargetFOVOffsetPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        super(manager, config);
        if (config != null) {
            this.rotation = config.getDouble(new String[]{"rotation", "r"}, 0.0);
            this.absolute = config.getBoolean(new String[]{"absolute", "abs"}, true);
        }
    }

    @Override
    public String apply(PlaceholderMeta placeholderMeta, AbstractEntity target, String s2) {
        AbstractVector crossProduct;
        double offsetAngle;
        AbstractEntity casterEntity = placeholderMeta.getCaster().getEntity();
        if (target == null) {
            return "[No Target]";
        }
        AbstractVector casterVector = casterEntity.getEyeLocation().toVector();
        AbstractVector targetVector = target.getEyeLocation().toVector();
        AbstractVector headDirection = casterEntity.getEyeLocation().getDirection();
        headDirection = this.rotateAroundY(headDirection, this.rotation);
        AbstractVector targetDirection = targetVector.subtract(casterVector).normalize();
        double signedAngle = offsetAngle = Math.toDegrees(targetDirection.angle(headDirection));
        if (!this.absolute && (crossProduct = headDirection.crossProduct(targetDirection)).getY() < 0.0) {
            signedAngle = -offsetAngle;
        }
        return this.format(signedAngle);
    }

    private AbstractVector rotateAroundY(AbstractVector v, double degrees2) {
        double radians2 = Math.toRadians(degrees2);
        double sin = Math.sin(radians2);
        double cos = Math.cos(radians2);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return new AbstractVector(x, v.getY(), z);
    }
}

