/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.types;

import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableIdentifier;
import io.lumine.mythic.core.skills.variables.VariableMetaKeywords;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ScopedVariablePlaceholder {
    protected final PlaceholderExecutor manager;
    protected final PlaceholderString variable;
    protected final List<PolymorphicPlaceholder> metaKeywords;
    protected final VariableGetter variableGetter;

    public ScopedVariablePlaceholder(PlaceholderExecutor manager, String[] args) throws IllegalArgumentException {
        this.manager = manager;
        if (args.length == 0) {
            throw new IllegalArgumentException("At least one argument is required to fetch the variable's name!");
        }
        if (args.length == 1) {
            this.variable = PlaceholderString.of(args[0]);
            this.metaKeywords = null;
            this.variableGetter = this::getPlainly;
            return;
        }
        VariableIdentifier name = VariableIdentifier.of(args[0]);
        if (name.defaultValue() != null && args[1].matches("^\\d+$") && name.defaultValue().matches("^\\d+$")) {
            this.variable = PlaceholderString.of(args[0] + "." + args[1]);
            if (args.length == 2) {
                this.metaKeywords = null;
                this.variableGetter = this::getPlainly;
                return;
            }
            this.metaKeywords = Arrays.stream(Arrays.copyOfRange(args, 2, args.length)).map(PolymorphicPlaceholder::of).toList();
            this.variableGetter = this::getWithMetaKeywords;
            return;
        }
        this.variable = PlaceholderString.of(args[0]);
        this.metaKeywords = Arrays.stream(Arrays.copyOfRange(args, 1, args.length)).map(PolymorphicPlaceholder::of).toList();
        this.variableGetter = this::getWithMetaKeywords;
    }

    @NotNull
    public String getWithMetaKeywords(VariableRegistry registry, PlaceholderContext context) {
        if (this.metaKeywords == null) {
            return this.getPlainly(registry, context);
        }
        if (registry == null) {
            return "UNDEFINED";
        }
        VariableIdentifier variableName = VariableIdentifier.of(this.variable.get(context));
        Variable var = registry.get(variableName.name());
        if (var == null) {
            return variableName.getDefault();
        }
        String parsed = VariableMetaKeywords.resolveMetaKeywords(new VariableMetaKeywords.ExtractionContext(var, context, this.metaKeywords));
        return Objects.requireNonNullElse(parsed, "UNDEFINED");
    }

    @NotNull
    public String getPlainly(VariableRegistry registry, PlaceholderContext context) {
        if (registry == null) {
            return "UNDEFINED";
        }
        return registry.getString(VariableIdentifier.of(this.variable.get(context)));
    }

    @FunctionalInterface
    public static interface VariableGetter {
        public String get(VariableRegistry var1, PlaceholderContext var2);
    }
}

