/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats;

import io.lumine.mythic.api.skills.stats.StatSnapshot;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.HashMap;
import java.util.Map;

public class StatRegistrySnapshot
implements StatSnapshot {
    private final StatRegistry baseRegistry;
    private final Map<StatType, Double> statsSnapshot;

    public StatRegistrySnapshot(StatRegistry registry) {
        this.baseRegistry = registry;
        HashMap<StatType, Double> snapshot = new HashMap<StatType, Double>(registry.getStatMaps().size());
        for (Map.Entry<StatType, StatRegistry.StatMap> entry : registry.getStatMaps().entrySet()) {
            snapshot.put(entry.getKey(), entry.getValue().get());
        }
        this.statsSnapshot = snapshot;
    }

    @Override
    public double get(StatType type) {
        return this.statsSnapshot.getOrDefault(type, 0.0);
    }

    public StatRegistry getBaseRegistry() {
        return this.baseRegistry;
    }
}

