/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="randomLocationsNearTargets", aliases={"randomLocationsNearTarget", "randomLocationsNearTargetEntities", "randomLocationsNearTargetLocations", "RLNT", "RLNTE", "RLNTL"}, description="Targets random locations near the inherited targets")
public class RandomLocationsNearTargetsTargeter
extends ILocationSelector {
    private PlaceholderInt amount;
    private PlaceholderInt maxRadius;
    private PlaceholderInt minRadius;
    private int spacing;
    private int spacingSq;
    private boolean onSurface;

    public RandomLocationsNearTargetsTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 5, new String[0]);
        this.maxRadius = mlc.getPlaceholderInteger(new String[]{"radius", "r", "maxradius", "maxr"}, 5, new String[0]);
        this.minRadius = mlc.getPlaceholderInteger(new String[]{"minradius", "minr"}, 0, new String[0]);
        this.spacing = mlc.getInteger(new String[]{"spacing", "s"}, 0);
        this.onSurface = mlc.getBoolean(new String[]{"onsurface", "surface"}, false);
        this.spacingSq = this.spacing * this.spacing;
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets;
        block9: {
            double minRadiusSq;
            int minRadius;
            int maxRadius;
            int amountSq;
            int amount;
            block8: {
                targets = Lists.newArrayList();
                amount = this.amount.get(data);
                amountSq = amount * amount;
                maxRadius = this.maxRadius.get(data);
                minRadius = this.minRadius.get(data);
                minRadiusSq = Math.pow(minRadius, 2.0);
                if (data.getEntityTargets() == null || data.getEntityTargets().isEmpty()) break block8;
                for (AbstractEntity e : data.getEntityTargets()) {
                    int i = 0;
                    int j = 0;
                    while (i < amount && j < amountSq) {
                        ++j;
                        this.getPlugin().getMobManager();
                        AbstractLocation l = MobExecutor.findSafeSpawnLocation(e.getLocation(), maxRadius, 0.0, 1, false, this.onSurface);
                        if (minRadius > 0 && l.distanceSquared(e.getLocation()) < minRadiusSq) continue;
                        if (this.spacing > 0) {
                            boolean bad = false;
                            for (AbstractLocation l2 : targets) {
                                if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                                bad = true;
                                break;
                            }
                            if (bad) continue;
                        }
                        targets.add(this.mutate(data, l));
                        ++i;
                    }
                }
                break block9;
            }
            if (data.getLocationTargets() == null || data.getLocationTargets().isEmpty()) break block9;
            for (AbstractLocation e : data.getLocationTargets()) {
                int i = 0;
                int j = 0;
                while (i < amount && j < amountSq) {
                    ++j;
                    this.getPlugin().getMobManager();
                    AbstractLocation l = MobExecutor.findSafeSpawnLocation(e, maxRadius, 0.0, 1, false, this.onSurface);
                    if (minRadius > 0 && l.distanceSquared(e) < minRadiusSq) continue;
                    if (this.spacing > 0) {
                        boolean bad = false;
                        for (AbstractLocation l2 : targets) {
                            if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                            bad = true;
                            break;
                        }
                        if (bad) continue;
                    }
                    targets.add(this.mutate(data, l));
                    ++i;
                }
            }
        }
        return targets;
    }
}

