/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.triggers.meta;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class EntityAttackMetadata
extends SkillTriggerMetadata {
    private final EntityDamageByEntityEvent event;
    private final AbstractEntity damager;
    private final AbstractEntity damaged;
    private double damage;
    private double damageModifier = 1.0;
    private Map<String, Double> bonusDamage;
    private Map<String, Double> bonusDamageModifiers;
    private String damageCause;
    private String element;

    public EntityAttackMetadata(EntityDamageByEntityEvent event, DamageMetadata damageMetadata, AbstractEntity damager, AbstractEntity damaged) {
        super(damageMetadata);
        this.event = event;
        this.damager = damager;
        this.damaged = damaged;
        if (damageMetadata == null) {
            this.damage = event.getDamage();
            this.bonusDamage = Maps.newHashMap();
            this.damageCause = event.getCause().toString();
            this.element = "PHYSICAL";
        } else {
            this.damage = damageMetadata.getAmount();
            this.bonusDamage = damageMetadata.getBonusDamage();
            this.bonusDamageModifiers = damageMetadata.getBonusDamageModifiers();
            this.damageCause = "SKILL";
            this.element = damageMetadata.getElement();
            this.damageModifier = damageMetadata.getMultiplier();
        }
    }

    public double getFinalDamage() {
        double damage;
        if (this.bonusDamage.isEmpty()) {
            damage = this.damage;
        } else if (this.bonusDamageModifiers != null && !this.bonusDamageModifiers.isEmpty()) {
            damage = this.damage * this.bonusDamageModifiers.getOrDefault("PHYSICAL", 1.0);
            for (Map.Entry<String, Double> bonusEntry : this.bonusDamage.entrySet()) {
                String bonusType = bonusEntry.getKey();
                damage += bonusEntry.getValue() * this.bonusDamageModifiers.getOrDefault(bonusType, 1.0);
            }
        } else {
            damage = this.damage + this.bonusDamage.values().stream().mapToDouble(Double::doubleValue).sum();
        }
        double finalDamage = damage * this.damageModifier;
        return finalDamage;
    }

    public String getDamageType() {
        return this.element;
    }

    @Override
    public void applyToSkillMetadata(SkillMetadata skillMetadata) {
        AbstractEntity damaged = BukkitAdapter.adapt(this.event.getEntity());
        Optional<Object> maybeData = damaged.getMetadata("skill-damage");
        skillMetadata.getVariables().putDouble("damage-amount", this.getFinalDamage());
        if (maybeData.isPresent()) {
            DamageMetadata data = (DamageMetadata)maybeData.get();
            skillMetadata.getVariables().putObject("damage-metadata", data);
            skillMetadata.getVariables().putString("damage-cause", "SKILL");
            skillMetadata.getVariables().putString("real-damage-cause", this.event.getCause().toString());
            skillMetadata.getVariables().putString("damage-type", data.getElement() == null ? "SKILL" : data.getElement());
        } else {
            skillMetadata.getVariables().putString("damage-cause", this.event.getCause().toString());
        }
    }

    public double getDamageMultiplier(String type, double def) {
        if (this.bonusDamageModifiers == null) {
            this.bonusDamageModifiers = Maps.newTreeMap();
        }
        return this.bonusDamageModifiers.getOrDefault(type, def);
    }

    public void setDamageMultiplier(String type, double amount) {
        if (this.bonusDamageModifiers == null) {
            this.bonusDamageModifiers = Maps.newTreeMap();
        }
        this.bonusDamageModifiers.put(type, amount);
    }

    public EntityDamageByEntityEvent getEvent() {
        return this.event;
    }

    public AbstractEntity getDamager() {
        return this.damager;
    }

    public AbstractEntity getDamaged() {
        return this.damaged;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getDamageModifier() {
        return this.damageModifier;
    }

    public Map<String, Double> getBonusDamage() {
        return this.bonusDamage;
    }

    public Map<String, Double> getBonusDamageModifiers() {
        return this.bonusDamageModifiers;
    }

    public String getDamageCause() {
        return this.damageCause;
    }

    public String getElement() {
        return this.element;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public void setDamageModifier(double damageModifier) {
        this.damageModifier = damageModifier;
    }

    public void setBonusDamage(Map<String, Double> bonusDamage) {
        this.bonusDamage = bonusDamage;
    }

    public void setBonusDamageModifiers(Map<String, Double> bonusDamageModifiers) {
        this.bonusDamageModifiers = bonusDamageModifiers;
    }

    public void setDamageCause(String damageCause) {
        this.damageCause = damageCause;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityAttackMetadata)) {
            return false;
        }
        EntityAttackMetadata other = (EntityAttackMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDamage(), other.getDamage()) != 0) {
            return false;
        }
        if (Double.compare(this.getDamageModifier(), other.getDamageModifier()) != 0) {
            return false;
        }
        EntityDamageByEntityEvent this$event = this.getEvent();
        EntityDamageByEntityEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        AbstractEntity this$damager = this.getDamager();
        AbstractEntity other$damager = other.getDamager();
        if (this$damager == null ? other$damager != null : !this$damager.equals(other$damager)) {
            return false;
        }
        AbstractEntity this$damaged = this.getDamaged();
        AbstractEntity other$damaged = other.getDamaged();
        if (this$damaged == null ? other$damaged != null : !this$damaged.equals(other$damaged)) {
            return false;
        }
        Map<String, Double> this$bonusDamage = this.getBonusDamage();
        Map<String, Double> other$bonusDamage = other.getBonusDamage();
        if (this$bonusDamage == null ? other$bonusDamage != null : !((Object)this$bonusDamage).equals(other$bonusDamage)) {
            return false;
        }
        Map<String, Double> this$bonusDamageModifiers = this.getBonusDamageModifiers();
        Map<String, Double> other$bonusDamageModifiers = other.getBonusDamageModifiers();
        if (this$bonusDamageModifiers == null ? other$bonusDamageModifiers != null : !((Object)this$bonusDamageModifiers).equals(other$bonusDamageModifiers)) {
            return false;
        }
        String this$damageCause = this.getDamageCause();
        String other$damageCause = other.getDamageCause();
        if (this$damageCause == null ? other$damageCause != null : !this$damageCause.equals(other$damageCause)) {
            return false;
        }
        String this$element = this.getElement();
        String other$element = other.getElement();
        return !(this$element == null ? other$element != null : !this$element.equals(other$element));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityAttackMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $damage = Double.doubleToLongBits(this.getDamage());
        result = result * 59 + (int)($damage >>> 32 ^ $damage);
        long $damageModifier = Double.doubleToLongBits(this.getDamageModifier());
        result = result * 59 + (int)($damageModifier >>> 32 ^ $damageModifier);
        EntityDamageByEntityEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        AbstractEntity $damager = this.getDamager();
        result = result * 59 + ($damager == null ? 43 : $damager.hashCode());
        AbstractEntity $damaged = this.getDamaged();
        result = result * 59 + ($damaged == null ? 43 : $damaged.hashCode());
        Map<String, Double> $bonusDamage = this.getBonusDamage();
        result = result * 59 + ($bonusDamage == null ? 43 : ((Object)$bonusDamage).hashCode());
        Map<String, Double> $bonusDamageModifiers = this.getBonusDamageModifiers();
        result = result * 59 + ($bonusDamageModifiers == null ? 43 : ((Object)$bonusDamageModifiers).hashCode());
        String $damageCause = this.getDamageCause();
        result = result * 59 + ($damageCause == null ? 43 : $damageCause.hashCode());
        String $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        return result;
    }

    public String toString() {
        return "EntityAttackMetadata(event=" + String.valueOf(this.getEvent()) + ", damager=" + String.valueOf(this.getDamager()) + ", damaged=" + String.valueOf(this.getDamaged()) + ", damage=" + this.getDamage() + ", damageModifier=" + this.getDamageModifier() + ", bonusDamage=" + String.valueOf(this.getBonusDamage()) + ", bonusDamageModifiers=" + String.valueOf(this.getBonusDamageModifiers()) + ", damageCause=" + this.getDamageCause() + ", element=" + this.getElement() + ")";
    }
}

