/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import com.google.common.base.Preconditions;
import io.lumine.mythic.bukkit.events.MythicPlayerVariableSetEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import java.util.Map;

public class PlayerVariableRegistry
extends VariableRegistry {
    private transient PlayerData playerData;

    public PlayerVariableRegistry() {
    }

    public PlayerVariableRegistry(Map<String, Variable> value) {
        super(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Variable value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        this.lock.lock();
        try {
            MythicPlayerVariableSetEvent event = new MythicPlayerVariableSetEvent(this.playerData, key, value);
            Events.call(event);
            if (!event.isCancelled()) {
                this.entries.put(key, value);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<String, ? extends Variable> value) {
        Preconditions.checkNotNull(value);
        this.lock.lock();
        try {
            for (Map.Entry<String, ? extends Variable> entry : value.entrySet()) {
                MythicPlayerVariableSetEvent event = new MythicPlayerVariableSetEvent(this.playerData, entry.getKey(), entry.getValue());
                Events.call(event);
                if (event.isCancelled()) continue;
                this.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(String key) {
        Preconditions.checkNotNull((Object)key);
        this.lock.lock();
        try {
            this.entries.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clean() {
        this.lock.lock();
        try {
            this.entries.values().removeIf(o -> o.shouldExpire());
        }
        finally {
            this.lock.unlock();
        }
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public void setPlayerData(PlayerData playerData) {
        this.playerData = playerData;
    }
}

