/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.VariableUtils;

public abstract class Variable
implements Cloneable {
    private long expirationTime = 0L;

    public Variable() {
    }

    public Variable(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean shouldExpire() {
        return this.expirationTime > 1L && this.expirationTime <= System.currentTimeMillis();
    }

    public boolean shouldSave() {
        return !this.shouldExpire() && this.expirationTime != 1L;
    }

    public abstract <T> VariableInfo<T> getVariableInfo();

    public abstract Object get();

    public abstract Object getValueClone();

    public VariableType getType() {
        return this.getVariableInfo().type();
    }

    public String getTypeName() {
        return this.getVariableInfo().typeName();
    }

    public <T> Class<T> getValueClass() {
        return this.getVariableInfo().valueClass();
    }

    public abstract boolean executeAddition(PolymorphicPlaceholder var1, PlaceholderContext var2);

    public abstract boolean executeSubtraction(PolymorphicPlaceholder var1, PlaceholderContext var2);

    public abstract boolean checkEquality(PolymorphicPlaceholder var1, PlaceholderContext var2);

    public abstract String toString();

    public String formatted() {
        return this.toString();
    }

    public void unregister() {
    }

    public Variable clone() {
        try {
            return (Variable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Variable toType(Variable var, VariableType type) {
        if (var == null) {
            return null;
        }
        return Variable.ofType(type, var);
    }

    public static Variable ofType(VariableType type, Object value) {
        return Variable.ofType(type, value, 1L);
    }

    public static Variable ofType(VariableType type, Object value, boolean save) {
        return Variable.ofType(type, value, save ? 0L : 1L);
    }

    public static Variable ofType(VariableType type, Object value, long expire) {
        VariableInfo<?> info = VariableUtils.variableInfoByType.get((Object)type);
        if (info == null) {
            return null;
        }
        if (info.objectConstructor() == null) {
            return null;
        }
        if (value instanceof Variable) {
            Variable var = (Variable)value;
            value = var.toString();
        }
        return info.objectConstructor().apply(value, expire);
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }
}

