/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import com.google.common.primitives.Ints;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.placeholders.PlaceholderTime;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.constants.ItemKeys;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableUnstableUtils;
import io.lumine.mythic.core.skills.variables.VariableUtils;
import io.lumine.mythic.core.skills.variables.types.ListVariable;
import io.lumine.mythic.core.skills.variables.types.MapVariable;
import io.lumine.mythic.core.skills.variables.types.TimeVariable;
import io.lumine.mythic.core.skills.variables.types.VectorVariable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class VariableMetaKeywords {
    private static final Map<Class<?>, Map<String, MetaKeywordsDefinition<?, ?>>> metaKeywordsRegistry = new ConcurrentHashMap();
    private static final Map<String, String> metaKeywordsCache = new ConcurrentHashMap<String, String>();

    public static <T> void registerMetaKeywords(Class<T> variableClass, Map<String, MetaKeywordsDefinition<T, ?>> extractors) {
        ConcurrentHashMap castedMap = new ConcurrentHashMap(extractors);
        if (metaKeywordsRegistry.containsKey(variableClass)) {
            metaKeywordsRegistry.get(variableClass).putAll(castedMap);
            return;
        }
        metaKeywordsRegistry.put(variableClass, castedMap);
    }

    public static <T, K> void registerMetaKeyword(Class<T> startClass, String key, int additionalKeys, MetaKeywordsExtractor<T, K> extractor, Class<K> returnType) {
        Map.Entry<String, MetaKeywordsDefinition<T, K>> entry = VariableMetaKeywords.add(key, additionalKeys, extractor, returnType);
        if (!metaKeywordsRegistry.containsKey(startClass)) {
            metaKeywordsRegistry.put(startClass, new ConcurrentHashMap());
        }
        metaKeywordsRegistry.get(startClass).put(entry.getKey(), entry.getValue());
    }

    public static <T, K> Map.Entry<String, MetaKeywordsDefinition<T, K>> add(String key, MetaKeywordsExtractor<T, K> extractor, Class<K> returnType) {
        return VariableMetaKeywords.add(key, 0, extractor, returnType);
    }

    public static <T, K> Map.Entry<String, MetaKeywordsDefinition<T, K>> add(String key, int additionalKeys, MetaKeywordsExtractor<T, K> extractor, Class<K> returnType) {
        return Map.entry(key.toLowerCase(), new MetaKeywordsDefinition<T, K>(extractor, additionalKeys + 1, returnType));
    }

    private static String getCacheKey(String value, List<PolymorphicPlaceholder> metaKeywords) {
        StringBuilder sb = new StringBuilder(value);
        if (metaKeywords != null && !metaKeywords.isEmpty()) {
            sb.append("@");
            for (int i = 0; i < metaKeywords.size(); ++i) {
                sb.append(metaKeywords.get(i).originalValue());
                if (i >= metaKeywords.size() - 1) continue;
                sb.append(".");
            }
        }
        return sb.toString();
    }

    private static <T> String processCacheOperation(T value, Class<T> type, ExtractionContext context) {
        String cacheKey = VariableMetaKeywords.getCacheKey(type.getName() + ":" + value.toString(), context.getRemainingKeys());
        return metaKeywordsCache.computeIfAbsent(cacheKey, key -> String.valueOf(VariableMetaKeywords.processMetaKeywords(value, type, context)));
    }

    public static String resolveMetaKeywords(ExtractionContext context) {
        Object ret = VariableMetaKeywords.processMetaKeywords(context.variable.getValueClone(), context.variable.getValueClass(), context);
        return String.valueOf(ret);
    }

    public static <T> Object processMetaKeywords(T value, Class<T> type, ExtractionContext context) {
        String keyToMatch = context.getString(0).toLowerCase();
        if (keyToMatch.equals("cache")) {
            return VariableMetaKeywords.processCacheOperation(value, type, context.shift(1));
        }
        Map<String, MetaKeywordsDefinition<?, ?>> extractorMap = metaKeywordsRegistry.getOrDefault(type, metaKeywordsRegistry.get(Object.class));
        MetaKeywordsDefinition<?, ?> specificDefinition = extractorMap.get(keyToMatch);
        if (specificDefinition != null) {
            return VariableMetaKeywords.executeMetadataExtraction(specificDefinition, value, context);
        }
        MetaKeywordsDefinition<?, ?> defaultDefinitionForSpecificType = extractorMap.get("default");
        if (defaultDefinitionForSpecificType != null) {
            return VariableMetaKeywords.executeMetadataExtraction(defaultDefinitionForSpecificType, value, context);
        }
        return "NO_MATCHING_METADATA";
    }

    private static <T, K> Object executeMetadataExtraction(MetaKeywordsDefinition<T, K> definition, T value, ExtractionContext context) {
        if (definition.requiredSegments() > context.length()) {
            return "NOT_ENOUGH_KEYS_IN_VARIABLE_METADATA";
        }
        K extracted = definition.extractor().extract(value, context);
        if (extracted == null) {
            return "UNDEFINED";
        }
        if (definition.requiredSegments() < context.length()) {
            return VariableMetaKeywords.processMetaKeywords(extracted, definition.returnType, context.shift(definition.requiredSegments()));
        }
        VariableUtils.VariableToStringFactory<?> finalConversion = VariableUtils.variableInfoByValueClass.get(definition.returnType).toStringFunction();
        return finalConversion.convert(extracted);
    }

    static {
        VariableUtils.variableInfoByValueClass.forEach((startClass, conversionStart) -> {
            VariableUtils.VariableToStringFactory convertOriginToString = conversionStart.toStringFunction();
            VariableUtils.VariableToStringFactory formatString = conversionStart.formattedFunction();
            VariableMetaKeywords.registerMetaKeyword(startClass, "formatted", 0, (v, c) -> formatString.convert(v), String.class);
            VariableUtils.variableInfoByValueClass.forEach((finalClass, conversionFinalTarget) -> {
                String keyword = "to" + conversionFinalTarget.typeName();
                VariableUtils.VariableFromStringFactory convertFinalFromString = conversionFinalTarget.fromStringFunction();
                MetaKeywordsExtractor<Object, Object> extractor = (v, c) -> convertFinalFromString.convert(convertOriginToString.convert(v));
                VariableMetaKeywords.registerMetaKeyword(startClass, keyword, 0, extractor, finalClass);
            });
        });
        VariableMetaKeywords.registerMetaKeywords(Integer.class, Map.ofEntries(VariableMetaKeywords.add("add", 1, (v, c) -> v + c.getInt(1), Integer.class), VariableMetaKeywords.add("sub", 1, (v, c) -> v - c.getInt(1), Integer.class), VariableMetaKeywords.add("mul", 1, (v, c) -> v * c.getInt(1), Integer.class), VariableMetaKeywords.add("div", 1, (v, c) -> v / c.getInt(1), Integer.class), VariableMetaKeywords.add("abs", (v, c) -> Math.abs(v), Integer.class)));
        VariableMetaKeywords.registerMetaKeywords(Float.class, Map.ofEntries(VariableMetaKeywords.add("add", 1, (v, c) -> Float.valueOf(v.floatValue() + c.getObject(1, PolymorphicPlaceholder::getFloat).floatValue()), Float.class), VariableMetaKeywords.add("sub", 1, (v, c) -> Float.valueOf(v.floatValue() - c.getObject(1, PolymorphicPlaceholder::getFloat).floatValue()), Float.class), VariableMetaKeywords.add("mul", 1, (v, c) -> Float.valueOf(v.floatValue() * c.getObject(1, PolymorphicPlaceholder::getFloat).floatValue()), Float.class), VariableMetaKeywords.add("div", 1, (v, c) -> Float.valueOf(v.floatValue() / c.getObject(1, PolymorphicPlaceholder::getFloat).floatValue()), Float.class), VariableMetaKeywords.add("abs", (v, c) -> Float.valueOf(Math.abs(v.floatValue())), Float.class), VariableMetaKeywords.add("round", (v, c) -> Math.round(v.floatValue()), Integer.class), VariableMetaKeywords.add("precision", 1, (v, c) -> {
            BigDecimal bigDecimal = new BigDecimal(v.floatValue());
            return Float.valueOf(bigDecimal.setScale(c.getInt(1), RoundingMode.HALF_UP).floatValue());
        }, Float.class)));
        VariableMetaKeywords.registerMetaKeywords(Long.class, Map.ofEntries(VariableMetaKeywords.add("add", 1, (v, c) -> v + (long)c.getInt(1), Long.class), VariableMetaKeywords.add("sub", 1, (v, c) -> v - (long)c.getInt(1), Long.class), VariableMetaKeywords.add("mul", 1, (v, c) -> v * (long)c.getInt(1), Long.class), VariableMetaKeywords.add("div", 1, (v, c) -> v / (long)c.getInt(1), Long.class), VariableMetaKeywords.add("abs", (v, c) -> Math.abs(v), Long.class)));
        VariableMetaKeywords.registerMetaKeywords(Double.class, Map.ofEntries(VariableMetaKeywords.add("add", 1, (v, c) -> v + c.getObject(1, PolymorphicPlaceholder::getDouble), Double.class), VariableMetaKeywords.add("sub", 1, (v, c) -> v - c.getObject(1, PolymorphicPlaceholder::getDouble), Double.class), VariableMetaKeywords.add("mul", 1, (v, c) -> v * c.getObject(1, PolymorphicPlaceholder::getDouble), Double.class), VariableMetaKeywords.add("div", 1, (v, c) -> v / c.getObject(1, PolymorphicPlaceholder::getDouble), Double.class), VariableMetaKeywords.add("abs", (v, c) -> Math.abs(v), Double.class), VariableMetaKeywords.add("round", (v, c) -> Math.round(v), Long.class), VariableMetaKeywords.add("precision", 1, (v, c) -> {
            BigDecimal bigDecimal = new BigDecimal((double)v);
            return bigDecimal.setScale(c.getInt(1), RoundingMode.HALF_UP).doubleValue();
        }, Double.class)));
        VariableMetaKeywords.registerMetaKeywords(Boolean.class, Map.ofEntries(VariableMetaKeywords.add("inverse", (v, c) -> v == false, Boolean.class), VariableMetaKeywords.add("number", (v, c) -> v != false ? 1 : 0, Integer.class), VariableMetaKeywords.add("yesno", (v, c) -> v != false ? "yes" : "no", String.class), VariableMetaKeywords.add("union", 1, (v, c) -> v != false || c.getObject(1, PolymorphicPlaceholder::getBoolean) != false, Boolean.class), VariableMetaKeywords.add("intersection", 1, (v, c) -> v != false && c.getObject(1, PolymorphicPlaceholder::getBoolean) != false, Boolean.class), VariableMetaKeywords.add("difference", 1, (v, c) -> v != false && c.getObject(1, PolymorphicPlaceholder::getBoolean) == false, Boolean.class)));
        VariableMetaKeywords.registerMetaKeywords(String.class, Map.ofEntries(VariableMetaKeywords.add("size", (v, c) -> v.length(), Integer.class), VariableMetaKeywords.add("uppercase", (v, c) -> v.toUpperCase(), String.class), VariableMetaKeywords.add("lowercase", (v, c) -> v.toLowerCase(), String.class), VariableMetaKeywords.add("capitalize", (v, c) -> v.isEmpty() ? v : v.substring(0, 1).toUpperCase() + v.substring(1), String.class), VariableMetaKeywords.add("trim", (v, c) -> v.trim(), String.class), VariableMetaKeywords.add("replace", 2, (v, c) -> v.replace(c.getString(1), c.getString(2)), String.class), VariableMetaKeywords.add("remove", 1, (v, c) -> v.replace(c.getString(1), ""), String.class), VariableMetaKeywords.add("contains", 1, (v, c) -> v.contains(c.getString(1)), Boolean.class), VariableMetaKeywords.add("substring", 2, (v, c) -> v.substring(c.getInt(1), c.getInt(2)), String.class), VariableMetaKeywords.add("shift", 1, (v, c) -> v.substring(c.getInt(1)), String.class), VariableMetaKeywords.add("split", 2, (v, c) -> String.join((CharSequence)c.getString(2), v.split(c.getString(1))), String.class), VariableMetaKeywords.add("indexOf", 1, (v, c) -> v.indexOf(c.getString(1)), Integer.class), VariableMetaKeywords.add("lastIndexOf", 1, (v, c) -> v.lastIndexOf(c.getString(1)), Integer.class), VariableMetaKeywords.add("startswith", 1, (v, c) -> v.startsWith(c.getString(1)), Boolean.class), VariableMetaKeywords.add("endswith", 1, (v, c) -> v.endsWith(c.getString(1)), Boolean.class), VariableMetaKeywords.add("append", 1, (v, c) -> v + c.getString(1), String.class), VariableMetaKeywords.add("prepend", 1, (v, c) -> c.getString(1) + v, String.class), VariableMetaKeywords.add("insert", 2, (v, c) -> v.substring(0, c.getInt(1)) + c.getString(2) + v.substring(c.getInt(1)), String.class), VariableMetaKeywords.add("regex", 1, (v, c) -> {
            Pattern pattern = Pattern.compile(c.getString(1));
            Matcher matcher = pattern.matcher((CharSequence)v);
            return matcher.find();
        }, Boolean.class), VariableMetaKeywords.add("default", (v, c) -> {
            int index = c.getInt(0);
            if (index < 0 || index >= v.length()) {
                return "UNDEFINED";
            }
            return String.valueOf(v.charAt(index));
        }, String.class)));
        VariableMetaKeywords.registerMetaKeywords(Set.class, Map.ofEntries(VariableMetaKeywords.add("sortNum", (v, c) -> ((List)((Object)v)).stream().map(s2 -> {
            try {
                return Double.parseDouble(s2);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }).sorted().toList(), List.class), VariableMetaKeywords.add("join", 1, (v, c) -> String.join((CharSequence)c.getString(1), v), String.class), VariableMetaKeywords.add("contains", 1, (v, c) -> v.contains(c.getString(1)), Boolean.class)));
        VariableMetaKeywords.registerMetaKeywords(AbstractLocation.class, Map.ofEntries(VariableMetaKeywords.add("x", (v, c) -> v.getX(), Double.class), VariableMetaKeywords.add("y", (v, c) -> v.getY(), Double.class), VariableMetaKeywords.add("z", (v, c) -> v.getZ(), Double.class), VariableMetaKeywords.add("world", (v, c) -> v.getWorld().getName(), String.class), VariableMetaKeywords.add("yaw", (v, c) -> v.getYaw(), Double.class), VariableMetaKeywords.add("pitch", (v, c) -> v.getPitch(), Double.class), VariableMetaKeywords.add("coords", (v, c) -> ListVariable.fromString(v.getX() + "," + v.getY() + "," + v.getZ()), List.class)));
        VariableMetaKeywords.registerMetaKeywords(AbstractVector.class, Map.ofEntries(VariableMetaKeywords.add("x", (v, c) -> v.getX(), Double.class), VariableMetaKeywords.add("y", (v, c) -> v.getY(), Double.class), VariableMetaKeywords.add("z", (v, c) -> v.getZ(), Double.class), VariableMetaKeywords.add("normalized", (v, c) -> v.normalize(), AbstractVector.class), VariableMetaKeywords.add("length", (v, c) -> v.length(), Double.class), VariableMetaKeywords.add("mul", 1, (v, c) -> v.clone().multiply(VectorVariable.toVector(c.getString(1))), AbstractVector.class), VariableMetaKeywords.add("div", 1, (v, c) -> v.clone().divide(VectorVariable.toVector(c.getString(1))), AbstractVector.class), VariableMetaKeywords.add("add", 1, (v, c) -> v.clone().add(VectorVariable.toVector(c.getString(1))), AbstractVector.class), VariableMetaKeywords.add("sub", 1, (v, c) -> v.clone().subtract(VectorVariable.toVector(c.getString(1))), AbstractVector.class), VariableMetaKeywords.add("rotate", 2, (v, c) -> v.clone().rotateAroundAxis(VectorVariable.toVector(c.getString(1)), c.getObject(2, PolymorphicPlaceholder::getDouble)), AbstractVector.class)));
        VariableMetaKeywords.registerMetaKeywords(List.class, Map.ofEntries(VariableMetaKeywords.add("size", (v, c) -> v.size(), Integer.class), VariableMetaKeywords.add("first", (v, c) -> (String)v.getFirst(), String.class), VariableMetaKeywords.add("last", (v, c) -> (String)v.getLast(), String.class), VariableMetaKeywords.add("reverse", (v, c) -> v.reversed(), List.class), VariableMetaKeywords.add("sort", (v, c) -> v.stream().sorted().toList(), List.class), VariableMetaKeywords.add("sortNum", (v, c) -> v.stream().map(Double::parseDouble).sorted().toList(), List.class), VariableMetaKeywords.add("shuffle", (v, c) -> {
            Collections.shuffle(v);
            return v;
        }, List.class), VariableMetaKeywords.add("trim", (v, c) -> v.stream().map(String::trim).toList(), List.class), VariableMetaKeywords.add("get", 1, (v, c) -> (String)v.get(c.getInt(1)), String.class), VariableMetaKeywords.add("join", 1, (v, c) -> String.join((CharSequence)c.getString(1), v), String.class), VariableMetaKeywords.add("contains", 1, (v, c) -> v.contains(c.getString(1)), Boolean.class), VariableMetaKeywords.add("maxNumber", (v, c) -> v.stream().mapToDouble(Double::parseDouble).max().orElse(-1.0), Double.class), VariableMetaKeywords.add("minNumber", (v, c) -> v.stream().mapToDouble(Double::parseDouble).min().orElse(-1.0), Double.class), VariableMetaKeywords.add("indexOf", 1, (v, c) -> v.indexOf(c.getString(1)), Integer.class), VariableMetaKeywords.add("lastIndexOf", 1, (v, c) -> v.lastIndexOf(c.getString(1)), Integer.class), VariableMetaKeywords.add("slice", 2, (v, c) -> v.subList(c.getInt(1), c.getInt(2)), List.class), VariableMetaKeywords.add("sliceFrom", 1, (v, c) -> v.subList(c.getInt(1), v.size()), List.class), VariableMetaKeywords.add("sliceTo", 1, (v, c) -> v.subList(0, c.getInt(1)), List.class), VariableMetaKeywords.add("append", 1, (v, c) -> {
            v.add(c.getString(1));
            return v;
        }, List.class), VariableMetaKeywords.add("prepend", 1, (v, c) -> {
            v.add(0, c.getString(1));
            return v;
        }, List.class), VariableMetaKeywords.add("insert", 2, (v, c) -> {
            v.add(c.getInt(1), c.getString(2));
            return v;
        }, List.class), VariableMetaKeywords.add("remove", 1, (v, c) -> {
            v.remove(c.getInt(1));
            return v;
        }, List.class), VariableMetaKeywords.add("default", (v, c) -> {
            Integer ret = Ints.tryParse((String)c.getString(0));
            if (ret == null) {
                return ListVariable.getWithPipeDefault(v, c.getString(0));
            }
            return (String)v.get(ret);
        }, String.class)));
        VariableMetaKeywords.registerMetaKeywords(Map.class, Map.ofEntries(VariableMetaKeywords.add("size", (v, c) -> v.size(), Integer.class), VariableMetaKeywords.add("keys", (v, c) -> new ArrayList(v.keySet()), List.class), VariableMetaKeywords.add("values", (v, c) -> new ArrayList(v.values()), List.class), VariableMetaKeywords.add("get", 1, (v, c) -> MapVariable.getWithPipeDefault(v, c.getString(1)), String.class), VariableMetaKeywords.add("default", (v, c) -> MapVariable.getWithPipeDefault(v, c.getString(0)), String.class)));
        VariableMetaKeywords.registerMetaKeywords(Instant.class, Map.ofEntries(VariableMetaKeywords.add("formatted", 1, (v, c) -> TimeVariable.getFormattedTime(v.toEpochMilli(), c.getString(1)), String.class), VariableMetaKeywords.add("delta", 1, (v, c) -> TimeVariable.getTimeDelta(v, (Instant)PlaceholderTime.of(c.getString(1)).get()), Long.class), VariableMetaKeywords.add("duration", (v, c) -> TimeVariable.getFormattedDuration(v.toEpochMilli()), String.class)));
        VariableMetaKeywords.registerMetaKeywords(BukkitItemStack.class, Map.ofEntries(VariableMetaKeywords.add("withType", 1, (v, c) -> {
            v.type(Material.valueOf((String)c.getString(1).toUpperCase()));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withDurability", 1, (v, c) -> {
            v.durability(c.getInt(1));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withMaxDurability", 1, (v, c) -> {
            v.maxDurability(c.getInt(1));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withLore", 1, (v, c) -> {
            v.setLore(c.getObject(1, PolymorphicPlaceholder::getList));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withName", 1, (v, c) -> {
            v.setName(c.getString(1));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withMythicType", 1, (v, c) -> {
            v.mythicItemType(c.getString(1));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withEnchants", 1, (v, c) -> {
            Map<String, String> newEnchants = MapVariable.fromString(c.getString(1));
            Map<Enchantment, Integer> actualMap = newEnchants.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).collect(Collectors.toMap(e -> Enchantment.getByName((String)((String)e.getKey())), e -> Integer.parseInt((String)e.getValue())));
            v.editMeta(meta -> meta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)meta).removeEnchant(arg_0)));
            actualMap.forEach((e, l) -> v.enchant((Enchantment)e, (int)l));
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withCustomData", 3, (v, c) -> {
            v.editMeta(meta -> {
                PersistentDataContainer container = VariableUnstableUtils.getContainer(meta);
                NamespacedKey key = new NamespacedKey(c.getString(1), c.getString(2));
                container.set(key, PersistentDataType.STRING, (Object)c.getString(3));
            });
            return v;
        }, BukkitItemStack.class), VariableMetaKeywords.add("withAmount", 1, (v, c) -> v.amount(c.getInt(1)), BukkitItemStack.class), VariableMetaKeywords.add("withUUID", 1, (v, c) -> v.UUID(UUID.fromString(c.getString(1))), BukkitItemStack.class), VariableMetaKeywords.add("withTimestamp", 1, (v, c) -> v.timestamp(c.getInt(1)), BukkitItemStack.class), VariableMetaKeywords.add("withCustomModelData", 1, (v, c) -> v.modelData(c.getInt(1)), BukkitItemStack.class), VariableMetaKeywords.add("withModel", 2, (v, c) -> v.itemModel(new NamespacedKey(c.getString(1), c.getString(2))), BukkitItemStack.class), VariableMetaKeywords.add("type", (v, c) -> v.getType().toString(), String.class), VariableMetaKeywords.add("durability", (v, c) -> v.getDurability(), Integer.class), VariableMetaKeywords.add("maxDurability", (v, c) -> v.getMaxDurability(), Integer.class), VariableMetaKeywords.add("lore", (v, c) -> v.getItemMeta().getLore(), List.class), VariableMetaKeywords.add("name", (v, c) -> v.getItemMeta().getDisplayName(), String.class), VariableMetaKeywords.add("mythicType", (v, c) -> {
            ItemMeta meta = v.getItemMeta();
            if (meta == null) {
                return "UNDEFINED";
            }
            PersistentDataContainer container = VariableUnstableUtils.getContainer(meta);
            return (String)container.get(ItemKeys.TYPE, PersistentDataType.STRING);
        }, String.class), VariableMetaKeywords.add("enchants", (v, c) -> {
            Map enchantments = v.getItemStack().getEnchantments();
            Map<String, String> stringMap = enchantments.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).collect(Collectors.toMap(e -> ((Enchantment)e.getKey()).getName(), e -> String.valueOf(e.getValue())));
            return stringMap;
        }, Map.class), VariableMetaKeywords.add("getCustomData", 2, (v, c) -> {
            ItemMeta meta = v.getItemMeta();
            if (meta == null) {
                return "UNDEFINED";
            }
            PersistentDataContainer container = VariableUnstableUtils.getContainer(meta);
            NamespacedKey key = new NamespacedKey(c.getString(1), c.getString(2));
            return (String)container.get(key, PersistentDataType.STRING);
        }, String.class), VariableMetaKeywords.add("customModelData", (v, c) -> v.getModelData(), Integer.class), VariableMetaKeywords.add("model", (v, c) -> v.getItemModel().toString(), String.class), VariableMetaKeywords.add("amount", (v, c) -> v.getAmount(), Integer.class)));
    }

    @FunctionalInterface
    public static interface MetaKeywordsExtractor<T, K> {
        public K extract(T var1, ExtractionContext var2);
    }

    public record MetaKeywordsDefinition<T, K>(MetaKeywordsExtractor<T, K> extractor, int requiredSegments, Class<K> returnType) {
    }

    public static class ExtractionContext {
        final Variable variable;
        final PlaceholderContext placeholderContext;
        private final List<PolymorphicPlaceholder> keys;
        int index;

        public ExtractionContext(Variable variable, PlaceholderContext placeholderContext, List<PolymorphicPlaceholder> keys) {
            this.variable = variable;
            this.placeholderContext = placeholderContext;
            this.keys = keys;
            this.index = 0;
        }

        public PolymorphicPlaceholder get(int i) {
            return this.keys.get(this.index + i);
        }

        public PolymorphicPlaceholder get() {
            return this.keys.get(this.index);
        }

        public int length() {
            return this.keys.size() - this.index;
        }

        public List<PolymorphicPlaceholder> getRemainingKeys() {
            return this.keys.subList(this.index, this.keys.size());
        }

        public ExtractionContext shift(int i) {
            this.index += i;
            return this;
        }

        private <T> T getObject(int indexOffset, BiFunction<PolymorphicPlaceholder, PlaceholderContext, T> function) {
            return function.apply(this.get(indexOffset), this.placeholderContext);
        }

        private int getInt(int indexOffset) {
            return this.get(indexOffset).getInt(this.placeholderContext);
        }

        private String getString(int indexOffset) {
            return this.get(indexOffset).getString(this.placeholderContext);
        }
    }
}

