/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;

public class BooleanVariable
extends Variable {
    private boolean value;
    public static final VariableInfo<Boolean> variableInfo = VariableInfo.builder().clazz(BooleanVariable.class).type(VariableType.BOOLEAN).typeName("Boolean").valueClass(Boolean.class).objectConstructor(BooleanVariable::ofObject).polymorphicConstructor(BooleanVariable::of).toStringFunction(BooleanVariable::toString).fromStringFunction(BooleanVariable::fromString).build();

    public VariableInfo<Boolean> getVariableInfo() {
        return variableInfo;
    }

    public static BooleanVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new BooleanVariable(data.getBoolean(context), expirationTime);
    }

    public static String toString(Boolean data) {
        return data.toString();
    }

    public static Boolean fromString(String data) {
        return PolymorphicPlaceholder.of(data).getBoolean(PlaceholderContext.of());
    }

    public static BooleanVariable ofObject(Object value, long expirationTime) {
        if (value == null) {
            return new BooleanVariable(false, expirationTime);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new BooleanVariable(bool, expirationTime);
        }
        return new BooleanVariable(value.toString(), expirationTime);
    }

    public BooleanVariable(boolean value) {
        this.value = value;
    }

    public BooleanVariable(boolean value, long expirationTime) {
        super(expirationTime);
        this.value = value;
    }

    public BooleanVariable(String value) {
        this.build(value);
    }

    public BooleanVariable(String value, long expirationTime) {
        super(expirationTime);
        this.build(value);
    }

    public void build(String value) {
        this.value = BooleanVariable.fromString(value);
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public Boolean getValueClone() {
        return this.value;
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        boolean newValue = data.getBoolean(context);
        this.value = this.value || newValue;
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        boolean newValue = data.getBoolean(context);
        this.value = this.value && newValue;
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        boolean newValue = data.getBoolean(context);
        return this.value == newValue;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean isValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BooleanVariable)) {
            return false;
        }
        BooleanVariable other = (BooleanVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isValue() == other.isValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BooleanVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValue() ? 79 : 97);
        return result;
    }
}

