/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ListVariable
extends Variable
implements ContainingVariable {
    private final List<String> value = Lists.newCopyOnWriteArrayList();
    public static final VariableInfo<List> variableInfo = VariableInfo.builder().clazz(ListVariable.class).type(VariableType.LIST).typeName("List").valueClass(List.class).objectConstructor(ListVariable::ofObject).polymorphicConstructor(ListVariable::of).toStringFunction(ListVariable::toString).fromStringFunction(ListVariable::fromString).formattedFunction(ListVariable::formatted).build();

    public VariableInfo<List> getVariableInfo() {
        return variableInfo;
    }

    public static ListVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new ListVariable(data.getString(context), expirationTime);
    }

    public static String toString(Collection<String> value, String delimiter) {
        return value.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public static String toString(Collection<String> value) {
        return value.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public static List<String> fromString(String data) {
        return Arrays.asList(data.split(","));
    }

    public static String formatted(Collection<String> value) {
        return ListVariable.toString(value, ", ");
    }

    public static ListVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof List) {
            List list = (List)o;
            String test = list.stream().map(String::valueOf).collect(Collectors.joining(","));
            return new ListVariable(test, expirationTime);
        }
        return new ListVariable(String.valueOf(o), expirationTime);
    }

    public ListVariable(String value, long expirationTime) {
        super(expirationTime);
        this.build(value);
    }

    public ListVariable(String value) {
        this.build(value);
    }

    public void build(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value.addAll(ListVariable.fromString(value));
    }

    public void append(@NotNull String value) {
        if (value.isEmpty()) {
            return;
        }
        if (value.contains(",")) {
            this.value.addAll(this.parse(value));
            return;
        }
        this.value.add(value);
    }

    public void remove(int value) {
        if (value < 0 || value >= this.value.size()) {
            return;
        }
        this.value.remove(value);
    }

    public String get(int value) {
        if (value < 0 || value >= this.value.size()) {
            return null;
        }
        return this.value.get(value);
    }

    public static String getWithPipeDefault(List<String> list, String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            String[] split;
            if (value.contains("|") && (split = value.split("\\|")).length > 1) {
                String key = split[0];
                String def = split[1];
                return Objects.requireNonNullElse(list.get(Integer.parseInt(key)), def);
            }
            return list.get(Integer.parseInt(value));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String reverse(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.reversed().stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public static String sort(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.stream().sorted().map(Object::toString).collect(Collectors.joining(","));
    }

    public String sortNumerically(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.stream().map(Double::parseDouble).sorted().map(Object::toString).collect(Collectors.joining(","));
    }

    private List<String> parse(@NotNull String value) {
        return Arrays.asList((String[])Arrays.stream(value.split(",")).filter(s2 -> !s2.isEmpty()).toArray(String[]::new));
    }

    @Override
    public List<String> get() {
        return this.value;
    }

    @Override
    public List<String> getValueClone() {
        return Lists.newArrayList(this.value);
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.append(data.getString(context));
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.remove(data.getInt(context));
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        List<String> newList = this.parse(data.getString(context));
        return this.value.equals(newList);
    }

    @Override
    public boolean checkContainsAll(PolymorphicPlaceholder data, PlaceholderContext context) {
        List<String> newList = this.parse(data.getString(context));
        return new HashSet<String>(this.value).containsAll(new HashSet<String>(newList));
    }

    @Override
    public String toString() {
        return ListVariable.toString(this.value);
    }

    @Override
    public String formatted() {
        return ListVariable.toString(this.value, ", ");
    }

    public List<String> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListVariable)) {
            return false;
        }
        ListVariable other = (ListVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$value = this.getValue();
        List<String> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

