/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;

public class LocationVariable
extends Variable {
    private AbstractLocation value;
    public static final VariableInfo<AbstractLocation> variableInfo = VariableInfo.builder().clazz(LocationVariable.class).type(VariableType.LOCATION).typeName("Location").valueClass(AbstractLocation.class).objectConstructor(LocationVariable::ofObject).polymorphicConstructor(LocationVariable::of).toStringFunction(LocationVariable::toString).fromStringFunction(LocationVariable::fromString).formattedFunction(LocationVariable::formatted).build();

    public VariableInfo<AbstractLocation> getVariableInfo() {
        return variableInfo;
    }

    public static LocationVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new LocationVariable(data.getString(context), expirationTime);
    }

    public static String toString(AbstractLocation data) {
        return data.getWorld().getName() + "," + data.getX() + "," + data.getY() + "," + data.getZ();
    }

    public static AbstractLocation fromString(String data) {
        return AbstractLocation.deserializeFromVariableLocation(data);
    }

    public static String formatted(AbstractLocation data) {
        return String.valueOf(data.getWorld()) + ", " + data.getX() + ", " + data.getY() + ", " + data.getZ();
    }

    public static LocationVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof AbstractLocation) {
            AbstractLocation loc = (AbstractLocation)o;
            return new LocationVariable(loc, (long)expirationTime);
        }
        if (o instanceof Location) {
            Location loc = (Location)o;
            return new LocationVariable(BukkitAdapter.adapt(loc), (long)expirationTime);
        }
        return new LocationVariable(String.valueOf(o), (long)expirationTime);
    }

    public LocationVariable(AbstractLocation value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public LocationVariable(AbstractLocation value, long expirationTime) {
        super(expirationTime);
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public LocationVariable(String value) {
        this(LocationVariable.fromString(value));
    }

    public LocationVariable(String value, long expirationTime) {
        this(AbstractLocation.deserializeFromVariableLocation(value), expirationTime);
    }

    @Override
    public AbstractLocation get() {
        return this.value;
    }

    @Override
    public AbstractLocation getValueClone() {
        return this.value.clone();
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        String processedData = data.getString(context);
        List<String> split = Arrays.asList(processedData.trim().split(","));
        if (split.size() == 4) {
            split.remove(0);
        }
        if (split.size() == 3) {
            try {
                double x = Double.parseDouble(split.get(0).trim());
                double y = Double.parseDouble(split.get(1).trim());
                double z = Double.parseDouble(split.get(2).trim());
                this.value.setX(this.value.getX() + x);
                this.value.setY(this.value.getY() + y);
                this.value.setZ(this.value.getZ() + z);
                return true;
            }
            catch (NumberFormatException e) {
                MythicLogger.handleMinorError(e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        String processedData = data.getString(context);
        String[] split = processedData.trim().split(",");
        if (split.length == 3) {
            try {
                double x = Double.parseDouble(split[0].trim());
                double y = Double.parseDouble(split[1].trim());
                double z = Double.parseDouble(split[2].trim());
                this.value.setX(this.value.getX() - x);
                this.value.setY(this.value.getY() - y);
                this.value.setZ(this.value.getZ() - z);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        AbstractLocation newLocation = AbstractLocation.deserializeFromVariableLocation(data.getString(context));
        return this.value.equals(newLocation);
    }

    @Override
    public String toString() {
        return LocationVariable.toString(this.value);
    }

    @Override
    public Variable clone() {
        AbstractLocation newLocation = new AbstractLocation(this.value.getWorld(), this.value.getX(), this.value.getY(), this.value.getZ());
        return new LocationVariable(newLocation);
    }

    public AbstractLocation getValue() {
        return this.value;
    }

    public void setValue(AbstractLocation value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationVariable)) {
            return false;
        }
        LocationVariable other = (LocationVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbstractLocation this$value = this.getValue();
        AbstractLocation other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbstractLocation $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

