/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.terminable.composite.CompositeTerminable;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import org.jetbrains.annotations.NotNull;

public abstract class RandomSpawnGenerator
implements Runnable,
Terminable,
TerminableConsumer {
    private final RandomSpawnerManager manager;
    private final CompositeTerminable registry;

    public RandomSpawnGenerator(RandomSpawnerManager manager) {
        this.manager = manager;
        this.registry = CompositeTerminable.create();
        Schedulers.async().runRepeating(this, 0L, 1L).bindWith(this);
    }

    public MythicBukkit getPlugin() {
        return (MythicBukkit)this.manager.getPlugin();
    }

    @Override
    public void run() {
        this.tick();
    }

    @Override
    public void close() {
        this.registry.terminate();
    }

    public abstract void tick();

    @Override
    @NotNull
    public <T extends AutoCloseable> T bind(@NotNull T t2) {
        this.registry.bind(t2);
        return t2;
    }

    public RandomSpawnerManager getManager() {
        return this.manager;
    }
}

