/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawnPoint {
    protected final AbstractLocation location;
    protected final SpawnPointType pointType;
    protected AbstractEntity entity;
    protected CreatureSpawnEvent.SpawnReason spawnReason;
    protected float levelMod = 1.0f;
    protected int nearbyPlayers = 0;
    protected float localMobCount = 0.0f;

    public RandomSpawnPoint(AbstractLocation location) {
        this(null, location, CreatureSpawnEvent.SpawnReason.CUSTOM, null);
    }

    public RandomSpawnPoint(AbstractLocation location, SpawnPointType pointType) {
        this(null, location, CreatureSpawnEvent.SpawnReason.NATURAL, pointType);
    }

    public RandomSpawnPoint(AbstractEntity entity, AbstractLocation location, CreatureSpawnEvent.SpawnReason spawnReason) {
        this(entity, location, spawnReason, null);
    }

    public RandomSpawnPoint(AbstractEntity entity, AbstractLocation location, CreatureSpawnEvent.SpawnReason spawnReason, SpawnPointType pointType) {
        this.entity = entity;
        this.location = location.center();
        this.spawnReason = spawnReason;
        if (pointType == null) {
            SpawnPointType pt = !location.getBlock().isOccluding() ? (location.getBlock().isLiquid() ? (location.getBlock().isLava() ? SpawnPointType.LAVA : SpawnPointType.SEA) : (location.subtract(0.0, 1.0, 0.0).getBlock().isOccluding() ? SpawnPointType.LAND : SpawnPointType.AIR)) : SpawnPointType.GROUND;
            this.pointType = pt;
        } else {
            this.pointType = pointType;
        }
    }

    public CreatureSpawnEvent.SpawnReason getReason() {
        return this.spawnReason;
    }

    public AbstractBiome getBiome() {
        return MythicProvider.get().getBootstrap().getBiome(this.location);
    }

    public AbstractWorld getWorld() {
        return this.location.getWorld();
    }

    public AbstractLocation getLocation() {
        return this.location;
    }

    public SpawnPointType getPointType() {
        return this.pointType;
    }

    public AbstractEntity getEntity() {
        return this.entity;
    }

    public CreatureSpawnEvent.SpawnReason getSpawnReason() {
        return this.spawnReason;
    }

    public float getLevelMod() {
        return this.levelMod;
    }

    public int getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    public float getLocalMobCount() {
        return this.localMobCount;
    }

    public void setEntity(AbstractEntity entity) {
        this.entity = entity;
    }

    public void setSpawnReason(CreatureSpawnEvent.SpawnReason spawnReason) {
        this.spawnReason = spawnReason;
    }

    public void setLevelMod(float levelMod) {
        this.levelMod = levelMod;
    }

    public void setNearbyPlayers(int nearbyPlayers) {
        this.nearbyPlayers = nearbyPlayers;
    }

    public void setLocalMobCount(float localMobCount) {
        this.localMobCount = localMobCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomSpawnPoint)) {
            return false;
        }
        RandomSpawnPoint other = (RandomSpawnPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getLevelMod(), other.getLevelMod()) != 0) {
            return false;
        }
        if (this.getNearbyPlayers() != other.getNearbyPlayers()) {
            return false;
        }
        if (Float.compare(this.getLocalMobCount(), other.getLocalMobCount()) != 0) {
            return false;
        }
        AbstractLocation this$location = this.getLocation();
        AbstractLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        SpawnPointType this$pointType = this.getPointType();
        SpawnPointType other$pointType = other.getPointType();
        if (this$pointType == null ? other$pointType != null : !((Object)((Object)this$pointType)).equals((Object)other$pointType)) {
            return false;
        }
        AbstractEntity this$entity = this.getEntity();
        AbstractEntity other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        CreatureSpawnEvent.SpawnReason this$spawnReason = this.getSpawnReason();
        CreatureSpawnEvent.SpawnReason other$spawnReason = other.getSpawnReason();
        return !(this$spawnReason == null ? other$spawnReason != null : !this$spawnReason.equals(other$spawnReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RandomSpawnPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getLevelMod());
        result = result * 59 + this.getNearbyPlayers();
        result = result * 59 + Float.floatToIntBits(this.getLocalMobCount());
        AbstractLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        SpawnPointType $pointType = this.getPointType();
        result = result * 59 + ($pointType == null ? 43 : ((Object)((Object)$pointType)).hashCode());
        AbstractEntity $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        CreatureSpawnEvent.SpawnReason $spawnReason = this.getSpawnReason();
        result = result * 59 + ($spawnReason == null ? 43 : $spawnReason.hashCode());
        return result;
    }

    public String toString() {
        return "RandomSpawnPoint(location=" + String.valueOf(this.getLocation()) + ", pointType=" + String.valueOf((Object)this.getPointType()) + ", entity=" + String.valueOf(this.getEntity()) + ", spawnReason=" + String.valueOf(this.getSpawnReason()) + ", levelMod=" + this.getLevelMod() + ", nearbyPlayers=" + this.getNearbyPlayers() + ", localMobCount=" + this.getLocalMobCount() + ")";
    }
}

