/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_21_R6;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileItemHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.gson.GsonProvider;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.volatilecode.v1_21_R6.VolatileCompoundTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;

public class VolatileItemHandlerImpl
implements VolatileItemHandler {
    private final Reflector<CraftItemStack> refItemStack = new Reflector<CraftItemStack>(CraftItemStack.class, "handle");

    public VolatileItemHandlerImpl(VolatileCodeHandler handler) {
    }

    private net.minecraft.world.item.ItemStack getNMSItemStack(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack;
        if (itemStack instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)itemStack;
            nmsItemStack = (net.minecraft.world.item.ItemStack)this.refItemStack.get(craftItemStack, "handle");
        } else {
            nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        }
        return nmsItemStack;
    }

    @Override
    public void destroyItem(ItemStack itemStack) {
        CraftItemStack craftItemStack;
        net.minecraft.world.item.ItemStack realStack;
        if (itemStack instanceof CraftItemStack && (realStack = (net.minecraft.world.item.ItemStack)this.refItemStack.get(craftItemStack = (CraftItemStack)itemStack, "handle")) != null) {
            realStack.e(0);
        }
    }

    @Override
    public ItemStack addNBTData(ItemStack itemStack, String key, Tag value) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.getNMSItemStack(itemStack);
        Object nbt = this.getNBTData(itemStack).builder(builder -> builder.put(key, value)).getValue();
        NBTTagCompound volatileNbt = new VolatileCompoundTag((Map<String, Tag>)nbt).toNMSTag();
        nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)volatileNbt));
        if (itemStack instanceof CraftItemStack) {
            return itemStack;
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getNBTData(ItemStack itemStack) {
        CustomData customDataComponent;
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && (customDataComponent = (CustomData)nmsItemStack.a(DataComponents.b)) != null && !customDataComponent.a()) {
            return VolatileCompoundTag.fromNMSTag(customDataComponent.b());
        }
        return new VolatileCompoundTag(new HashMap<String, Tag>());
    }

    @Override
    public ItemStack setNBTData(ItemStack itemStack, CompoundTag compoundTag) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.getNMSItemStack(itemStack);
        nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)((VolatileCompoundTag)compoundTag).toNMSTag()));
        if (itemStack instanceof CraftItemStack) {
            return itemStack;
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack setNBTData(ItemStack itemStack, CompoundTag compoundTag, PlaceholderMeta meta) {
        net.minecraft.world.item.ItemStack nmsItemStack = this.getNMSItemStack(itemStack);
        nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)((VolatileCompoundTag)compoundTag).toNMSTag(meta)));
        if (itemStack instanceof CraftItemStack) {
            return itemStack;
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public String serializeItem(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        return "";
    }

    @Override
    public Map<String, Object> getComponentData(ItemStack bukkitItemStack) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)bukkitItemStack);
        TextComponent.Builder visualOutput = Component.text();
        StringBuilder itemCommandBuilder = new StringBuilder();
        Set<DataComponentType> referencedComponentTypes = Collections.newSetFromMap(new IdentityHashMap());
        DataComponentPatch patch = itemStack.d();
        referencedComponentTypes.addAll(patch.b().stream().map(Map.Entry::getKey).toList());
        DataComponentMap prototype = itemStack.h().f();
        referencedComponentTypes.addAll(prototype.b());
        IRegistryCustom.Dimension access = MinecraftServer.getServer().bg();
        RegistryOps ops = access.a((DynamicOps)JsonOps.INSTANCE);
        IRegistry registry = access.f(Registries.r);
        ArrayList componentComponents = new ArrayList();
        ArrayList commandComponents = new ArrayList();
        ConcurrentMap ret = Maps.newConcurrentMap();
        for (DataComponentType type : referencedComponentTypes) {
            Object bbb;
            Codec aaa;
            String path = ((ResourceKey)registry.d((Object)type).orElseThrow()).a().a();
            Optional patchedValue = patch.a(type);
            TypedDataComponent prototypeValue = prototype.b(type);
            if (patchedValue != null) {
                if (patchedValue.isEmpty()) continue;
                aaa = type.c();
                bbb = aaa.encodeStart((DynamicOps)ops, patchedValue.get());
                Object ccc = bbb.getOrThrow();
                ret.put(path, ccc);
                continue;
            }
            if (prototypeValue == null) continue;
            aaa = prototypeValue.a((DynamicOps)ops);
            bbb = aaa.getOrThrow();
            ret.put(path, bbb);
        }
        return ret;
    }

    @Override
    public String dumpComponentData(ItemStack bukkitItemStack) {
        return GsonProvider.standard().toJson((Object)this.getNBTData(bukkitItemStack));
    }

    @Override
    public String dumpNBTData(ItemStack itemStack) {
        CustomData customDataComponent;
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && (customDataComponent = (CustomData)nmsItemStack.a(DataComponents.b)) != null && !customDataComponent.a()) {
            return customDataComponent.toString();
        }
        return "";
    }

    @Override
    public int spawnFakeItem(Player player, ItemStack itemStack, AbstractLocation location) {
        EntityItem item = new EntityItem((World)((CraftWorld)BukkitAdapter.adapt(location.getWorld())).getHandle(), location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        item.a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity(item.az(), item.cT(), location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, EntityTypes.au, 0, Vec3D.c, 0.0);
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(item.az(), item.aC().c());
        Schedulers.async().run(() -> {
            ((CraftPlayer)player).getHandle().g.b((Packet)spawnItem);
            ((CraftPlayer)player).getHandle().g.b((Packet)data);
        });
        return item.az();
    }

    @Override
    public void collectFakeItem(Player player, int id) {
        int playerID = ((CraftPlayer)player).getHandle().az();
        PacketPlayOutCollect spawnItem = new PacketPlayOutCollect(id, playerID, 1);
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().g.b((Packet)spawnItem));
    }

    public void updateFakeItem(Player player, int id, ItemStack itemStack, AbstractLocation location) {
        EntityItem item = new EntityItem((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        item.a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        PacketPlayOutEntityMetadata data = new PacketPlayOutEntityMetadata(item.az(), item.aC().c());
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().g.b((Packet)data));
    }

    @Override
    public void destroyFakeItem(Player player, int id) {
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{id});
        Schedulers.async().run(() -> ((CraftPlayer)player).getHandle().g.b((Packet)destroyPacket));
    }

    public void playTotemEffect(AbstractPlayer player, int modelId) {
    }

    @Override
    public float getItemRecharge(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.G(0.0f);
    }

    @Override
    public boolean getItemRecharging(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.G(0.0f) < 1.0f;
    }

    @Override
    public void resetItemRecharge(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        ep.gV();
    }

    @Override
    public void setTridentItem(Trident entity, ItemStack item) {
        ((CraftTrident)entity).setItem(item);
    }

    @Override
    public ItemStack setDisplayName(ItemStack itemStack, Component displayName) {
        return null;
    }

    @Override
    public ItemStack setLore(ItemStack itemStack, Collection<Component> lore) {
        return null;
    }

    @Override
    public ItemStack setCanPlaceOn(ItemStack itemStack, Collection<Material> materials) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        HolderGetter holderGetter = (HolderGetter)CraftRegistry.getMinecraftRegistry().a(Registries.i).orElseThrow();
        List<Block> blocks = materials.stream().map(it -> {
            MinecraftKey location = MinecraftKey.a((String)it.getKey().toString());
            ResourceKey key = ResourceKey.a((MinecraftKey)location);
            return (Block)holderGetter.a(key).get();
        }).toList();
        nms.b(DataComponents.m, (Object)new AdventureModePredicate(List.of(CriterionConditionBlock.a.a().a(holderGetter, blocks).b())));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }

    @Override
    public ItemStack setCanBreak(ItemStack itemStack, Collection<Material> materials) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        HolderGetter holderGetter = (HolderGetter)CraftRegistry.getMinecraftRegistry().a(Registries.i).orElseThrow();
        List<Block> blocks = materials.stream().map(it -> {
            MinecraftKey location = MinecraftKey.a((String)it.getKey().toString());
            ResourceKey key = ResourceKey.a((MinecraftKey)location);
            return (Block)holderGetter.a(key).get();
        }).toList();
        nms.b(DataComponents.n, (Object)new AdventureModePredicate(List.of(CriterionConditionBlock.a.a().a(holderGetter, blocks).b())));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
    }

    @Override
    public Optional<String> getItemBlockStateValue(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        if (nms.c(DataComponents.aq)) {
            return Optional.ofNullable((String)((BlockItemStateProperties)nms.a(DataComponents.aq)).b().get(key));
        }
        return Optional.empty();
    }

    @Override
    public void setItemBlockStateValue(ItemStack itemStack, String key, String value) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        if (nms.c(DataComponents.aq)) {
            ((BlockItemStateProperties)nms.a(DataComponents.aq)).b().put(key, value);
        } else {
            nms.b(DataComponents.aq, (Object)new BlockItemStateProperties(Map.of(key, value)));
        }
    }

    @Override
    public void setItemBlockStateComponent(ItemStack itemStack, Map<String, String> values) {
        net.minecraft.world.item.ItemStack nms = this.getNMSItemStack(itemStack);
        nms.b(DataComponents.aq, (Object)new BlockItemStateProperties(values));
    }
}

