/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.paper.adapters.item;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlocksAttacksComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemDeathProtectionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemFoodComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemGliderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemRepairableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTooltipComponent;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.paper.adapters.item.components.consumable.PaperItemConsumableComponent;
import io.lumine.mythic.paper.adapters.item.components.consumable.PaperItemDeathProtectionComponent;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.DeathProtection;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemComponentPaperItemStack
extends ItemComponentBukkitItemStack {
    public ItemComponentPaperItemStack(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    public BukkitItemStack clone() {
        return new ItemComponentPaperItemStack(this.itemStack.clone());
    }

    @Override
    public ItemComponentPaperItemStack editMeta(Consumer<ItemMeta> block) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(this.itemStack.getType());
        }
        if (meta == null) {
            return this;
        }
        block.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public int getDurability() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                return damageable.getDamage();
            }
            if (this.itemStack.hasData((DataComponentType)DataComponentTypes.DAMAGE)) {
                return (Integer)this.itemStack.getData(DataComponentTypes.DAMAGE);
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack durability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(durability);
            this.itemStack.setItemMeta(meta);
        } else {
            this.itemStack.setData(DataComponentTypes.DAMAGE, (Object)durability);
        }
        return this;
    }

    @Override
    public int getMaxDurability() {
        Damageable damageable;
        ItemMeta itemMeta;
        if (this.itemStack.hasItemMeta() && (itemMeta = this.itemStack.getItemMeta()) instanceof Damageable && (damageable = (Damageable)itemMeta).hasMaxDamage()) {
            return damageable.getMaxDamage();
        }
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.MAX_DAMAGE)) {
            return (Integer)this.itemStack.getData(DataComponentTypes.MAX_DAMAGE);
        }
        return this.itemStack.getType().getMaxDurability();
    }

    @Override
    public ItemComponentBukkitItemStack maxDurability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setMaxDamage(Integer.valueOf(durability));
            this.itemStack.setItemMeta(meta);
        } else {
            this.itemStack.setData(DataComponentTypes.MAX_DAMAGE, (Object)durability);
        }
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyFoodComponent(AbstractItemFoodComponent foodData) {
        FoodProperties.Builder foodBuilder = this.itemStack.hasData((DataComponentType)DataComponentTypes.FOOD) ? (FoodProperties.Builder)((FoodProperties)this.itemStack.getData(DataComponentTypes.FOOD)).toBuilder() : FoodProperties.food();
        if (foodData.getCanAlwaysEat() != null) {
            foodBuilder.canAlwaysEat(foodData.getCanAlwaysEat().booleanValue());
        }
        if (foodData.getNutrition() != null) {
            foodBuilder.nutrition(foodData.getNutrition().intValue());
        }
        if (foodData.getSaturation() != null) {
            foodBuilder.saturation(foodData.getSaturation().floatValue());
        }
        this.itemStack.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)foodBuilder.build()));
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyConsumableComponent(AbstractItemConsumableComponent component) {
        PaperItemConsumableComponent consumableData = (PaperItemConsumableComponent)component;
        Consumable.Builder consumableBuilder = this.itemStack.hasData((DataComponentType)DataComponentTypes.CONSUMABLE) ? (Consumable.Builder)((Consumable)this.itemStack.getData(DataComponentTypes.CONSUMABLE)).toBuilder() : Consumable.consumable();
        if (consumableData.getConsumeSeconds() != null) {
            consumableBuilder.consumeSeconds(consumableData.getConsumeSeconds().floatValue());
        }
        if (consumableData.getHasConsumeParticles() != null) {
            consumableBuilder.hasConsumeParticles(consumableData.getHasConsumeParticles().booleanValue());
        }
        if (consumableData.getAnimation() != null) {
            try {
                ItemUseAnimation animation = ItemUseAnimation.valueOf((String)consumableData.getAnimation());
                consumableBuilder.animation(animation);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (consumableData.getSound() != null) {
            Object soundKey = consumableData.getSound().toLowerCase(Locale.ROOT);
            if (!((String)soundKey).contains(":")) {
                soundKey = "minecraft:" + (String)soundKey;
            }
            consumableBuilder.sound(Key.key((String)soundKey));
        }
        if (consumableData.getConsumeEffects() != null) {
            consumableBuilder.addEffects(consumableData.getConsumeEffects());
        }
        this.itemStack.setData(DataComponentTypes.CONSUMABLE, (Object)((Consumable)consumableBuilder.build()));
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyPotionComponent(DropMetadata dropMetadata, AbstractItemPotionComponent potionData) {
        PotionContents.Builder potionComponent = PotionContents.potionContents();
        if (potionData.getCustomName() != null) {
            potionComponent.customName(potionData.getCustomName().get(dropMetadata));
        }
        if (potionData.getPotionColor() != null) {
            potionComponent.customColor(potionData.getPotionColor().get(dropMetadata).toBukkitColor());
        }
        for (BukkitPotionEffect effect : potionData.getEffects()) {
            potionComponent.addCustomEffect(effect.getEffect());
        }
        this.itemStack.setData(DataComponentTypes.POTION_CONTENTS, (DataComponentBuilder)potionComponent);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack copy() {
        return new ItemComponentPaperItemStack(this.itemStack.clone());
    }

    @Override
    public AbstractItemStack applyTooltipComponent(AbstractItemTooltipComponent abstractItemTooltipComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            String tooltipStyle = abstractItemTooltipComponent.getTooltipStyle();
            if (tooltipStyle == null) {
                return this;
            }
            Key tooltipKey = !tooltipStyle.contains(":") ? (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isGeneratedTooltip(tooltipStyle) ? Key.key((String)"mythic", (String)tooltipStyle) : Key.key((String)"minecraft", (String)tooltipStyle)) : Key.key((String)tooltipStyle);
            this.itemStack.setData(DataComponentTypes.TOOLTIP_STYLE, (Object)tooltipKey);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyBlocksAttacksComponent(DropMetadata dropMetadata, AbstractItemBlocksAttacksComponent abstractItemBlocksAttacksComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            // empty if block
        }
        return this;
    }

    @Override
    public AbstractItemStack applyGliderComponent(DropMetadata dropMetadata, AbstractItemGliderComponent abstractItemGliderComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            this.itemStack.setData(DataComponentTypes.GLIDER);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyRepairableComponent(DropMetadata dropMetadata, AbstractItemRepairableComponent abstractItemRepairableComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            // empty if block
        }
        return this;
    }

    @Override
    public AbstractItemStack applyDeathProtectionComponent(DropMetadata dropMetadata, AbstractItemDeathProtectionComponent component) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            PaperItemDeathProtectionComponent consumableData = (PaperItemDeathProtectionComponent)component;
            DeathProtection.Builder consumableBuilder = DeathProtection.deathProtection();
            if (consumableData.getConsumeEffects() != null) {
                consumableBuilder.addEffects(consumableData.getConsumeEffects());
            }
            this.itemStack.setData(DataComponentTypes.DEATH_PROTECTION, (DataComponentBuilder)consumableBuilder);
        }
        return this;
    }
}

