/*
 * Decompiled with CFR 0.152.
 */
package fr.light_vana_mod.nicofighter45.main.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.light_vana_mod.nicofighter45.main.gui.CustomCraftingScreenHandler;
import fr.light_vana_mod.nicofighter45.main.gui.CustomPlayerManagementScreenHandler;
import fr.light_vana_mod.nicofighter45.main.server.ServerInitializer;
import fr.light_vana_mod.nicofighter45.main.server.commands.ExtendedGameProfile;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2196;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Command {
    private static final String LANG_COMMAND_PREFIX = "commands.vana-mod.";

    public static void registerAllCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast").requires(source -> source.method_9259(4))).executes(c -> {
            Command.sendOpErrorMsg((CommandContext<class_2168>)c, "broadcast.error");
            return 1;
        })).then(class_2170.method_9244((String)"message", (ArgumentType)class_2196.method_9340()).executes(c -> {
            String msg = class_2196.method_9339((CommandContext)c, (String)"message").getString().replace("{value}", class_2196.method_9339((CommandContext)c, (String)"message").getString());
            for (class_3222 player : ((class_2168)c.getSource()).method_9211().method_3760().method_14571()) {
                player.method_43496((class_2561)class_2561.method_43470((String)("\u00a78[\u00a74BROADCAST\u00a78] \u00a7f" + msg)));
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a78[\u00a74BROADCAST\u00a78] \u00a7f" + msg)), true);
            }
            Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "broadcast.done", class_2196.method_9339((CommandContext)c, (String)"message").getString());
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pvp").requires(source -> source.method_9259(4))).executes(c -> {
            Objects.requireNonNull(((class_2168)c.getSource()).method_9211()).method_3815(!((class_2168)c.getSource()).method_9211().method_3852());
            Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "pvp.done", Boolean.toString(((class_2168)c.getSource()).method_9211().method_3852()));
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"freeze").requires(source -> source.method_9259(2))).executes(c -> {
            Command.sendOpErrorMsg((CommandContext<class_2168>)c, "freeze.error");
            return 1;
        })).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(c -> {
            Collection targets = class_2191.method_9330((CommandContext)c, (String)"targets");
            for (GameProfile gameProfile : targets) {
                UUID uuid = gameProfile.getId();
                class_3222 player = ((class_2168)c.getSource()).method_9211().method_3760().method_14602(uuid);
                if (player == null) {
                    Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "op.failed", gameProfile.getName(), false);
                    continue;
                }
                if (ServerInitializer.frozenPlayer.contains(uuid)) {
                    Command.sendMsg(player, "freeze.deactivate");
                    ServerInitializer.frozenPlayer.remove(uuid);
                    Command.sendMsg(player, "freeze.deactivate");
                    Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "freeze.deactivate_op_msg", player.method_5820());
                } else {
                    ServerInitializer.frozenPlayer.add(uuid);
                    Command.sendMsg(player, "freeze.activate");
                    Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "freeze.activate_op_msg", player.method_5820());
                }
                ServerInitializer.sendInfoToClient(player);
            }
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"op").requires(source -> source.method_9259(3))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(c -> {
            Collection targets = class_2191.method_9330((CommandContext)c, (String)"targets");
            int level = IntegerArgumentType.getInteger((CommandContext)c, (String)"level");
            class_3324 playerManager = ((class_2168)c.getSource()).method_9211().method_3760();
            for (GameProfile gameProfile : targets) {
                class_3222 serverPlayerEntity = playerManager.method_14602(gameProfile.getId());
                if (serverPlayerEntity == null) {
                    Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "op.failed", gameProfile.getName(), false);
                    continue;
                }
                if (playerManager.method_14569(gameProfile)) {
                    playerManager.method_14604(gameProfile);
                }
                playerManager.method_14582((GameProfile)new ExtendedGameProfile(gameProfile, level));
                ServerInitializer.sendInfoToClient(gameProfile.getId(), ((class_2168)c.getSource()).method_9211());
                Command.sendOpFeedbackMsg((CommandContext<class_2168>)c, "op.feedback", gameProfile.getName(), String.valueOf(level));
                Command.sendMsg(serverPlayerEntity, "op.update", String.valueOf(level));
            }
            return 1;
        })))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"craft").requires(source -> source.method_9259(1))).executes(c -> {
            class_3222 server_player = ((class_2168)c.getSource()).method_9207();
            server_player.method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return class_2246.field_9980.method_9518();
                }

                @NotNull
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new CustomCraftingScreenHandler(syncId, inv, class_3914.method_17392((class_1937)player.method_5770(), (class_2338)player.method_24515()));
                }
            });
            server_player.method_7281(class_3468.field_15368);
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ec").requires(source -> source.method_9259(1))).executes(c -> {
            class_3222 server_player = ((class_2168)c.getSource()).method_9207();
            server_player.method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return class_2246.field_10443.method_9518();
                }

                @NotNull
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return class_1707.method_19245((int)syncId, (class_1661)inv, (class_1263)player.method_7274());
                }
            });
            server_player.method_7281(class_3468.field_15424);
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hat").requires(source -> source.method_9259(1))).executes(c -> {
            class_3222 player = ((class_2168)c.getSource()).method_9207();
            class_1799 hand = player.method_6047();
            if (hand.method_7909() == class_1802.field_8162) {
                Command.sendMsg(player, "hat.empty_hand_error");
                return 1;
            }
            if (hand.method_7947() != 1) {
                Command.sendMsg(player, "hat.more_than_1_item_error");
                return 1;
            }
            class_1799 helmet = player.method_31548().method_7372(3);
            player.method_31548().method_7378(hand);
            if (helmet.method_7909() != class_1802.field_8162) {
                player.method_31548().method_7394(helmet);
            }
            player.method_31548().method_5441(39);
            player.method_31548().method_7367(39, hand);
            Command.sendMsg(player, "hat.done");
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dim").requires(source -> source.method_9259(4))).executes(c -> {
            Command.sendOpErrorMsg((CommandContext<class_2168>)c, "dim.error");
            return 1;
        })).then(class_2170.method_9247((String)"overworld").executes(c -> {
            class_3222 player = ((class_2168)c.getSource()).method_9207();
            class_3218 overworld = Objects.requireNonNull(player.method_5682()).method_30002();
            if (overworld == player.method_51469()) {
                Command.sendMsg(player, "error_overworld");
            } else {
                player.method_14251(overworld, (double)overworld.method_43126().method_10263(), (double)overworld.method_43126().method_10264(), (double)overworld.method_43126().method_10260(), 0.0f, 0.0f);
                Command.sendMsg(player, "done_overworld");
            }
            return 1;
        }))).then(class_2170.method_9247((String)"nether").executes(c -> {
            class_3222 player = ((class_2168)c.getSource()).method_9207();
            class_3218 nether = Objects.requireNonNull(player.method_5682()).method_3847(class_1937.field_25180);
            assert (nether != null);
            if (nether == player.method_51469()) {
                Command.sendMsg(player, "error_nether");
            } else {
                player.method_14251(nether, (double)nether.method_43126().method_10263(), (double)nether.method_43126().method_10264(), (double)nether.method_43126().method_10260(), 0.0f, 0.0f);
                Command.sendMsg(player, "done_nether");
            }
            return 1;
        }))).then(class_2170.method_9247((String)"end").executes(c -> {
            class_3222 player = ((class_2168)c.getSource()).method_9207();
            class_3218 end = Objects.requireNonNull(player.method_5682()).method_3847(class_1937.field_25181);
            assert (end != null);
            if (end == player.method_51469()) {
                Command.sendMsg(player, "error_end");
            } else {
                player.method_14251(end, 0.0, 100.0, 0.0, 0.0f, 0.0f);
                Command.sendMsg(player, "done_end");
            }
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invsee").requires(source -> source.method_9259(2))).executes(c -> {
            Command.sendOpErrorMsg((CommandContext<class_2168>)c, "invsee.error");
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> {
            class_3222 player = ((class_2168)c.getSource()).method_9207();
            final class_3222 player_to_see = class_2186.method_9315((CommandContext)c, (String)"player");
            Command.sendMsg(player, "invsee.done", player_to_see.method_5820());
            player.method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return class_2561.method_30163((String)player_to_see.method_5820());
                }

                @NotNull
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new CustomPlayerManagementScreenHandler(syncId, player.method_31548(), player_to_see.method_31548());
                }
            });
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ecsee").requires(source -> source.method_9259(2))).executes(c -> {
            Command.sendOpErrorMsg((CommandContext<class_2168>)c, "ecsee.error");
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> {
            class_3222 player = ((class_2168)c.getSource()).method_9207();
            final class_3222 player_to_see = class_2186.method_9315((CommandContext)c, (String)"player");
            Command.sendMsg(player, "ecsee.done", player_to_see.method_5820());
            player.method_17355(new class_3908(){

                public class_2561 method_5476() {
                    return class_2561.method_43470((String)class_2561.method_43471((String)"commands.vana-mod.ecsse.name").toString().replace("{value}", player_to_see.method_5820()));
                }

                @NotNull
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new class_1707(class_3917.field_17326, syncId, inv, (class_1263)player_to_see.method_7274(), 3);
                }
            });
            return 1;
        }))));
    }

    private static void sendMsg(@NotNull class_3222 player, String text) {
        player.method_7353(Command.getMsgFrom(text), false);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    private static class_2561 getMsgFrom(String text) {
        return class_2561.method_43471((String)(LANG_COMMAND_PREFIX + text));
    }

    private static void sendMsg(@NotNull class_3222 player, String text, String replace) {
        Command.sendMsg(player, text, replace, true);
    }

    private static void sendMsg(@NotNull class_3222 player, String text, String replace, boolean prefix) {
        if (prefix) {
            player.method_7353(class_2561.method_30163((String)class_2561.method_43471((String)(LANG_COMMAND_PREFIX + text)).getString().replace("{value}", replace)), false);
        } else {
            player.method_7353(class_2561.method_30163((String)class_2561.method_43471((String)(LANG_COMMAND_PREFIX + text)).getString().replace("{value}", replace)), false);
        }
    }

    private static void sendOpFeedbackMsg(@NotNull CommandContext<class_2168> c, String text, String replace) {
        Command.sendOpFeedbackMsg(c, text, replace, true);
    }

    private static void sendOpFeedbackMsg(@NotNull CommandContext<class_2168> c, String text, String replace1, String replace2) {
        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)class_2561.method_43471((String)(LANG_COMMAND_PREFIX + text)).getString().replace("{value1}", replace1).replace("{value2}", replace2)), true);
    }

    private static void sendOpFeedbackMsg(@NotNull CommandContext<class_2168> c, String text, String replace, boolean broadcast) {
        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)class_2561.method_43471((String)(LANG_COMMAND_PREFIX + text)).getString().replace("{value}", replace)), broadcast);
    }

    private static void sendOpErrorMsg(@NotNull CommandContext<class_2168> c, String text) {
        ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)(LANG_COMMAND_PREFIX + text)));
    }
}

