/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.renderer;

import com.khazoda.basicstorage.mixin.RenderSystemAccessor;
import com.khazoda.basicstorage.registry.DataComponentRegistry;
import com.khazoda.basicstorage.structure.CrateSlotComponent;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CrateItemRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer,
ModelLoadingPlugin {
    public static final class_2960 CRATE_ID = class_2960.method_60655((String)"basicstorage", (String)"block/crate");
    private static final Quaternionf ITEM_LIGHT_ROTATION_3D = class_7833.field_40714.rotationDegrees(-15.0f).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(15.0f));
    private static final Quaternionf ITEM_LIGHT_ROTATION_FLAT = class_7833.field_40714.rotationDegrees(-45.0f);

    public void render(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumerProvider, int light, int overlay) {
        class_310 client = class_310.method_1551();
        class_918 itemRenderer = client.method_1480();
        class_1092 modelManager = client.method_1554();
        class_1087 crateModel = modelManager.getModel(CRATE_ID);
        if (!mode.equals((Object)class_811.field_4317) || !stack.method_57826(DataComponentRegistry.CRATE_CONTENTS)) {
            this.renderCrate(stack, mode, matrices, vertexConsumerProvider, light, overlay, itemRenderer, crateModel, false);
        } else if (stack.method_57826(DataComponentRegistry.CRATE_CONTENTS)) {
            this.renderCrate(stack, mode, matrices, vertexConsumerProvider, light, overlay, itemRenderer, crateModel, true);
            ItemVariant item = Objects.requireNonNull((CrateSlotComponent)stack.method_57824(DataComponentRegistry.CRATE_CONTENTS)).item();
            this.renderCrateContents(itemRenderer, item, light, matrices, vertexConsumerProvider);
        }
    }

    private void renderCrate(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumerProvider, int light, int overlay, class_918 itemRenderer, class_1087 crateModel, boolean hasContents) {
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        if (hasContents) {
            itemRenderer.method_23179(stack, mode, false, matrices, vertexConsumerProvider, Math.round((float)light / 1.5f), overlay, crateModel);
        } else {
            itemRenderer.method_23179(stack, mode, false, matrices, vertexConsumerProvider, light, overlay, crateModel);
        }
        crateModel.method_4709().method_3503(mode).method_23075(false, matrices);
        matrices.method_22909();
    }

    private void renderCrateContents(class_918 itemRenderer, ItemVariant item, int light, class_4587 matrices, class_4597 vertexConsumers) {
        if (item.isBlank()) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 1.0f);
        matrices.method_22905(0.7f, 0.7f, 1.0f);
        class_1799 stack = item.toStack();
        class_1087 model = itemRenderer.method_4019(stack, null, null, 0);
        Vector3f[] lights = new Vector3f[2];
        System.arraycopy(RenderSystemAccessor.getShaderLightDirections(), 0, lights, 0, 2);
        if (model.method_24304()) {
            matrices.method_23760().method_23762().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D);
            class_308.method_24211();
        } else {
            matrices.method_23760().method_23762().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT);
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_811.field_4317, false, matrices, vertexConsumers, light, class_4608.field_21444, model);
        System.arraycopy(lights, 0, RenderSystemAccessor.getShaderLightDirections(), 0, 2);
        matrices.method_22909();
    }

    private static void flipHorizontally(class_4587 matrix) {
        matrix.method_22907(new Quaternionf(0.24, -0.37, -0.1, 0.89));
        matrix.method_22907(new Quaternionf(0.24, 0.37, 0.1, 0.89).invert());
    }

    public void onInitializeModelLoader(ModelLoadingPlugin.Context pluginContext) {
        pluginContext.addModels(new class_2960[]{CRATE_ID});
    }
}

