/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage;

import com.khazoda.basicstorage.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class BasicStorageConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("basicstorage.properties");
    private static BasicStorageConfig INSTANCE;
    private final Properties properties = new Properties();

    private BasicStorageConfig() {
    }

    public static BasicStorageConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BasicStorageConfig();
        }
        return INSTANCE;
    }

    public void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                    writer.write("# Basic Storage Configuration\n\n");
                    writer.write("# If true, crates can only be broken using an axe.\n");
                    writer.write("# If false, crates can be broken with anything.\n");
                    writer.write("break_with_axe_only=false\n\n");
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                this.properties.load(reader);
            }
            Constants.BS_LOG.info("[Basic Storage] Config loaded successfully");
        }
        catch (IOException e) {
            Constants.BS_LOG.error("[Basic Storage] Failed to load config: " + e.getMessage());
        }
    }

    public boolean breakWithAxeOnly() {
        return Boolean.parseBoolean(this.properties.getProperty("break_with_axe_only", "false"));
    }

    public void setBreakWithAxeOnly(boolean value) {
        this.properties.setProperty("break_with_axe_only", String.valueOf(value));
    }
}

